/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.FQMethod;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class JPAIssues
extends BytecodeScanningDetector {
    private static JavaClass runtimeExceptionClass;
    private static final Pattern annotationClassPattern;
    private BugReporter bugReporter;
    private JavaClass cls;
    private OpcodeStack stack;
    private Map<FQMethod, TransactionalType> transactionalMethods;
    private boolean isEntity;
    private boolean hasId;
    private boolean hasGeneratedValue;
    private boolean hasEagerOneToMany;
    private boolean hasFetch;
    private boolean hasHCEquals;
    private TransactionalType methodTransType;
    private boolean isPublic;

    public JPAIssues(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext clsContext) {
        try {
            this.cls = clsContext.getJavaClass();
            this.catalogClass(this.cls);
            if (this.isEntity) {
                if (this.hasHCEquals && this.hasId && this.hasGeneratedValue) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.JPAI_HC_EQUALS_ON_MANAGED_ENTITY.name(), 3).addClass(this.cls));
                }
                if (this.hasEagerOneToMany && !this.hasFetch) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.JPAI_INEFFICIENT_EAGER_FETCH.name(), 3).addClass(this.cls));
                }
            }
            if (!this.transactionalMethods.isEmpty()) {
                this.stack = new OpcodeStack();
                super.visitClassContext(clsContext);
            }
        }
        finally {
            this.transactionalMethods = null;
            this.stack = null;
        }
    }

    public void visitMethod(Method obj) {
        int access = this.getMethod().getAccessFlags();
        if ((access & 0x1000) != 0) {
            return;
        }
        this.methodTransType = this.getTransactionalType(obj);
        if (this.methodTransType != TransactionalType.NONE && !obj.isPublic()) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.JPAI_TRANSACTION_ON_NON_PUBLIC_METHOD.name(), 2).addClass((PreorderVisitor)this).addMethod(this.cls, obj));
        }
        if (this.methodTransType == TransactionalType.WRITE && runtimeExceptionClass != null) {
            try {
                Set<JavaClass> annotatedRollBackExceptions = this.getAnnotatedRollbackExceptions(obj);
                Set<JavaClass> declaredExceptions = this.getDeclaredExceptions(obj);
                this.reportExceptionMismatch(obj, annotatedRollBackExceptions, declaredExceptions, false, BugType.JPAI_NON_SPECIFIED_TRANSACTION_EXCEPTION_HANDLING);
                this.reportExceptionMismatch(obj, declaredExceptions, annotatedRollBackExceptions, true, BugType.JPAI_UNNECESSARY_TRANSACTION_EXCEPTION_HANDLING);
            }
            catch (ClassNotFoundException cnfe) {
                this.bugReporter.reportMissingClass(cnfe);
            }
        }
        super.visitMethod(obj);
    }

    public void visitCode(Code obj) {
        int access = this.getMethod().getAccessFlags();
        if ((access & 0x1000) != 0) {
            return;
        }
        this.isPublic = (access & 1) != 0;
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        OpcodeStack.Item itm;
        JPAUserValue userValue = null;
        try {
            switch (seen) {
                case 182: 
                case 185: {
                    String dottedCls = this.getDottedClassConstantOperand();
                    String methodName = this.getNameConstantOperand();
                    String signature = this.getSigConstantOperand();
                    TransactionalType calledMethodTransType = this.getTransactionalType(new FQMethod(dottedCls, methodName, signature));
                    if (calledMethodTransType != TransactionalType.NONE && !TransactionalType.isContainedBy(calledMethodTransType, this.methodTransType)) {
                        OpcodeStack.Item itm2;
                        Type[] parmTypes = Type.getArgumentTypes((String)signature);
                        if (this.stack.getStackDepth() > parmTypes.length && (itm2 = this.stack.getStackItem(parmTypes.length)).getRegisterNumber() == 0) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.JPAI_NON_PROXIED_TRANSACTION_CALL.name(), this.isPublic ? 2 : 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                    }
                    if (!"javax.persistence.EntityManager".equals(dottedCls)) return;
                    if (!"merge".equals(methodName)) return;
                    userValue = JPAUserValue.MERGE;
                    return;
                }
                case 87: {
                    if (this.stack.getStackDepth() <= 0) return;
                    itm = this.stack.getStackItem(0);
                    if (itm.getUserValue() != JPAUserValue.MERGE) return;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.JPAI_IGNORED_MERGE_RESULT.name(), 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    return;
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (userValue != null && this.stack.getStackDepth() > 0) {
                itm = this.stack.getStackItem(0);
                itm.setUserValue(userValue);
            }
        }
    }

    private void catalogClass(JavaClass cls) {
        this.transactionalMethods = new HashMap<FQMethod, TransactionalType>();
        this.isEntity = false;
        this.hasId = false;
        this.hasGeneratedValue = false;
        this.hasEagerOneToMany = false;
        this.hasHCEquals = false;
        for (AnnotationEntry annotationEntry : cls.getAnnotationEntries()) {
            if (!"Ljavax/persistence/Entity;".equals(annotationEntry.getAnnotationType())) continue;
            this.isEntity = true;
            break;
        }
        for (AnnotationEntry annotationEntry : cls.getMethods()) {
            this.catalogFieldOrMethod((FieldOrMethod)annotationEntry);
            if ((!"equals".equals(annotationEntry.getName()) || !"(Ljava/lang/Object;)Z".equals(annotationEntry.getSignature())) && (!"hashCode".equals(annotationEntry.getName()) || !"()I".equals(annotationEntry.getSignature()))) continue;
            this.hasHCEquals = true;
        }
        for (AnnotationEntry annotationEntry : cls.getFields()) {
            this.catalogFieldOrMethod((FieldOrMethod)annotationEntry);
        }
    }

    private void catalogFieldOrMethod(FieldOrMethod fm) {
        block16: for (AnnotationEntry entry : fm.getAnnotationEntries()) {
            String type;
            switch (type = entry.getAnnotationType()) {
                case "Lorg/springframework/transaction/annotation/Transactional;": {
                    if (!(fm instanceof Method)) continue block16;
                    Boolean isWrite = Boolean.TRUE;
                    ElementValuePair[] elementValuePairArray = entry.getElementValuePairs();
                    int n = elementValuePairArray.length;
                    for (int i = 0; i < n; ++i) {
                        ElementValuePair pair = elementValuePairArray[i];
                        if (!"readOnly".equals(pair.getNameString())) continue;
                        isWrite = "false".equals(pair.getValue().stringifyValue());
                        break;
                    }
                    this.transactionalMethods.put(new FQMethod(this.cls.getClassName(), fm.getName(), fm.getSignature()), isWrite != false ? TransactionalType.WRITE : TransactionalType.READ);
                    continue block16;
                }
                case "Ljavax/persistence/Id;": {
                    this.hasId = true;
                    continue block16;
                }
                case "Ljavax/persistence/GeneratedValue;": {
                    this.hasGeneratedValue = true;
                    continue block16;
                }
                case "Ljavax/persistence/OneToMany;": {
                    for (ElementValuePair pair : entry.getElementValuePairs()) {
                        if (!"fetch".equals(pair.getNameString()) || !"EAGER".equals(pair.getValue().stringifyValue())) continue;
                        this.hasEagerOneToMany = true;
                        continue block16;
                    }
                    continue block16;
                }
                case "Lorg/hibernate/annotations/Fetch;": 
                case "Lorg/eclipse/persistence/annotations/JoinFetch;": 
                case "Lorg/eclipse/persistence/annotations/BatchFetch;": {
                    this.hasFetch = true;
                    continue block16;
                }
            }
        }
    }

    private void reportExceptionMismatch(Method method, Set<JavaClass> expectedExceptions, Set<JavaClass> actualExceptions, boolean checkByDirectionally, BugType bugType) {
        try {
            for (JavaClass declEx : actualExceptions) {
                boolean handled = false;
                for (JavaClass annotEx : expectedExceptions) {
                    if (!declEx.instanceOf(annotEx) && (!checkByDirectionally || !annotEx.instanceOf(declEx))) continue;
                    handled = true;
                    break;
                }
                if (handled || expectedExceptions.contains(declEx)) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, bugType.name(), 2).addClass((PreorderVisitor)this).addMethod(this.cls, method).addString("Exception: " + declEx.getClassName()));
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    private Set<JavaClass> getAnnotatedRollbackExceptions(Method method) throws ClassNotFoundException {
        for (AnnotationEntry annotation : method.getAnnotationEntries()) {
            if (!"Lorg/springframework/transaction/annotation/Transactional;".equals(annotation.getAnnotationType())) continue;
            if (annotation.getNumElementValuePairs() == 0) {
                return Collections.emptySet();
            }
            HashSet<JavaClass> rollbackExceptions = new HashSet<JavaClass>();
            for (ElementValuePair pair : annotation.getElementValuePairs()) {
                if (!"rollbackFor".equals(pair.getNameString()) && !"noRollbackFor".equals(pair.getNameString())) continue;
                String exNames = pair.getValue().stringifyValue();
                Matcher m = annotationClassPattern.matcher(exNames);
                while (m.find()) {
                    String exName = m.group(1);
                    JavaClass exCls = Repository.lookupClass((String)exName.substring(1, exName.length() - 1));
                    if (exCls.instanceOf(runtimeExceptionClass)) continue;
                    rollbackExceptions.add(exCls);
                }
            }
            return rollbackExceptions;
        }
        return Collections.emptySet();
    }

    private Set<JavaClass> getDeclaredExceptions(Method method) throws ClassNotFoundException {
        ExceptionTable et = method.getExceptionTable();
        if (et == null || et.getLength() == 0) {
            return Collections.emptySet();
        }
        HashSet<JavaClass> exceptions = new HashSet<JavaClass>();
        for (String en : et.getExceptionNames()) {
            JavaClass exCls = Repository.lookupClass((String)en);
            if (exCls.instanceOf(runtimeExceptionClass)) continue;
            exceptions.add(exCls);
        }
        return exceptions;
    }

    private TransactionalType getTransactionalType(Method method) {
        return this.getTransactionalType(new FQMethod(this.cls.getClassName(), method.getName(), method.getSignature()));
    }

    private TransactionalType getTransactionalType(FQMethod method) {
        TransactionalType type = this.transactionalMethods.get(method);
        if (type == null) {
            return TransactionalType.NONE;
        }
        return type;
    }

    static {
        try {
            runtimeExceptionClass = Repository.lookupClass((String)"java.lang.RuntimeException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        annotationClassPattern = Pattern.compile("(L[^;]+;)");
    }

    static enum TransactionalType {
        NONE,
        READ,
        WRITE;


        public static boolean isContainedBy(TransactionalType type, TransactionalType containedType) {
            if (type == NONE) {
                return true;
            }
            if (type == READ && (containedType == READ || containedType == WRITE)) {
                return true;
            }
            return type == WRITE && containedType == WRITE;
        }
    }

    static enum JPAUserValue {
        MERGE;

    }
}

