/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.FQMethod;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;

@OpcodeStack.CustomUserValue
public class LingeringGraphicsObjects
extends BytecodeScanningDetector {
    private static final Set<FQMethod> GRAPHICS_PRODUCERS;
    private static final Set<FQMethod> GRAPHICS_DISPOSERS;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, Integer> graphicsRegs;

    public LingeringGraphicsObjects(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.graphicsRegs = new HashMap<Integer, Integer>(5);
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.graphicsRegs = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.graphicsRegs.clear();
        super.visitCode(obj);
        for (Integer pc : this.graphicsRegs.values()) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.LGO_LINGERING_GRAPHICS_OBJECT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, pc.intValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        Integer sawNewGraphicsAt = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                    sawNewGraphicsAt = this.graphicsRegs.get(reg);
                    return;
                }
                case 58: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    sawNewGraphicsAt = (Integer)item.getUserValue();
                    Integer reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    if (sawNewGraphicsAt != null) {
                        this.graphicsRegs.put(reg, sawNewGraphicsAt);
                    } else {
                        this.graphicsRegs.remove(reg);
                    }
                    sawNewGraphicsAt = null;
                    return;
                }
                case 176: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    this.graphicsRegs.remove(item.getRegisterNumber());
                    return;
                }
                case 182: {
                    String clsName = this.getClassConstantOperand();
                    String methodName = this.getNameConstantOperand();
                    String methodSig = this.getSigConstantOperand();
                    FQMethod methodInfo = new FQMethod(clsName, methodName, methodSig);
                    if (GRAPHICS_PRODUCERS.contains(methodInfo)) {
                        sawNewGraphicsAt = this.getPC();
                        return;
                    }
                    if (!GRAPHICS_DISPOSERS.contains(methodInfo)) return;
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    this.graphicsRegs.remove(item.getRegisterNumber());
                    return;
                }
            }
            return;
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (sawNewGraphicsAt != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)sawNewGraphicsAt);
            }
        }
    }

    static {
        HashSet<FQMethod> gp = new HashSet<FQMethod>();
        gp.add(new FQMethod("java/awt/image/BufferedImage", "getGraphics", "()Ljava/awt/Graphics;"));
        gp.add(new FQMethod("java/awt/Graphics", "create", "()Ljava/awt/Graphics;"));
        GRAPHICS_PRODUCERS = Collections.unmodifiableSet(gp);
        HashSet<FQMethod> gd = new HashSet<FQMethod>();
        gd.add(new FQMethod("java/awt/Graphics", "dispose", "()V"));
        gd.add(new FQMethod("java/awt/Graphics2D", "dispose", "()V"));
        GRAPHICS_DISPOSERS = Collections.unmodifiableSet(gd);
    }
}

