/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.detect.LocalTypeDetector;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

class LocalHangingExecutor
extends LocalTypeDetector {
    private static final Map<String, Set<String>> watchedClassMethods;
    private static final Map<String, Integer> syncCtors;
    private final BugReporter bugReporter;
    private final Detector delegatingDetector;

    public LocalHangingExecutor(Detector delegatingDetector, BugReporter reporter) {
        this.bugReporter = reporter;
        this.delegatingDetector = delegatingDetector;
    }

    @Override
    protected Map<String, Integer> getWatchedConstructors() {
        return syncCtors;
    }

    @Override
    protected Map<String, Set<String>> getWatchedClassMethods() {
        return watchedClassMethods;
    }

    @Override
    protected Set<String> getSelfReturningMethods() {
        return Collections.emptySet();
    }

    @Override
    protected void reportBug(LocalTypeDetector.RegisterInfo cri) {
        this.bugReporter.reportBug(new BugInstance(this.delegatingDetector, "HES_LOCAL_EXECUTOR_SERVICE", 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine(cri.getSourceLineAnnotation()));
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        super.visitClassContext(classContext);
    }

    @Override
    public void visitCode(Code obj) {
        super.visitCode(obj);
    }

    @Override
    public void visitMethod(Method obj) {
        super.visitMethod(obj);
    }

    static {
        HashSet<String> forExecutors = new HashSet<String>();
        forExecutors.add("newCachedThreadPool");
        forExecutors.add("newFixedThreadPool");
        forExecutors.add("newScheduledThreadPool");
        forExecutors.add("newSingleThreadExecutor");
        HashMap<String, HashSet<String>> wcm = new HashMap<String, HashSet<String>>();
        wcm.put("java/util/concurrent/Executors", forExecutors);
        watchedClassMethods = Collections.unmodifiableMap(wcm);
        HashMap<String, Integer> sc = new HashMap<String, Integer>();
        sc.put("java/util/concurrent/ThreadPoolExecutor", Values.JAVA_5);
        sc.put("java/util/concurrent/ScheduledThreadPoolExecutor", Values.JAVA_5);
        syncCtors = Collections.unmodifiableMap(sc);
    }
}

