/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.detect.LocalTypeDetector;
import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@OpcodeStack.CustomUserValue
public class LocalSynchronizedCollection
extends LocalTypeDetector {
    private static final Map<String, Integer> syncCtors = new HashMap<String, Integer>();
    private static final Integer JAVA_1_1 = 45;
    private static final Map<String, Set<String>> synchClassMethods;
    private static final Set<String> selfReturningMethods;
    private BugReporter bugReporter;

    public LocalSynchronizedCollection(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    protected Map<String, Integer> getWatchedConstructors() {
        return syncCtors;
    }

    @Override
    protected Map<String, Set<String>> getWatchedClassMethods() {
        return synchClassMethods;
    }

    @Override
    protected Set<String> getSelfReturningMethods() {
        return selfReturningMethods;
    }

    @Override
    protected void reportBug(LocalTypeDetector.RegisterInfo cri) {
        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.LSYC_LOCAL_SYNCHRONIZED_COLLECTION.name(), cri.getPriority()).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine(cri.getSourceLineAnnotation()));
    }

    static {
        syncCtors.put("java/util/Vector", JAVA_1_1);
        syncCtors.put("java/util/Hashtable", JAVA_1_1);
        syncCtors.put("java/lang/StringBuffer", Values.JAVA_5);
        synchClassMethods = new HashMap<String, Set<String>>();
        HashSet<String> syncMethods = new HashSet<String>();
        syncMethods.add("synchronizedCollection");
        syncMethods.add("synchronizedList");
        syncMethods.add("synchronizedMap");
        syncMethods.add("synchronizedSet");
        syncMethods.add("synchronizedSortedMap");
        syncMethods.add("synchronizedSortedSet");
        synchClassMethods.put("java/util/Collections", syncMethods);
        selfReturningMethods = UnmodifiableSet.create("java/lang/StringBuffer.append");
    }
}

