/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.OpcodeUtils;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import com.mebigfatguy.fbcontrib.utils.ToString;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

abstract class LocalTypeDetector
extends BytecodeScanningDetector {
    private OpcodeStack stack;
    private Map<Integer, RegisterInfo> suspectLocals;
    private int classVersion;

    LocalTypeDetector() {
    }

    protected abstract Map<String, Integer> getWatchedConstructors();

    protected abstract Map<String, Set<String>> getWatchedClassMethods();

    protected abstract Set<String> getSelfReturningMethods();

    protected abstract void reportBug(RegisterInfo var1);

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.suspectLocals = new HashMap<Integer, RegisterInfo>();
            this.classVersion = classContext.getJavaClass().getMajor();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.suspectLocals = null;
        }
    }

    public void visitMethod(Method obj) {
        int[] parmRegs;
        this.suspectLocals.clear();
        for (int pr : parmRegs = RegisterUtils.getParameterRegisters(obj)) {
            this.suspectLocals.put(pr, new RegisterInfo(RegisterUtils.getLocalVariableEndRange(obj.getLocalVariableTable(), pr, 0)));
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
        for (Map.Entry<Integer, RegisterInfo> entry : this.suspectLocals.entrySet()) {
            RegisterInfo cri = entry.getValue();
            if (cri.getIgnore()) continue;
            this.reportBug(cri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        Integer tosIsSyncColReg = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 183) {
                tosIsSyncColReg = this.checkConstructors();
            } else if (seen == 184) {
                tosIsSyncColReg = this.checkStaticCreations();
            } else if (seen == 182 || seen == 185) {
                tosIsSyncColReg = this.checkSelfReturningMethods();
            } else if (OpcodeUtils.isAStore(seen)) {
                this.dealWithStoring(seen);
            } else if (OpcodeUtils.isALoad(seen)) {
                int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                RegisterInfo cri = this.suspectLocals.get(reg);
                if (cri != null && !cri.getIgnore()) {
                    tosIsSyncColReg = reg;
                }
            } else if ((seen == 181 || seen == 176) && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                this.suspectLocals.remove(item.getUserValue());
            }
            if (this.suspectLocals.size() > 0) {
                if (OpcodeUtils.isInvokeInterfaceSpecialStaticOrVirtual(seen)) {
                    String sig = this.getSigConstantOperand();
                    int argCount = Type.getArgumentTypes((String)sig).length;
                    if (this.stack.getStackDepth() >= argCount) {
                        for (int i = 0; i < argCount; ++i) {
                            OpcodeStack.Item item = this.stack.getStackItem(i);
                            RegisterInfo cri = this.suspectLocals.get(item.getUserValue());
                            if (cri == null) continue;
                            if (SignatureUtils.similarPackages(SignatureUtils.getPackageName(SignatureUtils.stripSignature(this.getClassConstantOperand())), SignatureUtils.getPackageName(SignatureUtils.stripSignature(this.getClassName())), 2)) {
                                cri.setPriority(3);
                                continue;
                            }
                            cri.setIgnore();
                        }
                    }
                } else if (seen == 194) {
                    if (this.stack.getStackDepth() > 0) {
                        OpcodeStack.Item item = this.stack.getStackItem(0);
                        this.suspectLocals.remove(item.getUserValue());
                    }
                } else if (seen == 83 && this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    this.suspectLocals.remove(item.getUserValue());
                }
            }
            this.reportTroublesomeLocals();
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (tosIsSyncColReg != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)tosIsSyncColReg);
            }
        }
    }

    protected void dealWithStoring(int seen) {
        if (this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
            if (item.getUserValue() != null) {
                if (!this.suspectLocals.containsKey(reg)) {
                    RegisterInfo cri = new RegisterInfo(SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this), RegisterUtils.getLocalVariableEndRange(this.getMethod().getLocalVariableTable(), reg, this.getNextPC()));
                    this.suspectLocals.put(reg, cri);
                }
            } else {
                RegisterInfo cri = this.suspectLocals.get(reg);
                if (cri == null) {
                    cri = new RegisterInfo(RegisterUtils.getLocalVariableEndRange(this.getMethod().getLocalVariableTable(), reg, this.getNextPC()));
                    this.suspectLocals.put(reg, cri);
                }
                cri.setIgnore();
            }
        }
    }

    protected Integer checkStaticCreations() {
        Integer tosIsSyncColReg = null;
        Map<String, Set<String>> mapOfClassToMethods = this.getWatchedClassMethods();
        for (Map.Entry<String, Set<String>> entry : mapOfClassToMethods.entrySet()) {
            if (!entry.getKey().equals(this.getClassConstantOperand()) || !entry.getValue().contains(this.getNameConstantOperand())) continue;
            tosIsSyncColReg = Values.NEGATIVE_ONE;
        }
        return tosIsSyncColReg;
    }

    protected Integer checkSelfReturningMethods() {
        Integer tosIsSyncColReg = null;
        Set<String> selfReturningMethods = this.getSelfReturningMethods();
        String methodName = this.getClassConstantOperand() + '.' + this.getNameConstantOperand();
        for (String selfRefNames : selfReturningMethods) {
            if (!methodName.equals(selfRefNames)) continue;
            Type[] parmTypes = Type.getArgumentTypes((String)this.getSigConstantOperand());
            if (this.stack.getStackDepth() <= parmTypes.length) break;
            OpcodeStack.Item item = this.stack.getStackItem(parmTypes.length);
            tosIsSyncColReg = (Integer)item.getUserValue();
            break;
        }
        return tosIsSyncColReg;
    }

    protected Integer checkConstructors() {
        Integer minVersion;
        Integer tosIsSyncColReg = null;
        if ("<init>".equals(this.getNameConstantOperand()) && (minVersion = this.getWatchedConstructors().get(this.getClassConstantOperand())) != null && this.classVersion >= minVersion) {
            tosIsSyncColReg = Values.NEGATIVE_ONE;
        }
        return tosIsSyncColReg;
    }

    protected void reportTroublesomeLocals() {
        int curPC = this.getPC();
        Iterator<RegisterInfo> it = this.suspectLocals.values().iterator();
        while (it.hasNext()) {
            RegisterInfo cri = it.next();
            if (cri.getEndPCRange() >= curPC) continue;
            if (!cri.getIgnore()) {
                this.reportBug(cri);
            }
            it.remove();
        }
    }

    protected static class RegisterInfo {
        private SourceLineAnnotation slAnnotation;
        private int priority = 1;
        private int endPCRange = Integer.MAX_VALUE;

        public RegisterInfo(SourceLineAnnotation sla, int endPC) {
            this.slAnnotation = sla;
            this.endPCRange = endPC;
        }

        public RegisterInfo(int endPC) {
            this.slAnnotation = null;
            this.endPCRange = endPC;
        }

        public SourceLineAnnotation getSourceLineAnnotation() {
            return this.slAnnotation;
        }

        public void setEndPCRange(int pc) {
            this.endPCRange = pc;
        }

        public int getEndPCRange() {
            return this.endPCRange;
        }

        public void setIgnore() {
            this.slAnnotation = null;
        }

        public boolean getIgnore() {
            return this.slAnnotation == null;
        }

        public void setPriority(int newPriority) {
            if (newPriority > this.priority) {
                this.priority = newPriority;
            }
        }

        public int getPriority() {
            return this.priority;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

