/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class MisleadingOverloadModel
extends PreorderVisitor
implements Detector {
    private final BugReporter bugReporter;

    public MisleadingOverloadModel(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass cls = classContext.getJavaClass();
        String clsName = cls.getClassName();
        Method[] methods = cls.getMethods();
        HashMap<String, MethodFoundType> declMethods = new HashMap<String, MethodFoundType>(methods.length);
        for (Method m : methods) {
            MethodFoundType newType;
            boolean report;
            String methodName = m.getName();
            if (m.isStatic()) {
                boolean bl = report = declMethods.get(methodName) == MethodFoundType.Instance;
                newType = report ? MethodFoundType.Both : MethodFoundType.Static;
            } else {
                report = declMethods.get(m.getName()) == MethodFoundType.Static;
                newType = report ? MethodFoundType.Both : MethodFoundType.Instance;
            }
            declMethods.put(methodName, newType);
            if (!report) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.MOM_MISLEADING_OVERLOAD_MODEL.name(), 2).addClass(cls).addMethod(XFactory.createXMethod((String)clsName, (Method)m)).addString(methodName));
        }
    }

    public void report() {
    }

    static enum MethodFoundType {
        Instance,
        Static,
        Both;

    }
}

