/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.FQMethod;
import com.mebigfatguy.fbcontrib.utils.ToString;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;

public class MoreDumbMethods
extends BytecodeScanningDetector {
    private static final Map<FQMethod, ReportInfo> dumbMethods = new HashMap<FQMethod, ReportInfo>();
    private static final Set<ReportInfo> assertableReports;
    private final BugReporter bugReporter;
    private boolean sawAssertionDisabled;
    private int assertionEnd;

    public MoreDumbMethods(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        if (classContext.getJavaClass().getMajor() <= 49) {
            dumbMethods.put(new FQMethod("java/security/SecureRandom", "<init>", "()V"), new ReportInfo("MDM_SECURERANDOM", 3));
            dumbMethods.put(new FQMethod("java/security/SecureRandom", "<init>", "([B)V"), new ReportInfo("MDM_SECURERANDOM", 3));
            dumbMethods.put(new FQMethod("java/security/SecureRandom", "getSeed", "(I)[B"), new ReportInfo("MDM_SECURERANDOM", 3));
        } else {
            dumbMethods.remove(new FQMethod("java/security/SecureRandom", "<init>", "()V"));
            dumbMethods.remove(new FQMethod("java/security/SecureRandom", "<init>", "([B)V"));
            dumbMethods.remove(new FQMethod("java/security/SecureRandom", "getSeed", "(I)[B"));
        }
        super.visitClassContext(classContext);
    }

    public void visitCode(Code obj) {
        this.sawAssertionDisabled = false;
        this.assertionEnd = 0;
        super.visitCode(obj);
    }

    public void sawOpcode(int seen) {
        if (seen == 182 || seen == 185 || seen == 183 || seen == 184) {
            ReportInfo info = dumbMethods.get(this.getFQMethod());
            if (!(info == null || this.assertionEnd >= this.getPC() && assertableReports.contains(info))) {
                this.reportBug(info);
            }
        } else if (seen == 178) {
            if ("$assertionsDisabled".equals(this.getNameConstantOperand())) {
                this.sawAssertionDisabled = true;
                return;
            }
        } else if (seen == 154 && this.sawAssertionDisabled) {
            this.assertionEnd = this.getBranchTarget();
        }
        this.sawAssertionDisabled = false;
    }

    private FQMethod getFQMethod() {
        String className = this.getClassConstantOperand();
        String methodName = this.getNameConstantOperand();
        String methodSig = this.getSigConstantOperand();
        return new FQMethod(className, methodName, methodSig);
    }

    private void reportBug(ReportInfo info) {
        this.bugReporter.reportBug(new BugInstance((Detector)this, info.getPattern(), info.getPriority()).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this).addSourceLine((BytecodeScanningDetector)this));
    }

    static {
        dumbMethods.put(new FQMethod("java/lang/Runtime", "exit", "(I)V"), new ReportInfo("MDM_RUNTIME_EXIT_OR_HALT", 3));
        dumbMethods.put(new FQMethod("java/lang/Runtime", "halt", "(I)V"), new ReportInfo("MDM_RUNTIME_EXIT_OR_HALT", 1));
        dumbMethods.put(new FQMethod("java/lang/Runtime", "runFinalization", "()V"), new ReportInfo("MDM_RUNFINALIZATION", 2));
        dumbMethods.put(new FQMethod("java/lang/System", "runFinalization", "()V"), new ReportInfo("MDM_RUNFINALIZATION", 2));
        dumbMethods.put(new FQMethod("java/math/BigDecimal", "equals", "(Ljava/lang/Object;)Z"), new ReportInfo("MDM_BIGDECIMAL_EQUALS", 2));
        dumbMethods.put(new FQMethod("java/net/InetAddress", "getLocalHost", "()Ljava/net/InetAddress;"), new ReportInfo("MDM_INETADDRESS_GETLOCALHOST", 2));
        dumbMethods.put(new FQMethod("java/net/ServerSocket", "<init>", "(I)V"), new ReportInfo("MDM_PROMISCUOUS_SERVERSOCKET", 2));
        dumbMethods.put(new FQMethod("java/net/ServerSocket", "<init>", "(II)V"), new ReportInfo("MDM_PROMISCUOUS_SERVERSOCKET", 2));
        dumbMethods.put(new FQMethod("javax/net/ServerSocketFactory", "createServerSocket", "(I)Ljava/net/ServerSocket;"), new ReportInfo("MDM_PROMISCUOUS_SERVERSOCKET", 3));
        dumbMethods.put(new FQMethod("javax/net/ServerSocketFactory", "createServerSocket", "(II)Ljava/net/ServerSocket;"), new ReportInfo("MDM_PROMISCUOUS_SERVERSOCKET", 3));
        dumbMethods.put(new FQMethod("java/util/Random", "<init>", "()V"), new ReportInfo("MDM_RANDOM_SEED", 3));
        dumbMethods.put(new FQMethod("java/lang/Thread", "getPriority", "()I"), new ReportInfo("MDM_THREAD_PRIORITIES", 3));
        dumbMethods.put(new FQMethod("java/lang/Thread", "setPriority", "(I)V"), new ReportInfo("MDM_THREAD_PRIORITIES", 3));
        dumbMethods.put(new FQMethod("java/lang/Thread", "sleep", "(J)V"), new ReportInfo("MDM_THREAD_YIELD", 3));
        dumbMethods.put(new FQMethod("java/lang/Thread", "sleep", "(JI)V"), new ReportInfo("MDM_THREAD_YIELD", 3));
        dumbMethods.put(new FQMethod("java/lang/Thread", "yield", "()V"), new ReportInfo("MDM_THREAD_YIELD", 2));
        dumbMethods.put(new FQMethod("java/lang/Thread", "join", "()V"), new ReportInfo("MDM_WAIT_WITHOUT_TIMEOUT", 3));
        dumbMethods.put(new FQMethod("java/lang/Object", "wait", "()V"), new ReportInfo("MDM_WAIT_WITHOUT_TIMEOUT", 3));
        dumbMethods.put(new FQMethod("java/util/concurrent/locks/Condition", "await", "()V"), new ReportInfo("MDM_WAIT_WITHOUT_TIMEOUT", 3));
        dumbMethods.put(new FQMethod("java/util/concurrent/locks/Lock", "lock", "()V"), new ReportInfo("MDM_WAIT_WITHOUT_TIMEOUT", 3));
        dumbMethods.put(new FQMethod("java/util/concurrent/locks/Lock", "lockInterruptibly", "()V"), new ReportInfo("MDM_WAIT_WITHOUT_TIMEOUT", 3));
        dumbMethods.put(new FQMethod("java/util/concurrent/locks/ReentrantLock", "lock", "()V"), new ReportInfo("MDM_WAIT_WITHOUT_TIMEOUT", 3));
        dumbMethods.put(new FQMethod("java/util/concurrent/locks/ReentrantLock", "lockInterruptibly", "()V"), new ReportInfo("MDM_WAIT_WITHOUT_TIMEOUT", 3));
        dumbMethods.put(new FQMethod("java/util/concurrent/locks/Condition", "signal", "()V"), new ReportInfo("MDM_SIGNAL_NOT_SIGNALALL", 2));
        dumbMethods.put(new FQMethod("java/util/concurrent/locks/Lock", "tryLock", "()Z"), new ReportInfo("MDM_THREAD_FAIRNESS", 3));
        dumbMethods.put(new FQMethod("java/util/concurrent/locks/ReentrantLock", "tryLock", "()Z"), new ReportInfo("MDM_THREAD_FAIRNESS", 3));
        dumbMethods.put(new FQMethod("java/util/concurrent/locks/ReentrantLock", "isHeldByCurrentThread", "()Z"), new ReportInfo("MDM_LOCK_ISLOCKED", 3));
        dumbMethods.put(new FQMethod("java/util/concurrent/locks/ReentrantLock", "isLocked", "()Z"), new ReportInfo("MDM_LOCK_ISLOCKED", 3));
        dumbMethods.put(new FQMethod("java/lang/String", "<init>", "([B)V"), new ReportInfo("MDM_STRING_BYTES_ENCODING", 2));
        dumbMethods.put(new FQMethod("java/lang/String", "getBytes", "()[B"), new ReportInfo("MDM_STRING_BYTES_ENCODING", 2));
        dumbMethods.put(new FQMethod("java/util/Locale", "setDefault", "(Ljava/util/Locale;)V"), new ReportInfo("MDM_SETDEFAULTLOCALE", 2));
        assertableReports = UnmodifiableSet.create(new ReportInfo("MDM_LOCK_ISLOCKED", 3));
    }

    private static class ReportInfo {
        private final String bugPattern;
        private final int bugPriority;

        ReportInfo(String pattern, int priority) {
            this.bugPattern = pattern;
            this.bugPriority = priority;
        }

        String getPattern() {
            return this.bugPattern;
        }

        int getPriority() {
            return this.bugPriority;
        }

        public int hashCode() {
            return this.bugPattern.hashCode() ^ this.bugPriority;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ReportInfo)) {
                return false;
            }
            ReportInfo that = (ReportInfo)o;
            return this.bugPriority == that.bugPriority && this.bugPattern.equals(that.bugPattern);
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

