/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class NonOwnedSynchronization
extends BytecodeScanningDetector {
    private static final Integer OWNED = Integer.MAX_VALUE;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, Integer> regPriorities;

    public NonOwnedSynchronization(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.regPriorities = new HashMap<Integer, Integer>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.regPriorities = null;
        }
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(194);
    }

    public void visitCode(Code obj) {
        Method method = this.getMethod();
        if (this.prescreen(method)) {
            int[] parmRegs;
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.regPriorities.clear();
            for (int reg : parmRegs = RegisterUtils.getParameterRegisters(method)) {
                this.regPriorities.put(reg, Values.NORMAL_BUG_PRIORITY);
            }
            if (!method.isStatic()) {
                this.regPriorities.put(Values.ZERO, Values.LOW_BUG_PRIORITY);
            }
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        Integer tosIsPriority = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 180: {
                    tosIsPriority = OWNED;
                    return;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                    if (reg == 0 && this.getMethod().isStatic()) {
                        tosIsPriority = Values.LOW_BUG_PRIORITY;
                        return;
                    }
                    tosIsPriority = this.regPriorities.get(reg);
                    if (tosIsPriority != null) return;
                    tosIsPriority = Values.NORMAL_BUG_PRIORITY;
                    return;
                }
                case 58: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    Integer priority = (Integer)item.getUserValue();
                    this.regPriorities.put(RegisterUtils.getAStoreReg((DismantleBytecode)this, seen), priority);
                    return;
                }
                case 182: 
                case 185: {
                    String sig = this.getSigConstantOperand();
                    Type t = Type.getReturnType((String)sig);
                    if (!t.getSignature().startsWith("L")) return;
                    int parmCnt = Type.getArgumentTypes((String)sig).length;
                    if (this.stack.getStackDepth() <= parmCnt) return;
                    OpcodeStack.Item itm = this.stack.getStackItem(parmCnt);
                    Integer priority = (Integer)itm.getUserValue();
                    if (priority != null && OWNED.equals(priority)) {
                        tosIsPriority = OWNED;
                        return;
                    }
                    int reg = itm.getRegisterNumber();
                    if (reg > 0) {
                        tosIsPriority = this.regPriorities.get(reg);
                        return;
                    }
                    tosIsPriority = OWNED;
                    return;
                }
                case 184: {
                    String sig = this.getSigConstantOperand();
                    Type t = Type.getReturnType((String)sig);
                    if (!t.getSignature().startsWith("L")) return;
                    tosIsPriority = OWNED;
                    return;
                }
                case 183: {
                    String name = this.getNameConstantOperand();
                    if (!"<init>".equals(name)) return;
                    tosIsPriority = OWNED;
                    return;
                }
                case 194: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    Integer priority = (Integer)itm.getUserValue();
                    if (priority == null) return;
                    if (priority.equals(OWNED)) return;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.NOS_NON_OWNED_SYNCHRONIZATION.name(), priority.intValue()).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    return;
                }
            }
            return;
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (tosIsPriority != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                itm.setUserValue((Object)tosIsPriority);
            }
        }
    }
}

