/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Code;

@OpcodeStack.CustomUserValue
public class NonProductiveMethodCall
extends BytecodeScanningDetector {
    private static final Set<Pattern> IMMUTABLE_METHODS = UnmodifiableSet.create(Pattern.compile(".*@toString\\(\\)Ljava/lang/String;"), Pattern.compile("java/lang/.+@.+Value\\(\\)[BCDFIJSZ]"), Pattern.compile(".*@equals\\(Ljava/lang/Object;\\)Z"), Pattern.compile(".*@hashCode\\(\\)I"), Pattern.compile(".*@clone\\(\\).+"), Pattern.compile("java/util/.+@toArray\\(\\)\\[.+"));
    private BugReporter bugReporter;
    private OpcodeStack stack;

    public NonProductiveMethodCall(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        String methodInfo = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 182: 
                case 184: 
                case 185: {
                    String sig = this.getSigConstantOperand();
                    if (sig.endsWith("V")) return;
                    methodInfo = this.getClassConstantOperand() + '@' + this.getNameConstantOperand() + this.getSigConstantOperand();
                    return;
                }
                case 87: 
                case 88: {
                    Pattern p;
                    Matcher m;
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    String mInfo = (String)item.getUserValue();
                    if (mInfo == null) return;
                    Iterator<Pattern> iterator = IMMUTABLE_METHODS.iterator();
                    do {
                        if (!iterator.hasNext()) return;
                    } while (!(m = (p = iterator.next()).matcher(mInfo)).matches());
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.NPMC_NON_PRODUCTIVE_METHOD_CALL.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(mInfo));
                    return;
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (methodInfo != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue(methodInfo);
            }
        }
    }
}

