/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class NonRecycleableTaglibs
extends BytecodeScanningDetector {
    private static final int MAX_ATTRIBUTE_CODE_LENGTH = 60;
    private static final Set<String> tagClasses = UnmodifiableSet.create("javax.servlet.jsp.tagext.TagSupport", "javax.servlet.jsp.tagext.BodyTagSupport");
    private static final Set<String> validAttrTypes = UnmodifiableSet.create("B", "C", "D", "F", "I", "J", "S", "Z", "Ljava/lang/String;", "Ljava/util/Date;");
    private final BugReporter bugReporter;
    private Map<String, String> attributes;
    private Map<String, Map<String, SourceLineAnnotation>> methodWrites;
    private Map<String, FieldAnnotation> fieldAnnotations;

    public NonRecycleableTaglibs(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass[] superClasses;
            JavaClass cls = classContext.getJavaClass();
            for (JavaClass superCls : superClasses = cls.getSuperClasses()) {
                if (!tagClasses.contains(superCls.getClassName())) continue;
                this.attributes = NonRecycleableTaglibs.getAttributes(cls);
                if (this.attributes.size() > 0) {
                    this.methodWrites = new HashMap<String, Map<String, SourceLineAnnotation>>();
                    this.fieldAnnotations = new HashMap<String, FieldAnnotation>();
                    super.visitClassContext(classContext);
                    this.reportBugs();
                }
                break;
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.attributes = null;
            this.methodWrites = null;
            this.fieldAnnotations = null;
        }
    }

    private static Map<String, String> getAttributes(JavaClass cls) {
        Method[] methods;
        HashMap<String, String> atts = new HashMap<String, String>();
        for (Method m : methods = cls.getMethods()) {
            Code code;
            String parmSig;
            String name = m.getName();
            if (!name.startsWith("set") || !m.isPublic() || m.isStatic()) continue;
            String sig = m.getSignature();
            Type ret = Type.getReturnType((String)sig);
            Type[] args = Type.getArgumentTypes((String)sig);
            if (args.length != 1 || !ret.equals((Object)Type.VOID) || !validAttrTypes.contains(parmSig = args[0].getSignature()) || (code = m.getCode()) == null || code.getCode().length >= 60) continue;
            atts.put(name + ':' + sig, parmSig);
        }
        return atts;
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        if (!"<init>".equals(m.getName())) {
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 181) {
            String methodInfo = this.getMethodName() + ':' + this.getMethodSig();
            Map<String, SourceLineAnnotation> fields = this.methodWrites.get(methodInfo);
            if (fields == null) {
                fields = new HashMap<String, SourceLineAnnotation>();
                this.methodWrites.put(methodInfo, fields);
            }
            String fieldName = this.getNameConstantOperand();
            String fieldSig = this.getSigConstantOperand();
            FieldAnnotation fa = new FieldAnnotation(this.getDottedClassName(), fieldName, fieldSig, false);
            this.fieldAnnotations.put(fieldName, fa);
            fields.put(fieldName + ':' + fieldSig, SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this));
        }
    }

    private void reportBugs() {
        block0: for (Map.Entry<String, String> attEntry : this.attributes.entrySet()) {
            String methodInfo = attEntry.getKey();
            String attType = attEntry.getValue();
            Map<String, SourceLineAnnotation> fields = this.methodWrites.get(methodInfo);
            if (fields == null || fields.size() != 1) continue;
            String fieldInfo = fields.keySet().iterator().next();
            int colonPos = fieldInfo.indexOf(58);
            String fieldName = fieldInfo.substring(0, colonPos);
            String fieldType = fieldInfo.substring(colonPos + 1);
            if (!attType.equals(fieldType)) continue;
            for (Map.Entry<String, Map<String, SourceLineAnnotation>> fwEntry : this.methodWrites.entrySet()) {
                SourceLineAnnotation sla;
                if (fwEntry.getKey().equals(methodInfo) || (sla = fwEntry.getValue().get(fieldInfo)) == null) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.NRTL_NON_RECYCLEABLE_TAG_LIB.name(), 2).addClass((PreorderVisitor)this).addField(this.fieldAnnotations.get(fieldName)).addSourceLine(sla));
                continue block0;
            }
        }
    }
}

