/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.OpcodeUtils;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import com.mebigfatguy.fbcontrib.utils.ToString;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.generic.Type;

public class OverlyConcreteParameter
extends BytecodeScanningDetector {
    private static final Set<String> CONVERSION_ANNOTATIONS = UnmodifiableSet.create("Ljavax/persistence/Converter;", "Ljavax/ws/rs/Consumes;");
    private static final Set<String> CONVERSION_SUPER_CLASSES = UnmodifiableSet.create("com.fasterxml.jackson.databind.JsonSerializer", "com.fasterxml.jackson.databind.JsonDeserializer");
    private final BugReporter bugReporter;
    private JavaClass[] constrainingClasses;
    private Map<Integer, Map<JavaClass, List<MethodInfo>>> parameterDefiners;
    private BitSet usedParameters;
    private JavaClass objectClass;
    private JavaClass cls;
    private OpcodeStack stack;
    private int parmCount;
    private boolean methodSignatureIsConstrained;
    private boolean methodIsStatic;

    public OverlyConcreteParameter(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        try {
            this.objectClass = Repository.lookupClass((String)"java/lang/Object");
        }
        catch (ClassNotFoundException cnfe) {
            bugReporter.reportMissingClass(cnfe);
            this.objectClass = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.cls = classContext.getJavaClass();
            if (!this.isaConversionClass(this.cls)) {
                JavaClass[] infs = this.cls.getAllInterfaces();
                JavaClass[] sups = this.cls.getSuperClasses();
                this.constrainingClasses = new JavaClass[infs.length + sups.length];
                System.arraycopy(infs, 0, this.constrainingClasses, 0, infs.length);
                System.arraycopy(sups, 0, this.constrainingClasses, infs.length, sups.length);
                this.parameterDefiners = new HashMap<Integer, Map<JavaClass, List<MethodInfo>>>();
                this.usedParameters = new BitSet();
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.constrainingClasses = null;
            this.parameterDefiners = null;
            this.usedParameters = null;
            this.stack = null;
        }
    }

    public void visitMethod(Method obj) {
        this.methodSignatureIsConstrained = false;
        String methodName = obj.getName();
        if (!"<init>".equals(methodName) && !"<clinit>".equals(methodName)) {
            String parms;
            String methodSig = obj.getSignature();
            boolean bl = this.methodSignatureIsConstrained = OverlyConcreteParameter.methodIsSpecial(methodName, methodSig) || this.methodHasSyntheticTwin(methodName, methodSig);
            if (!this.methodSignatureIsConstrained) {
                for (AnnotationEntry entry : obj.getAnnotationEntries()) {
                    if (!CONVERSION_ANNOTATIONS.contains(entry.getAnnotationType())) continue;
                    this.methodSignatureIsConstrained = true;
                    break;
                }
            }
            if (!this.methodSignatureIsConstrained && (parms = methodSig.split("\\(|\\)")[1]).indexOf(59) >= 0) {
                block1: for (JavaClass cls : this.constrainingClasses) {
                    Method[] methods;
                    for (Method m : methods = cls.getMethods()) {
                        if (!methodName.equals(m.getName()) || !methodSig.equals(m.getSignature())) continue;
                        this.methodSignatureIsConstrained = true;
                        break block1;
                    }
                }
            }
        }
    }

    public void visitCode(Code obj) {
        try {
            if (this.methodSignatureIsConstrained) {
                return;
            }
            if (obj.getCode() == null) {
                return;
            }
            Method m = this.getMethod();
            if (m.isSynthetic()) {
                return;
            }
            if (m.getName().startsWith("access$")) {
                return;
            }
            this.methodIsStatic = m.isStatic();
            this.parmCount = m.getArgumentTypes().length;
            if (this.parmCount == 0) {
                return;
            }
            this.parameterDefiners.clear();
            this.usedParameters.clear();
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            if (this.buildParameterDefiners()) {
                super.visitCode(obj);
                this.reportBugs();
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        if (this.parameterDefiners.isEmpty()) {
            return;
        }
        try {
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 182 || seen == 184 || seen == 183 || seen == 185 || seen == 186) {
                String methodSig = this.getSigConstantOperand();
                Type[] parmTypes = Type.getArgumentTypes((String)methodSig);
                int stackDepth = this.stack.getStackDepth();
                if (stackDepth >= parmTypes.length) {
                    for (int i = 0; i < parmTypes.length; ++i) {
                        OpcodeStack.Item itm = this.stack.getStackItem(i);
                        int reg = itm.getRegisterNumber();
                        this.removeUselessDefiners(parmTypes[parmTypes.length - i - 1].getSignature(), reg);
                    }
                }
                if (seen != 183 && seen != 184) {
                    if (stackDepth > parmTypes.length) {
                        int reg;
                        OpcodeStack.Item itm = this.stack.getStackItem(parmTypes.length);
                        int parm = reg = itm.getRegisterNumber();
                        if (!this.methodIsStatic) {
                            --parm;
                        }
                        if (parm >= 0 && parm < this.parmCount) {
                            this.removeUselessDefiners(reg);
                        }
                    } else {
                        this.parameterDefiners.clear();
                    }
                }
            } else if (seen == 58 || seen >= 75 && seen <= 78 || seen == 181 || seen == 180 || seen == 179 || seen == 178) {
                int parm;
                int reg;
                OpcodeStack.Item itm;
                if (this.stack.getStackDepth() > 0) {
                    itm = this.stack.getStackItem(0);
                    parm = reg = itm.getRegisterNumber();
                    if (!this.methodIsStatic) {
                        --parm;
                    }
                    if (parm >= 0 && parm < this.parmCount) {
                        this.parameterDefiners.remove(reg);
                    }
                } else {
                    this.parameterDefiners.clear();
                }
                if (seen == 180 || seen == 181) {
                    if (this.stack.getStackDepth() > 1) {
                        itm = this.stack.getStackItem(1);
                        parm = reg = itm.getRegisterNumber();
                        if (!this.methodIsStatic) {
                            --parm;
                        }
                        if (parm >= 0 && parm < this.parmCount) {
                            this.parameterDefiners.remove(reg);
                        }
                    } else {
                        this.parameterDefiners.clear();
                    }
                }
            } else if (OpcodeUtils.isALoad(seen)) {
                int reg;
                int parm = reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                if (!this.methodIsStatic) {
                    --parm;
                }
                if (parm >= 0 && parm < this.parmCount) {
                    this.usedParameters.set(reg);
                }
            } else if (seen == 83) {
                if (this.stack.getStackDepth() >= 3) {
                    int reg;
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    int parm = reg = itm.getRegisterNumber();
                    if (!this.methodIsStatic) {
                        --parm;
                    }
                    if (parm >= 0 && parm < this.parmCount) {
                        this.parameterDefiners.remove(reg);
                    }
                } else {
                    this.parameterDefiners.clear();
                }
            } else if (seen == 176) {
                if (this.stack.getStackDepth() >= 1) {
                    int reg;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    int parm = reg = item.getRegisterNumber();
                    if (!this.methodIsStatic) {
                        --parm;
                    }
                    if (parm >= 0 && parm < this.parmCount) {
                        this.parameterDefiners.remove(reg);
                    }
                } else {
                    this.parameterDefiners.clear();
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private static boolean methodIsSpecial(String methodName, String methodSig) {
        return "readObject".equals(methodName) && "(Ljava/io/ObjectInputStream;)V".equals(methodSig);
    }

    private boolean methodHasSyntheticTwin(String methodName, String methodSig) {
        for (Method m : this.cls.getMethods()) {
            if (!m.isSynthetic() || !m.getName().equals(methodName) || m.getSignature().equals(methodSig)) continue;
            return true;
        }
        return false;
    }

    private void reportBugs() {
        Iterator<Map.Entry<Integer, Map<JavaClass, List<MethodInfo>>>> it = this.parameterDefiners.entrySet().iterator();
        while (it.hasNext()) {
            LocalVariable lv;
            Map.Entry<Integer, Map<JavaClass, List<MethodInfo>>> entry = it.next();
            Integer reg = entry.getKey();
            if (!this.usedParameters.get(reg)) {
                it.remove();
                continue;
            }
            Map<JavaClass, List<MethodInfo>> definers = entry.getValue();
            definers.remove(this.objectClass);
            if (definers.size() <= 0) continue;
            String name = "";
            LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
            if (lvt != null && (lv = lvt.getLocalVariable(reg.intValue(), 0)) != null) {
                name = lv.getName();
            }
            int parm = reg;
            if (!this.methodIsStatic) {
                --parm;
            }
            String infName = definers.keySet().iterator().next().getClassName();
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.OCP_OVERLY_CONCRETE_PARAMETER.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, 0).addString(OverlyConcreteParameter.getCardinality(++parm) + " parameter '" + name + "' could be declared as " + infName + " instead"));
        }
    }

    private static String getCardinality(int num) {
        if (num == 1) {
            return "1st";
        }
        if (num == 2) {
            return "2nd";
        }
        if (num == 3) {
            return "3rd";
        }
        return num + "th";
    }

    private boolean buildParameterDefiners() throws ClassNotFoundException {
        Method m = this.getMethod();
        Type[] parms = m.getArgumentTypes();
        if (parms.length == 0) {
            return false;
        }
        ParameterAnnotationEntry[] annotations = m.getParameterAnnotationEntries();
        boolean hasPossiblyOverlyConcreteParm = false;
        for (int i = 0; i < parms.length; ++i) {
            Map<JavaClass, List<MethodInfo>> definers;
            JavaClass cls;
            String clsName;
            String parm;
            if (annotations.length > i && annotations[i] != null && annotations[i].getNumAnnotations() != 0 || !(parm = parms[i].getSignature()).startsWith("L") || (clsName = SignatureUtils.stripSignature(parm)).startsWith("java.lang.") || !(cls = Repository.lookupClass((String)clsName)).isClass() || cls.isAbstract() || (definers = OverlyConcreteParameter.getClassDefiners(cls)).size() <= 0) continue;
            this.parameterDefiners.put(i + (this.methodIsStatic ? 0 : 1), definers);
            hasPossiblyOverlyConcreteParm = true;
        }
        return hasPossiblyOverlyConcreteParm;
    }

    private static Map<JavaClass, List<MethodInfo>> getClassDefiners(JavaClass cls) throws ClassNotFoundException {
        HashMap<JavaClass, List<MethodInfo>> definers = new HashMap<JavaClass, List<MethodInfo>>();
        for (JavaClass ci : cls.getAllInterfaces()) {
            List<MethodInfo> methodInfos;
            if ("java.lang.Comparable".equals(ci.getClassName()) || (methodInfos = OverlyConcreteParameter.getPublicMethodInfos(ci)).size() <= 0) continue;
            definers.put(ci, methodInfos);
        }
        return definers;
    }

    private static List<MethodInfo> getPublicMethodInfos(JavaClass cls) {
        Method[] methods;
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        for (Method m : methods = cls.getMethods()) {
            if ((m.getAccessFlags() & 5) == 0) continue;
            ExceptionTable et = m.getExceptionTable();
            methodInfos.add(new MethodInfo(m.getName(), m.getSignature(), et == null ? null : et.getExceptionNames()));
        }
        return methodInfos;
    }

    private void removeUselessDefiners(int reg) {
        Map<JavaClass, List<MethodInfo>> definers = this.parameterDefiners.get(reg);
        if (definers != null && definers.size() > 0) {
            String methodSig = this.getSigConstantOperand();
            String methodName = this.getNameConstantOperand();
            MethodInfo methodInfo = new MethodInfo(methodName, methodSig, null);
            Iterator<List<MethodInfo>> it = definers.values().iterator();
            while (it.hasNext()) {
                boolean methodDefined = false;
                List<MethodInfo> methodSigs = it.next();
                block1: for (MethodInfo mi : methodSigs) {
                    if (!methodInfo.equals(mi)) continue;
                    methodDefined = true;
                    String[] exceptions = mi.getMethodExceptions();
                    if (exceptions == null) break;
                    for (String ex : exceptions) {
                        if (this.isExceptionHandled(ex)) continue;
                        methodDefined = false;
                        break block1;
                    }
                }
                if (methodDefined) continue;
                it.remove();
            }
            if (definers.isEmpty()) {
                this.parameterDefiners.remove(reg);
            }
        }
    }

    private boolean isExceptionHandled(String ex) {
        try {
            CodeException[] catchExs;
            JavaClass thrownEx = Repository.lookupClass((String)ex);
            ExceptionTable et = this.getMethod().getExceptionTable();
            if (et != null) {
                String[] throwClauseExNames;
                for (String throwClauseExName : throwClauseExNames = et.getExceptionNames()) {
                    JavaClass throwClauseEx = Repository.lookupClass((String)throwClauseExName);
                    if (!thrownEx.instanceOf(throwClauseEx)) continue;
                    return true;
                }
            }
            if ((catchExs = this.getCode().getExceptionTable()) != null) {
                int pc = this.getPC();
                for (CodeException catchEx : catchExs) {
                    String catchExName;
                    JavaClass catchException;
                    int type;
                    if (pc < catchEx.getStartPC() || pc > catchEx.getEndPC() || (type = catchEx.getCatchType()) == 0 || !thrownEx.instanceOf(catchException = Repository.lookupClass((String)(catchExName = this.getConstantPool().getConstantString(type, (byte)7))))) continue;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        return false;
    }

    private void removeUselessDefiners(String parmSig, int reg) {
        if (parmSig.startsWith("L")) {
            if ("java.lang.Object".equals(parmSig = SignatureUtils.stripSignature(parmSig))) {
                this.parameterDefiners.remove(reg);
                return;
            }
            Map<JavaClass, List<MethodInfo>> definers = this.parameterDefiners.get(reg);
            if (definers != null && definers.size() > 0) {
                Iterator<JavaClass> it = definers.keySet().iterator();
                while (it.hasNext()) {
                    JavaClass definer = it.next();
                    if (definer.getClassName().equals(parmSig)) continue;
                    it.remove();
                }
                if (definers.isEmpty()) {
                    this.parameterDefiners.remove(reg);
                }
            }
        }
    }

    private boolean isaConversionClass(JavaClass cls) {
        for (AnnotationEntry entry : cls.getAnnotationEntries()) {
            if (CONVERSION_ANNOTATIONS.contains(entry.getAnnotationType())) {
                return true;
            }
            if (!CONVERSION_SUPER_CLASSES.contains(cls.getSuperclassName())) continue;
            return true;
        }
        return false;
    }

    static class MethodInfo {
        private final String methodName;
        private final String methodSig;
        private final String[] methodExceptions;

        MethodInfo(String name, String sig, String[] excs) {
            this.methodName = name;
            this.methodSig = sig;
            this.methodExceptions = excs;
        }

        String getMethodName() {
            return this.methodName;
        }

        String getMethodSignature() {
            return this.methodSig;
        }

        String[] getMethodExceptions() {
            return this.methodExceptions;
        }

        public int hashCode() {
            return this.methodName.hashCode() ^ this.methodSig.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodInfo)) {
                return false;
            }
            MethodInfo that = (MethodInfo)o;
            if (!this.methodName.equals(that.methodName)) {
                return false;
            }
            return this.methodSig.equals(that.methodSig);
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

