/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;

public class PoorMansEnum
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private Map<String, Set<Object>> fieldValues;
    private Map<String, Field> nameToField;
    private Map<String, SourceLineAnnotation> firstFieldUse;
    private OpcodeStack stack;

    public PoorMansEnum(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            if (cls.getMajor() >= 49) {
                this.fieldValues = new HashMap<String, Set<Object>>();
                this.nameToField = new HashMap<String, Field>();
                for (Field f : cls.getFields()) {
                    if (!f.isPrivate() || f.isSynthetic()) continue;
                    this.fieldValues.put(f.getName(), null);
                    this.nameToField.put(f.getName(), f);
                }
                if (!this.fieldValues.isEmpty()) {
                    this.stack = new OpcodeStack();
                    this.firstFieldUse = new HashMap<String, SourceLineAnnotation>();
                    super.visitClassContext(classContext);
                    for (Map.Entry entry : this.fieldValues.entrySet()) {
                        Set values = (Set)entry.getValue();
                        if (values == null || values.size() < 3) continue;
                        String fieldName = (String)entry.getKey();
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.PME_POOR_MANS_ENUM.name(), 2).addClass((PreorderVisitor)this).addField(XFactory.createXField((JavaClass)cls, (Field)this.nameToField.get(fieldName))).addSourceLine(this.firstFieldUse.get(fieldName)));
                    }
                }
            }
        }
        finally {
            this.fieldValues = null;
            this.nameToField = null;
            this.firstFieldUse = null;
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        if (!this.fieldValues.isEmpty()) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            String fieldName;
            this.stack.precomputation((DismantleBytecode)this);
            if (this.fieldValues.isEmpty()) {
                return;
            }
            if (seen == 181 && this.fieldValues.containsKey(fieldName = this.getNameConstantOperand()) && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                Object cons = item.getConstant();
                if (cons == null) {
                    this.fieldValues.remove(fieldName);
                    this.nameToField.remove(fieldName);
                    this.firstFieldUse.remove(fieldName);
                } else {
                    Set<Object> values = this.fieldValues.get(fieldName);
                    if (values == null) {
                        values = new HashSet<Object>();
                        this.fieldValues.put(fieldName, values);
                        if (this.firstFieldUse.get(fieldName) == null) {
                            this.firstFieldUse.put(fieldName, SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this));
                        }
                    }
                    values.add(cons);
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }
}

