/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.ToString;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class PresizeCollections
extends BytecodeScanningDetector {
    private static final Set<String> PRESIZEABLE_COLLECTIONS = UnmodifiableSet.create("java/util/ArrayBlockingQueue", "java/util/ArrayDeque", "java/util/ArrayList", "java/util/HashMap", "java/util/HashSet", "java/util/LinkedBlockingQueue", "java/util/LinkedHashMap", "java/util/LinkedHashSet", "java/util/PriorityBlockingQueue", "java/util/PriorityQueue", "java/util/Vector");
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private int allocNumber;
    private Map<Integer, Integer> allocLocation;
    private Map<Integer, List<Integer>> allocToAddPCs;
    private List<DownBranch> downBranches;

    public PresizeCollections(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.allocLocation = new HashMap<Integer, Integer>();
            this.allocToAddPCs = new HashMap<Integer, List<Integer>>();
            this.downBranches = new ArrayList<DownBranch>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.allocLocation = null;
            this.allocToAddPCs = null;
            this.downBranches = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.allocNumber = 0;
        this.allocLocation.clear();
        this.allocToAddPCs.clear();
        this.downBranches.clear();
        super.visitCode(obj);
        for (List<Integer> pcs : this.allocToAddPCs.values()) {
            if (pcs.size() <= 16) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.PSC_PRESIZE_COLLECTIONS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, pcs.get(0).intValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"}, justification="Constrained by FindBugs API")
    public void sawOpcode(int seen) {
        boolean sawAlloc = false;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 183: {
                    String clsName = this.getClassConstantOperand();
                    if (!PRESIZEABLE_COLLECTIONS.contains(clsName)) return;
                    String methodName = this.getNameConstantOperand();
                    if (!"<init>".equals(methodName)) return;
                    String signature = this.getSigConstantOperand();
                    if (!"()V".equals(signature)) return;
                    sawAlloc = true;
                    return;
                }
                case 185: {
                    String signature;
                    Type[] argTypes;
                    String methodName = this.getNameConstantOperand();
                    if ("add".equals(methodName) || "addAll".equals(methodName)) {
                        String signature2 = this.getSigConstantOperand();
                        Type[] argTypes2 = Type.getArgumentTypes((String)signature2);
                        if (argTypes2.length != 1) return;
                        if (this.stack.getStackDepth() <= 1) return;
                        OpcodeStack.Item item = this.stack.getStackItem(1);
                        Integer allocNum = (Integer)item.getUserValue();
                        if (allocNum == null) return;
                        if ("addAll".equals(methodName)) {
                            this.allocToAddPCs.remove(allocNum);
                            return;
                        }
                        List<Integer> lines = this.allocToAddPCs.get(allocNum);
                        if (lines == null) {
                            lines = new ArrayList<Integer>();
                            this.allocToAddPCs.put(allocNum, lines);
                        }
                        lines.add(this.getPC());
                        return;
                    }
                    if (!"put".equals(methodName)) {
                        if (!"putAll".equals(methodName)) return;
                    }
                    if ((argTypes = Type.getArgumentTypes((String)(signature = this.getSigConstantOperand()))).length != 2) return;
                    if (this.stack.getStackDepth() <= 2) return;
                    OpcodeStack.Item item = this.stack.getStackItem(2);
                    Integer allocNum = (Integer)item.getUserValue();
                    if (allocNum == null) return;
                    if ("putAll".equals(methodName)) {
                        this.allocToAddPCs.remove(allocNum);
                        return;
                    }
                    List<Integer> lines = this.allocToAddPCs.get(allocNum);
                    if (lines == null) {
                        lines = new ArrayList<Integer>();
                        this.allocToAddPCs.put(allocNum, lines);
                    }
                    lines.add(this.getPC());
                    return;
                }
                case 170: 
                case 171: {
                    int[] offsets = this.getSwitchOffsets();
                    if (offsets.length <= 1) return;
                    int secondCase = offsets[1] + this.getPC();
                    DownBranch db = new DownBranch(this.getPC(), secondCase);
                    this.downBranches.add(db);
                    return;
                }
                case 153: 
                case 154: 
                case 155: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 200: {
                    if (this.getBranchOffset() >= 0) {
                        DownBranch db = new DownBranch(this.getPC(), this.getBranchTarget());
                        this.downBranches.add(db);
                        return;
                    }
                    int target = this.getBranchTarget();
                    Iterator<Map.Entry<Integer, List<Integer>>> it = this.allocToAddPCs.entrySet().iterator();
                    block9: while (it.hasNext()) {
                        int pc;
                        Map.Entry<Integer, List<Integer>> entry = it.next();
                        Integer allocLoc = this.allocLocation.get(entry.getKey());
                        if (allocLoc == null || allocLoc >= target) continue;
                        List<Integer> pcs = entry.getValue();
                        Iterator<Integer> iterator = pcs.iterator();
                        do {
                            if (!iterator.hasNext()) continue block9;
                        } while ((pc = iterator.next().intValue()) <= target);
                        int numDownBranches = this.countDownBranches(target, pc);
                        if (numDownBranches != 1) continue;
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.PSC_PRESIZE_COLLECTIONS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, pc));
                        it.remove();
                    }
                    return;
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (sawAlloc && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                ++this.allocNumber;
                item.setUserValue((Object)this.allocNumber);
                this.allocLocation.put(this.allocNumber, this.getPC());
            }
        }
    }

    private int countDownBranches(int loopTop, int addPC) {
        int numDownBranches = 0;
        for (DownBranch db : this.downBranches) {
            if (db.fromPC <= loopTop || db.fromPC >= addPC || db.toPC <= addPC) continue;
            ++numDownBranches;
        }
        return numDownBranches;
    }

    static class DownBranch {
        public int fromPC;
        public int toPC;

        DownBranch(int from, int to) {
            this.fromPC = from;
            this.toPC = to;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

