/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.CodeByteUtils;
import com.mebigfatguy.fbcontrib.utils.OpcodeUtils;
import com.mebigfatguy.fbcontrib.utils.QMethod;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import com.mebigfatguy.fbcontrib.utils.ToString;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.LVTHelper;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
@SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"}, justification="lastPCs is an int[] of size 4 for efficiency reasons")
public class SillynessPotPourri
extends BytecodeScanningDetector {
    private static final Set<String> collectionInterfaces = UnmodifiableSet.create("java/util/Collection", "java/util/List", "java/util/Set", "java/util/SortedSet", "java/util/Map", "java/util/SortedMap");
    private static final Set<String> oddMissingEqualsClasses = UnmodifiableSet.create("java.lang.StringBuffer", "java.lang.StringBuilder");
    private static final Set<String> optionalClasses = UnmodifiableSet.create("java.util.Optional", "com.google.common.base.Optional", "org.openjdk.jmh.util.Optional");
    private static final String LITERAL = "literal";
    private static final Pattern APPEND_PATTERN = Pattern.compile("([0-9]+):(.*)");
    private static JavaClass calendarClass;
    private static Map<QMethod, Integer> methodsThatAreSillyOnStringLiterals;
    private final BugReporter bugReporter;
    private final Set<String> toStringClasses;
    private OpcodeStack stack;
    private int[] lastPCs;
    private int lastOpcode;
    private int lastReg;
    private boolean lastIfEqWasBoolean;
    private boolean lastLoadWasString;
    private Map<Integer, BitSet> branchTargets;
    private Set<String> staticConstants;
    private Map<SPPUserValue, Integer> trimLocations;

    public SillynessPotPourri(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.toStringClasses = new HashSet<String>();
    }

    public void visitField(Field field) {
        if ("serialVersionUID".equals(field.getName()) && (field.getAccessFlags() & 8) != 0 && (field.getAccessFlags() & 2) == 0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_SERIALVER_SHOULD_BE_PRIVATE.name(), 3).addClass((PreorderVisitor)this).addField((PreorderVisitor)this));
        }
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.lastPCs = new int[4];
            this.branchTargets = new HashMap<Integer, BitSet>();
            this.trimLocations = new HashMap<SPPUserValue, Integer>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.lastPCs = null;
            this.branchTargets = null;
            this.trimLocations = null;
            this.staticConstants = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.lastOpcode = -1;
        this.lastReg = -1;
        this.lastIfEqWasBoolean = false;
        this.lastLoadWasString = false;
        Arrays.fill(this.lastPCs, -1);
        this.branchTargets.clear();
        this.trimLocations.clear();
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"}, justification="This fall-through is deliberate and documented")
    public void sawOpcode(int seen) {
        int reg = -1;
        SPPUserValue userValue = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            this.checkTrimLocations();
            if (SillynessPotPourri.isBranchByteCode(seen)) {
                Integer branchTarget = this.getBranchTarget();
                BitSet branchInsSet = this.branchTargets.get(branchTarget);
                if (branchInsSet == null) {
                    branchInsSet = new BitSet();
                    this.branchTargets.put(branchTarget, branchInsSet);
                }
                branchInsSet.set(this.getPC());
            }
            if (seen == 153 || seen == 158 || seen == 154) {
                this.checkForEmptyStringAndNullChecks(seen);
            }
            if (seen == 153 || seen == 154 || seen == 157) {
                this.checkSizeEquals0();
            }
            if (seen == 153) {
                this.checkNullAndInstanceOf();
            }
            switch (seen) {
                case 154: {
                    this.checkNotEqualsStringBuilderLength();
                    return;
                }
                case 153: {
                    this.checkEqualsStringBufferLength();
                    return;
                }
                case 172: {
                    if (this.lastIfEqWasBoolean) {
                        this.checkForUselessTernaryReturn();
                    }
                }
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    this.trimLocations.clear();
                    return;
                }
                case 20: {
                    this.checkApproximationsOfMathConstants();
                    return;
                }
                case 151: {
                    this.checkCompareToNaNDouble();
                    return;
                }
                case 149: {
                    this.checkCompareToNaNFloat();
                    return;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    userValue = this.sawIntConst(userValue);
                    return;
                }
                case 52: {
                    this.checkImproperToCharArrayUse();
                    return;
                }
                case 184: {
                    userValue = this.sawInvokeStatic(userValue);
                    return;
                }
                case 182: {
                    userValue = this.sawInvokeVirtual(userValue);
                    return;
                }
                case 183: {
                    this.sawInvokeSpecial();
                    return;
                }
                case 185: {
                    userValue = this.sawInvokeInterface(userValue);
                    return;
                }
                case 198: 
                case 199: {
                    OpcodeStack.Item itm;
                    JavaClass cls;
                    if (this.stack.getStackDepth() <= 0 || (cls = (itm = this.stack.getStackItem(0)).getJavaClass()) == null || !optionalClasses.contains(cls.getClassName())) return;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_NULL_CHECK_ON_OPTIONAL.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    return;
                }
                default: {
                    if (OpcodeUtils.isALoad(seen)) {
                        this.sawLoad(seen);
                        return;
                    } else {
                        if (!OpcodeUtils.isAStore(seen)) return;
                        reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                        this.checkTrimDupStore();
                        this.checkStutterdAssignment(seen, reg);
                        this.checkImmutableUsageOfStringBuilder(reg);
                    }
                    return;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            return;
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                if (userValue != null) {
                    item.setUserValue((Object)userValue);
                } else {
                    SPPUserValue uv = (SPPUserValue)item.getUserValue();
                    if (uv != null && uv.getMethod() == SPPMethod.ITERATOR && seen == 180 || seen == 25 || seen >= 42 && seen <= 45) {
                        item.setUserValue(null);
                    }
                }
            }
            this.lastOpcode = seen;
            this.lastReg = reg;
            System.arraycopy(this.lastPCs, 1, this.lastPCs, 0, 3);
            this.lastPCs[3] = this.getPC();
        }
    }

    private void checkImproperToCharArrayUse() {
        OpcodeStack.Item item;
        SPPUserValue uv;
        if (this.stack.getStackDepth() > 0 && (uv = (SPPUserValue)(item = this.stack.getStackItem(0)).getUserValue()) != null && uv.getMethod() == SPPMethod.ICONST) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_CHARAT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private SPPUserValue sawIntConst(SPPUserValue userValue) {
        OpcodeStack.Item item;
        SPPUserValue uv;
        if (this.stack.getStackDepth() > 0 && (uv = (SPPUserValue)(item = this.stack.getStackItem(0)).getUserValue()) != null && uv.getMethod() == SPPMethod.TOCHARARRAY) {
            userValue = new SPPUserValue(SPPMethod.ICONST);
        }
        return userValue;
    }

    private void sawLoad(int seen) {
        LocalVariable lv;
        this.lastLoadWasString = false;
        LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
        if (lvt != null && (lv = LVTHelper.getLocalVariableAtPC((LocalVariableTable)lvt, (int)RegisterUtils.getALoadReg((DismantleBytecode)this, seen), (int)this.getPC())) != null) {
            this.lastLoadWasString = "Ljava/lang/String;".equals(lv.getSignature());
        }
    }

    private void checkTrimDupStore() {
        if (this.stack.getStackDepth() >= 2 && this.getPrevOpcode(1) == 89) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            SPPUserValue uv = (SPPUserValue)item.getUserValue();
            if (uv == null || uv.getMethod() != SPPMethod.TRIM) {
                return;
            }
            item = this.stack.getStackItem(1);
            uv = (SPPUserValue)item.getUserValue();
            if (uv == null || uv.getMethod() != SPPMethod.TRIM) {
                return;
            }
            item.setUserValue(null);
        }
    }

    private void checkStutterdAssignment(int seen, int reg) {
        if (seen == this.lastOpcode && reg == this.lastReg) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_STUTTERED_ASSIGNMENT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private void checkImmutableUsageOfStringBuilder(int reg) {
        OpcodeStack.Item item;
        SPPUserValue userValue;
        if (this.stack.getStackDepth() > 0 && (userValue = (SPPUserValue)(item = this.stack.getStackItem(0)).getUserValue()) != null) {
            int appendReg;
            Matcher m;
            if (userValue.getMethod() == SPPMethod.TRIM) {
                item.setUserValue(null);
            } else if (userValue.getMethod() == SPPMethod.APPEND && (m = APPEND_PATTERN.matcher(userValue.getDetails())).matches() && reg == (appendReg = Integer.parseInt(m.group(1)))) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_STRINGBUILDER_IS_MUTABLE.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }

    private void checkCompareToNaNFloat() {
        if (this.stack.getStackDepth() > 1) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            Float f1 = (Float)item.getConstant();
            item = this.stack.getStackItem(1);
            Float f2 = (Float)item.getConstant();
            if (f1 != null && f1.isNaN() || f2 != null && f2.isNaN()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_ISNAN.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString("float").addString("Float"));
            }
        }
    }

    private void checkCompareToNaNDouble() {
        if (this.stack.getStackDepth() > 1) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            Double d1 = (Double)item.getConstant();
            item = this.stack.getStackItem(1);
            Double d2 = (Double)item.getConstant();
            if (d1 != null && d1.isNaN() || d2 != null && d2.isNaN()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_ISNAN.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString("double").addString("Double"));
            }
        }
    }

    private void checkApproximationsOfMathConstants() {
        Constant con = this.getConstantRefOperand();
        if (con instanceof ConstantDouble) {
            double d = ((ConstantDouble)con).getBytes();
            double piDelta = Math.abs(d - Math.PI);
            double eDelta = Math.abs(d - Math.E);
            if (piDelta > 0.0 && piDelta < 0.002 || eDelta > 0.0 && eDelta < 0.002) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_MATH_CONSTANT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }

    private void checkForUselessTernaryReturn() {
        byte[] bytes = this.getCode().getCode();
        if (this.lastPCs[0] != -1 && (0xFF & bytes[this.lastPCs[3]]) == 3 && (0xFF & bytes[this.lastPCs[2]]) == 167 && (0xFF & bytes[this.lastPCs[1]]) == 4 && (0xFF & bytes[this.lastPCs[0]]) == 153 && this.getMethod().getSignature().endsWith("Z")) {
            boolean bug = true;
            BitSet branchInsSet = this.branchTargets.get(this.lastPCs[1]);
            if (branchInsSet != null) {
                bug = false;
            }
            if ((branchInsSet = this.branchTargets.get(this.lastPCs[3])) != null && branchInsSet.cardinality() > 1) {
                bug = false;
            }
            if (bug) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USELESS_TERNARY.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }

    private void checkEqualsStringBufferLength() {
        int lengthIndex;
        ConstantMethodref lengthMR;
        int nandtIndex;
        ConstantNameAndType cnt;
        int consIndex;
        Constant c;
        ConstantMethodref toStringMR;
        String toStringCls;
        int toStringIndex;
        ConstantPool pool;
        Constant cmr;
        int loadIns;
        if (this.stack.getStackDepth() > 0) {
            OpcodeStack.Item itm = this.stack.getStackItem(0);
            this.lastIfEqWasBoolean = "Z".equals(itm.getSignature());
        }
        byte[] bytes = this.getCode().getCode();
        if (this.lastPCs[1] != -1 && CodeByteUtils.getbyte(bytes, this.lastPCs[3]) == 182 && ((loadIns = CodeByteUtils.getbyte(bytes, this.lastPCs[2])) == 18 || loadIns == 19) && CodeByteUtils.getbyte(bytes, this.lastPCs[1]) == 182 && (cmr = (pool = this.getConstantPool()).getConstant(toStringIndex = CodeByteUtils.getshort(bytes, this.lastPCs[1] + 1))) instanceof ConstantMethodref && (toStringCls = (toStringMR = (ConstantMethodref)cmr).getClass(pool)).startsWith("java.lang.StringBu") && (c = pool.getConstant(consIndex = CodeByteUtils.getbyte(bytes, this.lastPCs[2] + 1))) instanceof ConstantString && "".equals(((ConstantString)c).getBytes(pool)) && "toString".equals((cnt = (ConstantNameAndType)pool.getConstant(nandtIndex = toStringMR.getNameAndTypeIndex())).getName(pool)) && "equals".equals((cnt = (ConstantNameAndType)pool.getConstant(nandtIndex = (lengthMR = (ConstantMethodref)pool.getConstant(lengthIndex = CodeByteUtils.getshort(bytes, this.lastPCs[3] + 1))).getNameAndTypeIndex())).getName(pool))) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_STRINGBUILDER_LENGTH.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private void checkNotEqualsStringBuilderLength() {
        int lengthIndex;
        ConstantMethodref lengthMR;
        int nandtIndex;
        ConstantNameAndType cnt;
        int toStringIndex;
        ConstantPool pool;
        ConstantMethodref toStringMR;
        String toStringCls;
        byte[] bytes = this.getCode().getCode();
        if (this.lastPCs[2] != -1 && CodeByteUtils.getbyte(bytes, this.lastPCs[3]) == 182 && CodeByteUtils.getbyte(bytes, this.lastPCs[2]) == 182 && (toStringCls = (toStringMR = (ConstantMethodref)(pool = this.getConstantPool()).getConstant(toStringIndex = CodeByteUtils.getshort(bytes, this.lastPCs[2] + 1))).getClass(pool)).startsWith("java.lang.StringBu") && "toString".equals((cnt = (ConstantNameAndType)pool.getConstant(nandtIndex = toStringMR.getNameAndTypeIndex())).getName(pool)) && "length".equals((cnt = (ConstantNameAndType)pool.getConstant(nandtIndex = (lengthMR = (ConstantMethodref)pool.getConstant(lengthIndex = CodeByteUtils.getshort(bytes, this.lastPCs[3] + 1))).getNameAndTypeIndex())).getName(pool))) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_STRINGBUILDER_LENGTH.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private void checkNullAndInstanceOf() {
        int ifNullTarget;
        int ins2;
        int ins0;
        byte[] bytes = this.getCode().getCode();
        if (!(this.lastPCs[0] == -1 || CodeByteUtils.getbyte(bytes, this.lastPCs[1]) != 198 || CodeByteUtils.getbyte(bytes, this.lastPCs[3]) != 193 || (ins0 = CodeByteUtils.getbyte(bytes, this.lastPCs[0])) != 25 && ins0 != 42 && ins0 != 43 && ins0 != 44 && ins0 != 45 || ins0 != (ins2 = CodeByteUtils.getbyte(bytes, this.lastPCs[2])) || ins0 == 25 && CodeByteUtils.getbyte(bytes, this.lastPCs[0] + 1) != CodeByteUtils.getbyte(bytes, this.lastPCs[2] + 1) || (ifNullTarget = this.lastPCs[1] + CodeByteUtils.getshort(bytes, this.lastPCs[1] + 1)) != this.getBranchTarget())) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_NULL_BEFORE_INSTANCEOF.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private void checkSizeEquals0() {
        OpcodeStack.Item item;
        SPPUserValue uv;
        if (this.stack.getStackDepth() == 1 && (uv = (SPPUserValue)(item = this.stack.getStackItem(0)).getUserValue()) != null && uv.getMethod() == SPPMethod.SIZE) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_ISEMPTY.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private void checkForEmptyStringAndNullChecks(int seen) {
        byte[] bytes;
        int loadIns;
        if (this.lastLoadWasString && this.lastPCs[0] != -1 && ((loadIns = CodeByteUtils.getbyte(bytes = this.getCode().getCode(), this.lastPCs[2])) >= 42 && loadIns <= 45 || loadIns == 25) && CodeByteUtils.getbyte(bytes, this.lastPCs[3]) == 182 && CodeByteUtils.getbyte(bytes, this.lastPCs[2]) == loadIns && CodeByteUtils.getbyte(bytes, this.lastPCs[1]) == 198 && CodeByteUtils.getbyte(bytes, this.lastPCs[0]) == loadIns && (loadIns != 25 || CodeByteUtils.getbyte(bytes, this.lastPCs[2] + 1) == CodeByteUtils.getbyte(bytes, this.lastPCs[0] + 1))) {
            int mpoolIndex;
            ConstantMethodref cmr;
            int nandtIndex;
            ConstantPool pool;
            ConstantNameAndType cnt;
            int nextOp;
            int brOffset;
            int n = brOffset = loadIns == 25 ? 11 : 10;
            if ((seen == 154 ? CodeByteUtils.getshort(bytes, this.lastPCs[1] + 1) > brOffset : CodeByteUtils.getshort(bytes, this.lastPCs[1] + 1) == brOffset) && (nextOp = CodeByteUtils.getbyte(bytes, this.getNextPC())) != 167 && nextOp != 200 && "length".equals((cnt = (ConstantNameAndType)(pool = this.getConstantPool()).getConstant(nandtIndex = (cmr = (ConstantMethodref)pool.getConstant(mpoolIndex = CodeByteUtils.getshort(bytes, this.lastPCs[3] + 1))).getNameAndTypeIndex())).getName(pool))) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_SUSPECT_STRING_TEST.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }

    private static boolean isBranchByteCode(int seen) {
        return seen >= 153 && seen <= 167 || seen == 198 || seen == 199 || seen == 200;
    }

    private SPPUserValue sawInvokeStatic(SPPUserValue userValue) {
        OpcodeStack.Item item;
        String format;
        String className = this.getClassConstantOperand();
        String methodName = this.getNameConstantOperand();
        if ("java/lang/System".equals(className)) {
            if ("getProperties".equals(methodName)) {
                userValue = new SPPUserValue(SPPMethod.GETPROPERTIES);
            } else if ("arraycopy".equals(methodName) && this.stack.getStackDepth() >= 5) {
                OpcodeStack.Item item2 = this.stack.getStackItem(2);
                String sig = item2.getSignature();
                if (sig.charAt(0) != '[' && !"Ljava/lang/Object;".equals(sig)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_NON_ARRAY_PARM.name(), 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                if ((sig = (item2 = this.stack.getStackItem(4)).getSignature()).charAt(0) != '[' && !"Ljava/lang/Object;".equals(sig)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_NON_ARRAY_PARM.name(), 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        } else if ("java/lang/reflect/Array".equals(className)) {
            OpcodeStack.Item item3;
            String sig;
            int offset = -1;
            if ("getLength".equals(methodName)) {
                offset = 0;
            } else if (methodName.startsWith("get")) {
                offset = 1;
            } else if (methodName.startsWith("set")) {
                offset = 2;
            }
            if (offset >= 0 && this.stack.getStackDepth() > offset && (sig = (item3 = this.stack.getStackItem(offset)).getSignature()).charAt(0) != '[' && !"Ljava/lang/Object;".equals(sig)) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_NON_ARRAY_PARM.name(), 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        } else if ("java/lang/String".equals(className) && "format".equals(methodName) && (format = (String)(item = this.stack.getStackItem(1)).getConstant()) != null && !format.contains("%")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_STATIC_FORMAT_STRING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        return userValue;
    }

    private SPPUserValue sawInvokeVirtual(SPPUserValue userValue) throws ClassNotFoundException {
        String className = this.getClassConstantOperand();
        String methodName = this.getNameConstantOperand();
        if ("java/util/BitSet".equals(className)) {
            this.bitSetSilliness(methodName);
        } else if ("java/lang/StringBuilder".equals(className) || "java/lang/StringBuffer".equals(className)) {
            userValue = this.stringBufferSilliness(userValue, methodName);
        } else if ("java/lang/String".equals(className)) {
            userValue = this.stringSilliness(userValue, methodName, this.getSigConstantOperand());
        } else if ("equals(Ljava/lang/Object;)Z".equals(methodName + this.getSigConstantOperand())) {
            this.equalsSilliness(className);
        } else if ("java/lang/Boolean".equals(className) && "booleanValue".equals(methodName)) {
            this.booleanSilliness();
        } else if (("java/util/GregorianCalendar".equals(className) || "java/util/Calendar".equals(className)) && ("after".equals(methodName) || "before".equals(methodName))) {
            this.calendarBeforeAfterSilliness();
        } else if ("java/util/Properties".equals(className)) {
            this.propertiesSilliness(methodName);
        } else if ("toString".equals(methodName) && "java/lang/Object".equals(className)) {
            this.defaultToStringSilliness();
        }
        return userValue;
    }

    private void bitSetSilliness(String methodName) {
        OpcodeStack.Item item;
        Object o;
        if (("clear".equals(methodName) || "flip".equals(methodName) || "get".equals(methodName) || "set".equals(methodName)) && this.stack.getStackDepth() > 0 && (o = (item = this.stack.getStackItem(0)).getConstant()) instanceof Integer && (Integer)o < 0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_NEGATIVE_BITSET_ITEM.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private SPPUserValue stringBufferSilliness(SPPUserValue userValue, String methodName) {
        if ("append".equals(methodName) && this.stack.getStackDepth() > 1) {
            String literal;
            Matcher m;
            SPPUserValue uv;
            OpcodeStack.Item valItem = this.stack.getStackItem(0);
            OpcodeStack.Item sbItem = this.stack.getStackItem(1);
            Object constant = valItem.getConstant();
            boolean argIsLiteralString = constant instanceof String && ((String)constant).length() > 0;
            boolean bl = argIsLiteralString = argIsLiteralString && !this.looksLikeStaticFieldValue((String)constant);
            if (argIsLiteralString && (uv = (SPPUserValue)sbItem.getUserValue()) != null && uv.getMethod() == SPPMethod.APPEND && (m = APPEND_PATTERN.matcher(uv.getDetails())).matches() && LITERAL.equals(m.group(2))) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_DOUBLE_APPENDED_LITERALS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                argIsLiteralString = false;
            }
            String string = literal = argIsLiteralString ? LITERAL : "";
            if (sbItem.getRegisterNumber() > -1) {
                userValue = new SPPUserValue(SPPMethod.APPEND, sbItem.getRegisterNumber() + 58 + literal);
            } else {
                userValue = (SPPUserValue)sbItem.getUserValue();
                if (userValue != null && userValue.getMethod() == SPPMethod.APPEND && (m = APPEND_PATTERN.matcher(userValue.getDetails())).matches()) {
                    userValue = new SPPUserValue(SPPMethod.APPEND, m.group(1) + ':' + literal);
                }
            }
        }
        return userValue;
    }

    private SPPUserValue stringSilliness(SPPUserValue userValue, String methodName, String signature) {
        SPPUserValue uv;
        OpcodeStack.Item item;
        OpcodeStack.Item itm;
        Object constant;
        Integer stackOffset = methodsThatAreSillyOnStringLiterals.get(new QMethod(methodName, signature));
        if (stackOffset != null && this.stack.getStackDepth() > stackOffset && (constant = (itm = this.stack.getStackItem(stackOffset.intValue())).getConstant()) != null && constant.getClass().equals(String.class) && itm.getXField() == null) {
            int priority = 2;
            if (Type.getArgumentTypes((String)this.getSigConstantOperand()).length > 0) {
                priority = 3;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_CONVERSION_OF_STRING_LITERAL.name(), priority).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addCalledMethod((DismantleBytecode)this));
        }
        if ("intern".equals(methodName)) {
            OpcodeStack.Item item2;
            String owningMethod = this.getMethod().getName();
            if (!"<clinit>".equals(owningMethod) && this.stack.getStackDepth() > 0 && (item2 = this.stack.getStackItem(0)).getConstant() != null) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_INTERN_ON_CONSTANT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        } else if ("toCharArray".equals(methodName)) {
            userValue = new SPPUserValue(SPPMethod.TOCHARARRAY);
        } else if ("toLowerCase".equals(methodName) || "toUpperCase".equals(methodName)) {
            userValue = new SPPUserValue(SPPMethod.IGNORECASE);
        } else if ("equalsIgnoreCase".equals(methodName) || "compareToIgnoreCase".equals(methodName)) {
            if (this.stack.getStackDepth() > 1) {
                String parm;
                item = this.stack.getStackItem(1);
                uv = (SPPUserValue)item.getUserValue();
                if (uv != null && uv.getMethod() == SPPMethod.IGNORECASE) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USELESS_CASING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                if ("".equals(parm = (String)(item = this.stack.getStackItem(0)).getConstant())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_EMPTY_CASING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        } else if ("trim".equals(methodName)) {
            userValue = this.getTrimUserValue();
        } else if ("length".equals(methodName)) {
            if (this.stack.getStackDepth() > 0 && (uv = (SPPUserValue)(item = this.stack.getStackItem(0)).getUserValue()) != null && uv.getMethod() == SPPMethod.TRIM) {
                if (uv.getDetails() == null) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_TEMPORARY_TRIM.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                } else {
                    this.trimLocations.put(uv, this.getPC());
                }
            }
        } else if ("equals".equals(methodName)) {
            if (this.stack.getStackDepth() > 1 && (uv = (SPPUserValue)(item = this.stack.getStackItem(1)).getUserValue()) != null && uv.getMethod() == SPPMethod.TRIM) {
                if (uv.getDetails() == null) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_TEMPORARY_TRIM.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                } else {
                    this.trimLocations.put(uv, this.getPC());
                }
            }
        } else if ("toString".equals(methodName)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_TOSTRING_ON_STRING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        return userValue;
    }

    private void equalsSilliness(String className) {
        try {
            String clsName;
            OpcodeStack.Item item;
            JavaClass cls = Repository.lookupClass((String)className);
            if (cls.isEnum()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_EQUALS_ON_ENUM.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            } else if (this.stack.getStackDepth() >= 2 && (cls = (item = this.stack.getStackItem(1)).getJavaClass()) != null && oddMissingEqualsClasses.contains(clsName = cls.getClassName())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_EQUALS_ON_STRING_BUILDER.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    private void booleanSilliness() {
        byte[] bytes;
        int ifeq;
        int range1Size;
        if (this.lastPCs[0] != -1 && (range1Size = this.lastPCs[2] - this.lastPCs[0]) == this.getNextPC() - this.lastPCs[3] && (ifeq = 0xFF & (bytes = this.getCode().getCode())[this.lastPCs[2]]) == 153) {
            int start1 = this.lastPCs[0];
            int start2 = this.lastPCs[3];
            boolean found = true;
            for (int i = 0; i < range1Size; ++i) {
                if (bytes[start1 + i] == bytes[start2 + i]) continue;
                found = false;
                break;
            }
            if (found) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_INVALID_BOOLEAN_NULL_CHECK.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }

    private void calendarBeforeAfterSilliness() {
        OpcodeStack.Item item;
        String itemSig;
        if (!(this.stack.getStackDepth() <= 1 || "Ljava/lang/Object;".equals(itemSig = (item = this.stack.getStackItem(0)).getSignature()) || "Ljava/util/Calendar;".equals(itemSig) || "Ljava/util/GregorianCalendar;".equals(itemSig))) {
            try {
                JavaClass cls = Repository.lookupClass((String)SignatureUtils.stripSignature(itemSig));
                if (!cls.instanceOf(calendarClass)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_INVALID_CALENDAR_COMPARE.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
            catch (ClassNotFoundException cnfe) {
                this.bugReporter.reportMissingClass(cnfe);
            }
        }
    }

    private void defaultToStringSilliness() throws ClassNotFoundException {
        OpcodeStack.Item item;
        JavaClass toStringClass;
        if (this.stack.getStackDepth() >= 1 && (toStringClass = (item = this.stack.getStackItem(0)).getJavaClass()) != null) {
            String toStringClassName = toStringClass.getClassName();
            if (!(toStringClass.isInterface() || toStringClass.isAbstract() || "java.lang.Object".equals(toStringClassName) || "java.lang.String".equals(toStringClassName) || !this.toStringClasses.add(toStringClassName))) {
                try {
                    JavaClass cls = Repository.lookupClass((String)toStringClassName);
                    if (!this.hasToString(cls)) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_NON_USEFUL_TOSTRING.name(), toStringClass.isFinal() ? 2 : 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                }
            }
        }
    }

    private void propertiesSilliness(String methodName) {
        OpcodeStack.Item item;
        SPPUserValue uv;
        if (("get".equals(methodName) || "getProperty".equals(methodName)) && this.stack.getStackDepth() > 1 && (uv = (SPPUserValue)(item = this.stack.getStackItem(1)).getUserValue()) != null && uv.getMethod() == SPPMethod.GETPROPERTIES) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_GETPROPERTY.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private SPPUserValue sawInvokeInterface(SPPUserValue userValue) {
        OpcodeStack.Item item;
        SPPUserValue uv;
        String method;
        String className = this.getClassConstantOperand();
        if ("java/util/Map".equals(className)) {
            method = this.getNameConstantOperand();
            if ("keySet".equals(method)) {
                userValue = new SPPUserValue(SPPMethod.KEYSET);
            }
        } else if ("java/util/Set".equals(className)) {
            OpcodeStack.Item item2;
            SPPUserValue uv2;
            method = this.getNameConstantOperand();
            if ("contains".equals(method) && this.stack.getStackDepth() >= 2 && (uv2 = (SPPUserValue)(item2 = this.stack.getStackItem(1)).getUserValue()) != null && uv2.getMethod() == SPPMethod.KEYSET) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_CONTAINSKEY.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        } else if ("java/util/List".equals(className)) {
            method = this.getNameConstantOperand();
            if ("iterator".equals(method)) {
                userValue = new SPPUserValue(SPPMethod.ITERATOR);
            }
        } else if ("java/util/Iterator".equals(className) && "next".equals(method = this.getNameConstantOperand()) && this.stack.getStackDepth() >= 1 && (uv = (SPPUserValue)(item = this.stack.getStackItem(0)).getUserValue()) != null && uv.getMethod() == SPPMethod.ITERATOR) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_GET0.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        if (collectionInterfaces.contains(className) && "size".equals(method = this.getNameConstantOperand())) {
            userValue = new SPPUserValue(SPPMethod.SIZE);
        }
        return userValue;
    }

    private void sawInvokeSpecial() {
        double v;
        OpcodeStack.Item item;
        Object constant;
        String className = this.getClassConstantOperand();
        if ("java/lang/StringBuffer".equals(className) || "java/lang/StringBuilder".equals(className)) {
            String methodName = this.getNameConstantOperand();
            if ("<init>".equals(methodName)) {
                OpcodeStack.Item item2;
                String con;
                String signature = this.getSigConstantOperand();
                if ("(I)V".equals(signature)) {
                    int parm;
                    OpcodeStack.Item item3;
                    Object o;
                    if (this.lastOpcode == 16 && this.stack.getStackDepth() > 0 && (o = (item3 = this.stack.getStackItem(0)).getConstant()) instanceof Integer && (parm = ((Integer)o).intValue()) > 32 && parm < 127 && parm != 64 && parm % 10 != 0 && parm % 5 != 0) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_NO_CHAR_SB_CTOR.name(), 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                } else if ("(Ljava/lang/String;)V".equals(signature) && this.stack.getStackDepth() > 0 && "".equals(con = (String)(item2 = this.stack.getStackItem(0)).getConstant())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_STRINGBUFFER_WITH_EMPTY_STRING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        } else if ("java/math/BigDecimal".equals(className) && this.stack.getStackDepth() > 0 && (constant = (item = this.stack.getStackItem(0)).getConstant()) instanceof Double && (v = ((Double)constant).doubleValue()) != 0.0 && v != 1.0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_BIGDECIMAL_STRING_CTOR.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private boolean looksLikeStaticFieldValue(String constant) {
        if (this.staticConstants == null) {
            Field[] fields;
            this.staticConstants = new HashSet<String>();
            for (Field f : fields = this.getClassContext().getJavaClass().getFields()) {
                ConstantValue cv;
                if ((f.getAccessFlags() & 0x18) != 24 || !"Ljava/lang/String;".equals(f.getSignature()) || (cv = f.getConstantValue()) == null) continue;
                int cvIndex = cv.getConstantValueIndex();
                this.staticConstants.add(this.getConstantPool().getConstantString(cvIndex, (byte)8));
            }
        }
        return this.staticConstants.contains(constant);
    }

    private boolean hasToString(JavaClass cls) throws ClassNotFoundException {
        do {
            for (Method m : cls.getMethods()) {
                if (!"toString".equals(m.getName()) || !"()Ljava/lang/String;".equals(m.getSignature())) continue;
                return true;
            }
        } while (!"java.lang.Object".equals((cls = cls.getSuperClass()).getClassName()));
        return false;
    }

    private SPPUserValue getTrimUserValue() {
        if (this.stack.getStackDepth() == 0) {
            return null;
        }
        OpcodeStack.Item item = this.stack.getStackItem(0);
        int reg = item.getRegisterNumber();
        if (reg >= 0) {
            return new SPPUserValue(SPPMethod.TRIM, String.valueOf(reg));
        }
        XField field = item.getXField();
        if (field != null) {
            return new SPPUserValue(SPPMethod.TRIM, field.getName());
        }
        XMethod method = item.getReturnValueOf();
        if (method != null) {
            return new SPPUserValue(SPPMethod.TRIM, method.getName());
        }
        return new SPPUserValue(SPPMethod.TRIM);
    }

    private void checkTrimLocations() {
        if (this.trimLocations.isEmpty()) {
            return;
        }
        SPPUserValue curV = this.getTrimUserValue();
        if (curV == null) {
            return;
        }
        Integer pc = this.trimLocations.remove(curV);
        if (pc != null) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_TEMPORARY_TRIM.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, pc.intValue()));
        }
    }

    static {
        try {
            calendarClass = Repository.lookupClass((String)"java/util/Calendar");
        }
        catch (ClassNotFoundException cnfe) {
            calendarClass = null;
        }
        methodsThatAreSillyOnStringLiterals = new HashMap<QMethod, Integer>();
        methodsThatAreSillyOnStringLiterals.put(new QMethod("toLowerCase", "()Ljava/lang/String;"), Values.ZERO);
        methodsThatAreSillyOnStringLiterals.put(new QMethod("toUpperCase", "()Ljava/lang/String;"), Values.ZERO);
        methodsThatAreSillyOnStringLiterals.put(new QMethod("toLowerCase", "(Ljava/util/Locale;)Ljava/lang/String;"), Values.ONE);
        methodsThatAreSillyOnStringLiterals.put(new QMethod("toUpperCase", "(Ljava/util/Locale;)Ljava/lang/String;"), Values.ONE);
        methodsThatAreSillyOnStringLiterals.put(new QMethod("trim", "()Ljava/lang/String;"), Values.ZERO);
        methodsThatAreSillyOnStringLiterals.put(new QMethod("isEmpty", "()Z"), Values.ZERO);
    }

    static class SPPUserValue {
        private SPPMethod method;
        private String details;

        public SPPUserValue(SPPMethod mthd) {
            this(mthd, null);
        }

        public SPPUserValue(SPPMethod mthd, String detail) {
            this.method = mthd;
            this.details = detail;
        }

        public SPPMethod getMethod() {
            return this.method;
        }

        public String getDetails() {
            return this.details;
        }

        public int hashCode() {
            return this.method.hashCode() ^ (this.details == null ? 0 : this.details.hashCode());
        }

        public boolean equals(Object o) {
            if (!(o instanceof SPPUserValue)) {
                return false;
            }
            SPPUserValue that = (SPPUserValue)o;
            if (this.method != that.method) {
                return false;
            }
            if (this.details == null) {
                return that.details == null;
            }
            return this.details.equals(that.details);
        }

        public String toString() {
            return ToString.build(this);
        }
    }

    static enum SPPMethod {
        APPEND,
        GETPROPERTIES,
        ICONST,
        IGNORECASE,
        ITERATOR,
        KEYSET,
        TOCHARARRAY,
        SIZE,
        TRIM;

    }
}

