/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class SluggishGui
extends BytecodeScanningDetector {
    private static final Set<String> expensiveCalls = UnmodifiableSet.create("java/io/BufferedOutputStream:<init>", "java/io/DataOutputStream:<init>", "java/io/FileOutputStream:<init>", "java/io/ObjectOutputStream:<init>", "java/io/PipedOutputStream:<init>", "java/io/BufferedInputStream:<init>", "java/io/DataInputStream:<init>", "java/io/FileInputStream:<init>", "java/io/ObjectInputStream:<init>", "java/io/PipedInputStream:<init>", "java/io/BufferedWriter:<init>", "java/io/FileWriter:<init>", "java/io/OutpuStreamWriter:<init>", "java/io/BufferedReader:<init>", "java/io/FileReader:<init>", "java/io/InputStreamReader:<init>", "java/io/RandomAccessFile:<init>", "java/lang/Class:getResourceAsStream", "java/lang/ClassLoader:getResourceAsStream", "java/lang/ClassLoader:loadClass", "java/sql/DriverManager:getConnection", "java/sql/Connection:createStatement", "java/sql/Connection:prepareStatement", "java/sql/Connection:prepareCall", "javax/sql/DataSource:getConnection", "javax/xml/parsers/DocumentBuilder:parse", "javax/xml/parsers/DocumentBuilder:parse", "javax/xml/parsers/SAXParser:parse", "javax/xml/transform/Transformer:transform");
    private BugReporter bugReporter;
    private Set<String> expensiveThisCalls;
    private Set<JavaClass> guiInterfaces;
    private Map<Code, Method> listenerCode;
    private String methodName;
    private String methodSig;
    private boolean isListenerMethod = false;
    private boolean methodReported = false;

    public SluggishGui(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass[] infs;
            this.guiInterfaces = new HashSet<JavaClass>();
            JavaClass cls = classContext.getJavaClass();
            for (JavaClass inf : infs = cls.getAllInterfaces()) {
                String name = inf.getClassName();
                if (!name.startsWith("java.awt.") && !name.startsWith("javax.swing.") || !name.endsWith("Listener")) continue;
                this.guiInterfaces.add(inf);
            }
            if (this.guiInterfaces.size() > 0) {
                this.listenerCode = new LinkedHashMap<Code, Method>();
                this.expensiveThisCalls = new HashSet<String>();
                super.visitClassContext(classContext);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.guiInterfaces = null;
            this.listenerCode = null;
            this.expensiveThisCalls = null;
        }
    }

    public void visitAfter(JavaClass obj) {
        this.isListenerMethod = true;
        for (Code l : this.listenerCode.keySet()) {
            this.methodReported = false;
            super.visitCode(l);
        }
        super.visitAfter(obj);
    }

    public void visitMethod(Method obj) {
        this.methodName = obj.getName();
        this.methodSig = obj.getSignature();
    }

    public void visitCode(Code obj) {
        for (JavaClass inf : this.guiInterfaces) {
            Method[] methods;
            for (Method m : methods = inf.getMethods()) {
                if (!m.getName().equals(this.methodName) || !m.getSignature().equals(this.methodSig)) continue;
                this.listenerCode.put(obj, this.getMethod());
                return;
            }
        }
        this.isListenerMethod = false;
        this.methodReported = false;
        super.visitCode(obj);
    }

    public void sawOpcode(int seen) {
        if (this.methodReported) {
            return;
        }
        if (seen == 185 || seen == 182 || seen == 183 || seen == 184) {
            String thisMethodInfo;
            String clsName = this.getClassConstantOperand();
            String mName = this.getNameConstantOperand();
            String methodInfo = clsName + ':' + mName;
            String string = thisMethodInfo = clsName.equals(this.getClassName()) ? mName + ':' + this.methodSig : "0";
            if (expensiveCalls.contains(methodInfo) || this.expensiveThisCalls.contains(thisMethodInfo)) {
                if (this.isListenerMethod) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SG_SLUGGISH_GUI.name(), 2).addClass((PreorderVisitor)this).addMethod(this.getClassContext().getJavaClass(), this.listenerCode.get(this.getCode())));
                } else {
                    this.expensiveThisCalls.add(this.getMethodName() + ':' + this.getMethodSig());
                }
                this.methodReported = true;
            }
        }
    }
}

