/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class SpoiledChildInterfaceImplementor
implements Detector {
    private final BugReporter bugReporter;

    public SpoiledChildInterfaceImplementor(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            if (cls.isAbstract() || cls.isInterface()) {
                return;
            }
            if ("java.lang.Object".equals(cls.getSuperclassName())) {
                return;
            }
            JavaClass[] infs = cls.getInterfaces();
            if (infs.length > 0) {
                Set<String> clsMethods = SpoiledChildInterfaceImplementor.buildMethodSet(cls);
                for (JavaClass inf : infs) {
                    Set<String> infMethods = SpoiledChildInterfaceImplementor.buildMethodSet(inf);
                    if (infMethods.size() <= 0) continue;
                    infMethods.removeAll(clsMethods);
                    if (infMethods.size() <= 0) continue;
                    JavaClass superCls = cls.getSuperClass();
                    this.filterSuperInterfaceMethods(inf, infMethods, superCls);
                    if (infMethods.size() <= 0 || superCls.implementationOf(inf)) continue;
                    int priority = AnalysisContext.currentAnalysisContext().isApplicationClass(superCls) ? 2 : 3;
                    BugInstance bi = new BugInstance((Detector)this, BugType.SCII_SPOILED_CHILD_INTERFACE_IMPLEMENTOR.name(), priority).addClass(cls).addString("Implementing interface: " + inf.getClassName()).addString("Methods:");
                    for (String nameSig : infMethods) {
                        bi.addString('\t' + nameSig);
                    }
                    this.bugReporter.reportBug(bi);
                    return;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public void report() {
    }

    private static Set<String> buildMethodSet(JavaClass cls) {
        HashSet<String> methods = new HashSet<String>();
        for (Method m : cls.getMethods()) {
            String methodName = m.getName();
            if ("<init>".equals(methodName) || "<clinit>".equals(methodName) || "clone".equals(methodName)) continue;
            methods.add(methodName + ':' + m.getSignature());
        }
        return methods;
    }

    private void filterSuperInterfaceMethods(JavaClass inf, Set<String> infMethods, JavaClass cls) {
        try {
            JavaClass[] superInfs;
            if (infMethods.isEmpty()) {
                return;
            }
            for (JavaClass superInf : superInfs = inf.getInterfaces()) {
                if (cls.implementationOf(superInf)) {
                    Set<String> superInfMethods = SpoiledChildInterfaceImplementor.buildMethodSet(superInf);
                    infMethods.removeAll(superInfMethods);
                    if (infMethods.isEmpty()) {
                        return;
                    }
                }
                this.filterSuperInterfaceMethods(superInf, infMethods, cls);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            infMethods.clear();
        }
    }

    public String toString() {
        return ToString.build(this);
    }
}

