/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class StackedTryBlocks
extends BytecodeScanningDetector {
    private static JavaClass THROWABLE_CLASS;
    private final BugReporter bugReporter;
    private List<TryBlock> blocks;
    private List<TryBlock> inBlocks;
    private List<Integer> transitionPoints;
    private OpcodeStack stack;

    public StackedTryBlocks(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            if (THROWABLE_CLASS != null) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
            }
        }
        finally {
            this.stack = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitCode(Code obj) {
        try {
            XMethod xMethod = this.getXMethod();
            if (xMethod != null) {
                CodeException[] ces;
                String[] tes = xMethod.getThrownExceptions();
                HashSet<String> thrownExceptions = new HashSet<String>(Arrays.asList(tes == null ? new String[]{} : tes));
                this.blocks = new ArrayList<TryBlock>();
                this.inBlocks = new ArrayList<TryBlock>();
                this.transitionPoints = new ArrayList<Integer>();
                for (CodeException ce : ces = obj.getExceptionTable()) {
                    TryBlock tb = new TryBlock(ce);
                    int existingBlock = this.blocks.indexOf(tb);
                    if (existingBlock >= 0) {
                        tb = this.blocks.get(existingBlock);
                        tb.addCatchType(ce);
                        continue;
                    }
                    this.blocks.add(tb);
                }
                Iterator<TryBlock> it = this.blocks.iterator();
                while (it.hasNext()) {
                    TryBlock block = it.next();
                    if (!block.hasMultipleHandlers() && !block.isFinally() && !block.catchIsThrown(this.getConstantPool(), thrownExceptions)) continue;
                    it.remove();
                }
                if (this.blocks.size() > 1) {
                    this.stack.resetForMethodEntry((DismantleBytecode)this);
                    super.visitCode(obj);
                    if (this.blocks.size() > 1) {
                        Collections.sort(this.transitionPoints);
                        TryBlock firstBlock = this.blocks.get(0);
                        for (int i = 1; i < this.blocks.size(); ++i) {
                            TryBlock secondBlock = this.blocks.get(i);
                            if (!this.blocksSplitAcrossTransitions(firstBlock, secondBlock) && firstBlock.getCatchType() == secondBlock.getCatchType() && firstBlock.getThrowSignature().equals(secondBlock.getThrowSignature()) && firstBlock.getMessage().equals(secondBlock.getMessage()) && firstBlock.getExceptionSignature().equals(secondBlock.getExceptionSignature())) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.STB_STACKED_TRY_BLOCKS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLineRange((BytecodeScanningDetector)this, firstBlock.getStartPC(), firstBlock.getEndHandlerPC()).addSourceLineRange((BytecodeScanningDetector)this, secondBlock.getStartPC(), secondBlock.getEndHandlerPC()));
                            }
                            firstBlock = secondBlock;
                        }
                    }
                }
            }
        }
        finally {
            this.blocks = null;
            this.inBlocks = null;
            this.transitionPoints = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        String message = null;
        try {
            int pc;
            TryBlock block;
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 170 || seen == 171) {
                for (int offset : this.getSwitchOffsets()) {
                    this.transitionPoints.add(offset);
                }
            } else if (StackedTryBlocks.isBranch((int)seen) && this.getBranchOffset() < 0) {
                Iterator<TryBlock> it = this.blocks.iterator();
                int target = this.getBranchTarget();
                while (it.hasNext()) {
                    TryBlock block2 = it.next();
                    if (block2.getStartPC() < target) continue;
                    it.remove();
                }
            }
            if ((block = this.findBlockWithStart(pc = this.getPC())) != null) {
                this.inBlocks.add(block);
                block.setState(TryBlock.State.IN_TRY);
            }
            if (this.inBlocks.size() > 0) {
                int nextPC;
                TryBlock innerBlock = this.inBlocks.get(this.inBlocks.size() - 1);
                if (innerBlock.atHandlerPC(nextPC = this.getNextPC())) {
                    if (seen == 167 || seen == 200) {
                        innerBlock.setEndHandlerPC(this.getBranchTarget());
                    } else {
                        this.inBlocks.remove(innerBlock);
                        this.blocks.remove(innerBlock);
                    }
                } else if (innerBlock.atHandlerPC(pc)) {
                    innerBlock.setState(TryBlock.State.IN_CATCH);
                } else if (innerBlock.atEndHandlerPC(pc)) {
                    this.inBlocks.remove(this.inBlocks.size() - 1);
                    innerBlock.setState(TryBlock.State.AFTER);
                }
                if (innerBlock.inCatch()) {
                    String cls;
                    JavaClass exCls;
                    if (seen >= 153 && seen <= 169 || seen >= 172 && seen <= 177 || seen == 200) {
                        this.blocks.remove(innerBlock);
                        this.inBlocks.remove(this.inBlocks.size() - 1);
                    } else if (seen == 191) {
                        if (this.stack.getStackDepth() > 0) {
                            OpcodeStack.Item item = this.stack.getStackItem(0);
                            XMethod xm = item.getReturnValueOf();
                            if (xm != null) {
                                innerBlock.setThrowSignature(xm.getSignature());
                            }
                            innerBlock.setExceptionSignature(item.getSignature());
                            innerBlock.setMessage((String)item.getUserValue());
                        } else {
                            this.inBlocks.remove(this.inBlocks.size() - 1);
                            innerBlock.setState(TryBlock.State.AFTER);
                        }
                    } else if (seen == 183 && "<init>".equals(this.getNameConstantOperand()) && (exCls = Repository.lookupClass((String)(cls = this.getClassConstantOperand()))).instanceOf(THROWABLE_CLASS)) {
                        String signature = this.getSigConstantOperand();
                        Type[] types = Type.getArgumentTypes((String)signature);
                        if (types.length > 0) {
                            OpcodeStack.Item item;
                            if ("Ljava/lang/String;".equals(types[0].getSignature()) && this.stack.getStackDepth() >= types.length && (message = (String)(item = this.stack.getStackItem(types.length - 1)).getConstant()) == null) {
                                message = "____UNKNOWN____" + System.identityHashCode(item);
                            }
                        } else {
                            message = "";
                        }
                    }
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (message != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue(message);
            }
        }
    }

    private TryBlock findBlockWithStart(int pc) {
        for (TryBlock block : this.blocks) {
            if (!block.atStartPC(pc)) continue;
            return block;
        }
        return null;
    }

    private boolean blocksSplitAcrossTransitions(TryBlock firstBlock, TryBlock secondBlock) {
        if (!this.transitionPoints.isEmpty()) {
            Iterator<Integer> it = this.transitionPoints.iterator();
            while (it.hasNext()) {
                Integer transitionPoint = it.next();
                if (transitionPoint < firstBlock.handlerPC) {
                    it.remove();
                    continue;
                }
                return transitionPoint < secondBlock.handlerPC;
            }
        }
        return false;
    }

    static {
        try {
            THROWABLE_CLASS = Repository.lookupClass((String)"java/lang/Throwable");
        }
        catch (ClassNotFoundException cnfe) {
            THROWABLE_CLASS = null;
        }
    }

    static class TryBlock {
        private int startPC;
        private int endPC;
        private int handlerPC;
        private int endHandlerPC;
        private BitSet catchTypes;
        private String exSig;
        private String throwSig;
        private String message;
        private State state;

        TryBlock(CodeException ce) {
            this.startPC = ce.getStartPC();
            this.endPC = ce.getEndPC();
            this.handlerPC = ce.getHandlerPC();
            this.endHandlerPC = -1;
            this.catchTypes = new BitSet();
            this.catchTypes.set(ce.getCatchType());
            this.state = State.BEFORE;
        }

        void addCatchType(CodeException ce) {
            this.catchTypes.set(ce.getCatchType());
        }

        void setState(State executionState) {
            this.state = executionState;
        }

        boolean inCatch() {
            return this.state == State.IN_CATCH;
        }

        boolean hasMultipleHandlers() {
            int bit = this.catchTypes.nextSetBit(0);
            return this.catchTypes.nextSetBit(bit + 1) >= 0;
        }

        boolean isFinally() {
            return this.catchTypes.get(0);
        }

        boolean catchIsThrown(ConstantPool pool, Set<String> thrownExceptions) {
            if (thrownExceptions.size() > 0) {
                int exIndex = this.catchTypes.nextSetBit(0);
                String exName = ((ConstantClass)pool.getConstant(exIndex)).getBytes(pool);
                return thrownExceptions.contains(exName);
            }
            return false;
        }

        void setEndHandlerPC(int end) {
            this.endHandlerPC = end;
        }

        void setExceptionSignature(String sig) {
            this.exSig = sig;
        }

        void setThrowSignature(String sig) {
            this.throwSig = sig;
        }

        void setMessage(String m) {
            this.message = m;
        }

        String getExceptionSignature() {
            return this.exSig == null ? String.valueOf(System.identityHashCode(this)) : this.exSig;
        }

        String getThrowSignature() {
            return this.throwSig == null ? String.valueOf(System.identityHashCode(this)) : this.throwSig;
        }

        String getMessage() {
            return this.message == null ? String.valueOf(System.identityHashCode(this)) : this.message;
        }

        int getStartPC() {
            return this.startPC;
        }

        int getEndHandlerPC() {
            return this.endHandlerPC;
        }

        boolean atStartPC(int pc) {
            return this.startPC == pc;
        }

        boolean atHandlerPC(int pc) {
            return this.handlerPC == pc;
        }

        boolean atEndHandlerPC(int pc) {
            return this.endHandlerPC >= 0 && this.endHandlerPC == pc;
        }

        int getCatchType() {
            return this.catchTypes.nextSetBit(0);
        }

        public int hashCode() {
            return this.startPC ^ this.endPC;
        }

        public boolean equals(Object o) {
            if (o instanceof TryBlock) {
                TryBlock that = (TryBlock)o;
                return this.startPC == that.startPC && this.endPC == that.endPC;
            }
            return false;
        }

        public String toString() {
            return ToString.build(this);
        }

        static enum State {
            BEFORE,
            IN_TRY,
            IN_CATCH,
            AFTER;

        }
    }
}

