/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class StaticMethodInstanceInvocation
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private List<PopInfo> popStack;

    public StaticMethodInstanceInvocation(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.popStack = new ArrayList<PopInfo>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.popStack = null;
        }
    }

    private boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(184);
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        if (this.prescreen(m)) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.popStack.clear();
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            OpcodeStack.Item itm;
            String popSig;
            Type result;
            String method;
            this.stack.precomputation((DismantleBytecode)this);
            int sDepth = this.stack.getStackDepth();
            Iterator<PopInfo> it = this.popStack.iterator();
            while (it.hasNext()) {
                if (sDepth >= it.next().popDepth) continue;
                it.remove();
            }
            if (seen == 184 && this.popStack.size() > 0 && (method = this.getNameConstantOperand()).indexOf(36) < 0) {
                PopInfo pInfo = this.popStack.get(0);
                Type[] args = Type.getArgumentTypes((String)this.getSigConstantOperand());
                if ((args.length > 0 || pInfo.popPC == this.getPC() - 1) && args.length == this.stack.getStackDepth() - pInfo.popDepth && this.classDefinesStaticMethod(SignatureUtils.stripSignature(pInfo.popSignature))) {
                    int lineNumber = -1;
                    if (this.lineNumberTable != null) {
                        lineNumber = this.lineNumberTable.getSourceLine(this.getPC());
                    }
                    if (pInfo.popLineNum == lineNumber) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SMII_STATIC_METHOD_INSTANCE_INVOCATION.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                    this.popStack.clear();
                }
            }
            if (seen == 58 || seen >= 75 && seen <= 78 || seen == 181 || seen == 191 || seen == 167 || seen == 200 || seen >= 153 && seen <= 166) {
                this.popStack.clear();
            } else if ((seen == 183 || seen == 185 || seen == 182 || seen == 184) && "V".equals((result = Type.getReturnType((String)this.getSigConstantOperand())).getSignature())) {
                this.popStack.clear();
            }
            if (seen == 87 && this.stack.getStackDepth() > 0 && (popSig = (itm = this.stack.getStackItem(0)).getSignature()).charAt(0) == 'L') {
                int lineNumber = -1;
                if (this.lineNumberTable != null) {
                    lineNumber = this.lineNumberTable.getSourceLine(this.getPC());
                }
                this.popStack.add(new PopInfo(this.getPC(), lineNumber, popSig, sDepth - 1));
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            this.popStack.clear();
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    boolean classDefinesStaticMethod(String popSignature) throws ClassNotFoundException {
        Method[] methods;
        if ("java.lang.Object".equals(popSignature) || "java.lang.Class".equals(popSignature)) {
            return false;
        }
        JavaClass cls = Repository.lookupClass((String)popSignature);
        for (Method m : methods = cls.getMethods()) {
            if (!m.isStatic() || !m.getName().equals(this.getNameConstantOperand()) || !m.getSignature().equals(this.getSigConstantOperand())) continue;
            return true;
        }
        return this.classDefinesStaticMethod(cls.getSuperclassName());
    }

    static class PopInfo {
        int popPC;
        int popLineNum;
        String popSignature;
        int popDepth;

        PopInfo(int pc, int lineNum, String signature, int depth) {
            this.popPC = pc;
            this.popLineNum = lineNum;
            this.popSignature = signature;
            this.popDepth = depth;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

