/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.collect.MethodInfo;
import com.mebigfatguy.fbcontrib.collect.Statistics;
import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class SuboptimalExpressionOrder
extends BytecodeScanningDetector {
    private static final int NORMAL_WEIGHT_LIMIT = 50;
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private int conditionalTarget;
    private int sawMethodWeight;

    public SuboptimalExpressionOrder(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext clsContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(clsContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.conditionalTarget = -1;
        this.sawMethodWeight = 0;
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="We don't need or want to handle every opcode")
    public void sawOpcode(int seen) {
        Integer userValue = null;
        if (this.conditionalTarget != -1 && this.getPC() >= this.conditionalTarget) {
            this.conditionalTarget = -1;
            this.sawMethodWeight = 0;
        }
        try {
            switch (seen) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    String signature = this.getSigConstantOperand();
                    Type t = Type.getReturnType((String)signature);
                    if (t == Type.VOID) {
                        this.sawMethodWeight = 0;
                        return;
                    }
                    String clsName = this.getClassConstantOperand();
                    MethodInfo mi = Statistics.getStatistics().getMethodStatistics(clsName, this.getNameConstantOperand(), signature);
                    if (mi != null && mi.getNumBytes() != 0) {
                        userValue = mi.getNumBytes();
                        return;
                    }
                    userValue = Values.ONE;
                    return;
                }
                case 126: 
                case 128: 
                case 130: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    if (this.stack.getStackDepth() < 2) {
                        this.sawMethodWeight = 0;
                        return;
                    }
                    int i = 0;
                    while (i <= 1) {
                        OpcodeStack.Item itm = this.stack.getStackItem(i);
                        userValue = (Integer)itm.getUserValue();
                        if (userValue != null) {
                            return;
                        }
                        ++i;
                    }
                    return;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    if (this.conditionalTarget < 0) {
                        this.conditionalTarget = this.getBranchTarget();
                    } else if (this.conditionalTarget != this.getBranchTarget()) {
                        this.conditionalTarget = -1;
                        this.sawMethodWeight = 0;
                        return;
                    }
                    if (this.stack.getStackDepth() < 2) return;
                    int expWeight = 0;
                    for (int i = 0; i <= 1; ++i) {
                        OpcodeStack.Item itm = this.stack.getStackItem(i);
                        Integer uv = (Integer)itm.getUserValue();
                        if (uv == null) continue;
                        expWeight = Math.max(uv, expWeight);
                    }
                    if (expWeight == 0 && this.sawMethodWeight > 0) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SEO_SUBOPTIMAL_EXPRESSION_ORDER.name(), this.sawMethodWeight >= 50 ? 2 : 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        this.sawMethodWeight = 0;
                        this.conditionalTarget = Integer.MAX_VALUE;
                        return;
                    }
                    this.sawMethodWeight = Math.max(this.sawMethodWeight, expWeight);
                    return;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 198: 
                case 199: {
                    if (this.conditionalTarget < 0) {
                        this.conditionalTarget = this.getBranchTarget();
                    } else if (this.conditionalTarget != this.getBranchTarget()) {
                        this.conditionalTarget = -1;
                        this.sawMethodWeight = 0;
                        return;
                    }
                    if (this.stack.getStackDepth() < 1) return;
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    Integer uv = (Integer)itm.getUserValue();
                    if (uv != null) {
                        this.sawMethodWeight = Math.max(this.sawMethodWeight, uv);
                        return;
                    }
                    if (this.sawMethodWeight <= 0) return;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SEO_SUBOPTIMAL_EXPRESSION_ORDER.name(), this.sawMethodWeight >= 50 ? 2 : 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    this.sawMethodWeight = 0;
                    this.conditionalTarget = Integer.MAX_VALUE;
                    return;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    if (this.stack.getStackDepth() > 0) {
                        OpcodeStack.Item itm = this.stack.getStackItem(0);
                        itm.setUserValue(null);
                    }
                    this.sawMethodWeight = 0;
                    this.conditionalTarget = -1;
                    return;
                }
                case 87: 
                case 88: 
                case 132: 
                case 167: 
                case 179: 
                case 181: 
                case 191: 
                case 193: 
                case 200: {
                    this.sawMethodWeight = 0;
                    this.conditionalTarget = -1;
                    return;
                }
                case 190: 
                case 192: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    userValue = (Integer)itm.getUserValue();
                    return;
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (userValue != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                itm.setUserValue((Object)userValue);
            }
        }
    }
}

