/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class SuspiciousClusteredSessionSupport
extends BytecodeScanningDetector {
    private static final Pattern modifyingNames = Pattern.compile("(add|insert|put|remove|clear|set).*");
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<String, Integer> changedAttributes;
    private Map<Integer, String> savedAttributes;

    public SuspiciousClusteredSessionSupport(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.changedAttributes = new HashMap<String, Integer>();
            this.savedAttributes = new HashMap<Integer, String>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.changedAttributes = null;
            this.savedAttributes = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.changedAttributes.clear();
        this.savedAttributes.clear();
        super.visitCode(obj);
        for (Integer pc : this.changedAttributes.values()) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SCSS_SUSPICIOUS_CLUSTERED_SESSION_SUPPORT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, pc.intValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        String attributeName = null;
        boolean sawGetAttribute = false;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 185) {
                String clsName = this.getClassConstantOperand();
                if ("javax/servlet/http/HttpSession".equals(clsName)) {
                    OpcodeStack.Item item2;
                    Object con;
                    String methodName = this.getNameConstantOperand();
                    if ("getAttribute".equals(methodName)) {
                        if (this.stack.getStackDepth() > 0 && (con = (item2 = this.stack.getStackItem(0)).getConstant()) instanceof String) {
                            attributeName = (String)con;
                            sawGetAttribute = true;
                        }
                    } else if ("setAttribute".equals(methodName) && this.stack.getStackDepth() > 1 && (con = (item2 = this.stack.getStackItem(1)).getConstant()) instanceof String) {
                        attributeName = (String)con;
                        this.changedAttributes.remove(attributeName);
                    }
                }
            } else if (seen >= 42 && seen <= 45 || seen == 25) {
                int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                attributeName = this.savedAttributes.get(reg);
                sawGetAttribute = attributeName != null;
            } else if ((seen >= 75 && seen <= 78 || seen == 58) && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item3 = this.stack.getStackItem(0);
                attributeName = (String)item3.getUserValue();
                int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                this.savedAttributes.put(reg, attributeName);
            }
            if (seen == 185 || seen == 182) {
                String methodName = this.getNameConstantOperand();
                Matcher m = modifyingNames.matcher(methodName);
                if (m.matches()) {
                    OpcodeStack.Item item4;
                    String signature = this.getSigConstantOperand();
                    int numArgs = Type.getArgumentTypes((String)signature).length;
                    if (this.stack.getStackDepth() > numArgs && (attributeName = (String)(item4 = this.stack.getStackItem(numArgs)).getUserValue()) != null) {
                        this.changedAttributes.put(attributeName, this.getPC());
                    }
                }
            } else if (seen >= 79 && seen <= 86 && this.stack.getStackDepth() > 2 && (attributeName = (String)(item = this.stack.getStackItem(2)).getUserValue()) != null) {
                this.changedAttributes.put(attributeName, this.getPC());
            }
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (sawGetAttribute && this.stack.getStackDepth() > 0) {
                item = this.stack.getStackItem(0);
                item.setUserValue((Object)attributeName);
            }
        }
    }
}

