/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.detect.MethodInfo;
import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class SuspiciousComparatorReturnValues
extends BytecodeScanningDetector {
    private static Map<JavaClass, MethodInfo> compareClasses = new HashMap<JavaClass, MethodInfo>();
    private OpcodeStack stack;
    private final BugReporter bugReporter;
    private MethodInfo methodInfo;
    private boolean indeterminate;
    private boolean seenNegative;
    private boolean seenPositive;
    private boolean seenZero;
    private boolean seenUnconditionalNonZero;
    private int furthestBranchTarget;
    private Integer sawConstant;

    public SuspiciousComparatorReturnValues(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            for (Map.Entry<JavaClass, MethodInfo> entry : compareClasses.entrySet()) {
                if (!cls.implementationOf(entry.getKey())) continue;
                this.methodInfo = entry.getValue();
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
                break;
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.methodInfo = null;
            this.stack = null;
        }
    }

    @SuppressFBWarnings(value={"FCBL_FIELD_COULD_BE_LOCAL"}, justification="False positives occur when state is maintained across callbacks")
    public void visitCode(Code obj) {
        if (this.getMethod().isSynthetic()) {
            return;
        }
        String methodName = this.getMethodName();
        String methodSig = this.getMethodSig();
        if (methodName.equals(this.methodInfo.methodName) && methodSig.endsWith(this.methodInfo.signatureEnding) && Type.getArgumentTypes((String)methodSig).length == this.methodInfo.argumentCount) {
            boolean seenAll;
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.indeterminate = false;
            this.seenNegative = false;
            this.seenPositive = false;
            this.seenZero = false;
            this.seenUnconditionalNonZero = false;
            this.furthestBranchTarget = -1;
            this.sawConstant = null;
            super.visitCode(obj);
            if (!(this.indeterminate || this.seenZero && !this.seenUnconditionalNonZero && obj.getCode().length <= 2 || (seenAll = this.seenNegative & this.seenPositive & this.seenZero) && !this.seenUnconditionalNonZero)) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SCRV_SUSPICIOUS_COMPARATOR_RETURN_VALUES.name(), !seenAll ? 2 : 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        try {
            if (this.indeterminate) {
                return;
            }
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 172: {
                    this.processIntegerReturn();
                    return;
                }
                case 167: 
                case 200: {
                    if (this.stack.getStackDepth() > 0) {
                        this.indeterminate = true;
                    }
                    if (this.furthestBranchTarget >= this.getBranchTarget()) return;
                    this.furthestBranchTarget = this.getBranchTarget();
                    return;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    if (this.furthestBranchTarget >= this.getBranchTarget()) return;
                    this.furthestBranchTarget = this.getBranchTarget();
                    return;
                }
                case 170: 
                case 171: {
                    int defTarget = this.getDefaultSwitchOffset() + this.getPC();
                    if (this.furthestBranchTarget <= defTarget) return;
                    this.furthestBranchTarget = defTarget;
                    return;
                }
                case 191: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    String exSig = item.getSignature();
                    if (!"Ljava/lang/UnsupportedOperationException;".equals(exSig)) return;
                    this.indeterminate = true;
                    return;
                }
                case 3: {
                    if (this.getNextOpcode() != 172) return;
                    this.sawConstant = 0;
                    return;
                }
                case 2: {
                    if (this.getNextOpcode() != 172) return;
                    this.sawConstant = -1;
                    return;
                }
                case 4: {
                    if (this.getNextOpcode() != 172) return;
                    this.sawConstant = 1;
                    return;
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private void processIntegerReturn() {
        if (this.sawConstant != null || this.stack.getStackDepth() > 0) {
            Integer returnValue = null;
            if (this.sawConstant != null) {
                returnValue = this.sawConstant;
            } else {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                returnValue = (Integer)item.getConstant();
            }
            if (returnValue == null) {
                this.indeterminate = true;
            } else {
                int v = returnValue;
                if (v < 0) {
                    this.seenNegative = true;
                    if (this.getPC() > this.furthestBranchTarget) {
                        this.seenUnconditionalNonZero = true;
                    }
                } else if (v > 0) {
                    this.seenPositive = true;
                    if (this.getPC() > this.furthestBranchTarget) {
                        this.seenUnconditionalNonZero = true;
                    }
                } else {
                    this.seenZero = true;
                }
            }
        } else {
            this.indeterminate = true;
        }
        this.sawConstant = null;
    }

    static {
        try {
            compareClasses.put(Repository.lookupClass((String)"java/lang/Comparable"), new MethodInfo("compareTo", 1, "I"));
            compareClasses.put(Repository.lookupClass((String)"java/util/Comparator"), new MethodInfo("compare", 2, "I"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

