/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.classfile.Code;

public class SuspiciousNullGuard
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, NullGuard> nullGuards;

    public SuspiciousNullGuard(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.nullGuards = new HashMap<Integer, NullGuard>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.nullGuards.clear();
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.precomputation((DismantleBytecode)this);
            Integer pc = this.getPC();
            this.nullGuards.remove(pc);
            switch (seen) {
                case 198: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    int reg = item.getRegisterNumber();
                    Integer target = this.getBranchTarget();
                    if (reg >= 0) {
                        this.nullGuards.put(target, new NullGuard(reg, (int)pc, item.getSignature()));
                        return;
                    }
                    XField xf = item.getXField();
                    if (xf == null) return;
                    this.nullGuards.put(target, new NullGuard(xf, (int)pc, item.getSignature()));
                    return;
                }
                case 58: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    if (item.isNull()) return;
                    NullGuard guard = this.findNullGuardWithRegister(RegisterUtils.getAStoreReg((DismantleBytecode)this, seen));
                    if (guard == null) return;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SNG_SUSPICIOUS_NULL_LOCAL_GUARD.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    this.removeNullGuard(guard);
                    return;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    NullGuard guard = this.findNullGuardWithRegister(RegisterUtils.getALoadReg((DismantleBytecode)this, seen));
                    if (guard == null) return;
                    this.removeNullGuard(guard);
                    return;
                }
                case 181: {
                    if (this.stack.getStackDepth() <= 1) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    if (item.isNull()) return;
                    XField xf = this.getXFieldOperand();
                    if (xf == null) return;
                    NullGuard guard = this.findNullGuardWithField(xf);
                    if (guard == null) return;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SNG_SUSPICIOUS_NULL_FIELD_GUARD.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    this.removeNullGuard(guard);
                    return;
                }
                case 180: {
                    if (this.stack.getStackDepth() <= 0) return;
                    XField xf = this.getXFieldOperand();
                    if (xf == null) return;
                    NullGuard guard = this.findNullGuardWithField(xf);
                    if (guard == null) return;
                    this.removeNullGuard(guard);
                    return;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 199: 
                case 200: {
                    this.nullGuards.clear();
                    return;
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private NullGuard findNullGuardWithRegister(int reg) {
        for (NullGuard guard : this.nullGuards.values()) {
            if (guard.getRegister() != reg) continue;
            return guard;
        }
        return null;
    }

    private NullGuard findNullGuardWithField(XField field) {
        for (NullGuard guard : this.nullGuards.values()) {
            if (!field.equals(guard.getField())) continue;
            return guard;
        }
        return null;
    }

    private void removeNullGuard(NullGuard guard) {
        Iterator<NullGuard> it = this.nullGuards.values().iterator();
        while (it.hasNext()) {
            NullGuard potentialNG = it.next();
            if (!potentialNG.equals(guard)) continue;
            it.remove();
            break;
        }
    }

    static class NullGuard {
        int register;
        XField field;
        int location;
        String signature;

        NullGuard(int reg, int start, String guardSignature) {
            this.register = reg;
            this.field = null;
            this.location = start;
            this.signature = guardSignature;
        }

        NullGuard(XField xf, int start, String guardSignature) {
            this.register = -1;
            this.field = xf;
            this.location = start;
            this.signature = guardSignature;
        }

        int getRegister() {
            return this.register;
        }

        XField getField() {
            return this.field;
        }

        int getLocation() {
            return this.location;
        }

        String getSignature() {
            return this.signature;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

