/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class SuspiciousUninitializedArray
extends BytecodeScanningDetector {
    private static final String UNINIT_ARRAY = "Unitialized Array";
    private static JavaClass THREAD_LOCAL_CLASS;
    private static final String INITIAL_VALUE = "initialValue";
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private String returnArraySig;
    private BitSet uninitializedRegs;

    public SuspiciousUninitializedArray(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.uninitializedRegs = new BitSet();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.uninitializedRegs = null;
        }
    }

    public void visitCode(Code obj) {
        String sig = this.getMethod().getSignature();
        int sigPos = sig.indexOf(")[");
        if (sigPos >= 0) {
            Method m = this.getMethod();
            if (INITIAL_VALUE.equals(m.getName())) {
                try {
                    if (THREAD_LOCAL_CLASS == null || this.getClassContext().getJavaClass().instanceOf(THREAD_LOCAL_CLASS)) {
                        return;
                    }
                }
                catch (ClassNotFoundException e) {
                    this.bugReporter.reportMissingClass(e);
                    return;
                }
            }
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.returnArraySig = sig.substring(sigPos + 1);
            this.uninitializedRegs.clear();
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        Object userValue = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 188: {
                    if (this.isTOS0()) return;
                    int typeCode = this.getIntConstant();
                    String sig = '[' + SignatureUtils.getTypeCodeSignature(typeCode);
                    if (!this.returnArraySig.equals(sig)) return;
                    userValue = UNINIT_ARRAY;
                    return;
                }
                case 189: {
                    if (this.isTOS0()) return;
                    String sig = "[L" + this.getClassConstantOperand() + ';';
                    if (!this.returnArraySig.equals(sig)) return;
                    userValue = UNINIT_ARRAY;
                    return;
                }
                case 197: {
                    if (!this.returnArraySig.equals(this.getClassConstantOperand())) return;
                    userValue = UNINIT_ARRAY;
                    return;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    String methodSig = this.getSigConstantOperand();
                    Type[] types = Type.getArgumentTypes((String)methodSig);
                    int t = 0;
                    while (t < types.length) {
                        Type type = types[t];
                        String parmSig = type.getSignature();
                        if (this.returnArraySig.equals(parmSig) || "Ljava/lang/Object;".equals(parmSig) || "[Ljava/lang/Object;".equals(parmSig)) {
                            OpcodeStack.Item item;
                            int parmIndex = types.length - t - 1;
                            if (this.stack.getStackDepth() > parmIndex && (item = this.stack.getStackItem(parmIndex)).getUserValue() != null) {
                                userValue = item.getUserValue();
                                int reg = userValue instanceof Integer ? ((Integer)userValue).intValue() : item.getRegisterNumber();
                                item.setUserValue(null);
                                if (reg >= 0) {
                                    this.uninitializedRegs.clear(reg);
                                }
                                userValue = null;
                            }
                        }
                        ++t;
                    }
                    return;
                }
                case 50: {
                    if (this.stack.getStackDepth() < 2) return;
                    OpcodeStack.Item item = this.stack.getStackItem(1);
                    if (!UNINIT_ARRAY.equals(item.getUserValue())) return;
                    userValue = item.getRegisterNumber();
                    return;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    if (this.stack.getStackDepth() < 3) {
                        this.uninitializedRegs.clear();
                        return;
                    }
                    OpcodeStack.Item item = this.stack.getStackItem(2);
                    userValue = item.getUserValue();
                    int reg = userValue instanceof Integer ? ((Integer)userValue).intValue() : item.getRegisterNumber();
                    item.setUserValue(null);
                    if (reg >= 0) {
                        this.uninitializedRegs.clear(reg);
                    }
                    userValue = null;
                    return;
                }
                case 58: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    if (this.stack.getStackDepth() > 0) {
                        OpcodeStack.Item item = this.stack.getStackItem(0);
                        this.uninitializedRegs.set(reg, UNINIT_ARRAY.equals(item.getUserValue()));
                        return;
                    }
                    this.uninitializedRegs.clear(reg);
                    return;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                    if (!this.uninitializedRegs.get(reg)) return;
                    userValue = UNINIT_ARRAY;
                    return;
                }
                case 181: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    item.setUserValue(null);
                    int reg = item.getRegisterNumber();
                    if (reg < 0) return;
                    this.uninitializedRegs.clear(reg);
                    return;
                }
                case 176: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    if (!UNINIT_ARRAY.equals(item.getUserValue())) return;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SUA_SUSPICIOUS_UNINITIALIZED_ARRAY.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    return;
                }
            }
            return;
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue(userValue);
            }
        }
    }

    private boolean isTOS0() {
        if (this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            return item.mustBeZero();
        }
        return false;
    }

    static {
        try {
            THREAD_LOCAL_CLASS = Repository.lookupClass(ThreadLocal.class);
        }
        catch (ClassNotFoundException e) {
            THREAD_LOCAL_CLASS = null;
        }
    }
}

