/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class SuspiciousWaitOnConcurrentObject
extends BytecodeScanningDetector {
    private static final Set<String> concurrentAwaitClasses = UnmodifiableSet.create("java.util.concurrent.CountDownLatch", "java.util.concurrent.CyclicBarrier");
    private BugReporter bugReporter;
    private OpcodeStack stack;

    public SuspiciousWaitOnConcurrentObject(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            int major = cls.getMajor();
            if (major >= 49) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
            }
        }
        finally {
            this.stack = null;
        }
    }

    public void visitMethod(Method obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            String clsName;
            OpcodeStack.Item itm;
            JavaClass cls;
            String methodName;
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 182 && "wait".equals(methodName = this.getNameConstantOperand()) && this.stack.getStackDepth() > 0 && (cls = (itm = this.stack.getStackItem(0)).getJavaClass()) != null && concurrentAwaitClasses.contains(clsName = cls.getClassName())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SWCO_SUSPICIOUS_WAIT_ON_CONCURRENT_OBJECT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }
}

