/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.classfile.Visitor;

public class UnboundMethodTemplateParameter
extends PreorderVisitor
implements Detector {
    private static final Pattern TEMPLATED_SIGNATURE = Pattern.compile("(\\<[^\\>]+\\>)(.+)");
    private static final Pattern TEMPLATE = Pattern.compile("\\<?([^:]+):([^;]*);");
    private final BugReporter bugReporter;

    public UnboundMethodTemplateParameter(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass cls = classContext.getJavaClass();
        cls.accept((Visitor)this);
    }

    public void visitMethod(Method obj) {
        Attribute[] attributes;
        for (Attribute a : attributes = obj.getAttributes()) {
            if (!"Signature".equals(a.getName())) continue;
            TemplateSignature ts = UnboundMethodTemplateParameter.parseSignatureAttribute((Signature)a);
            if (ts != null) {
                for (TemplateItem templateParm : ts.templateParameters) {
                    if (ts.signature.contains('T' + templateParm.templateType + ';') || ts.signature.contains("[T" + templateParm.templateType + ';') || this.isTemplateParent(templateParm.templateType, ts.templateParameters)) continue;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UMTP_UNBOUND_METHOD_TEMPLATE_PARAMETER.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addString("Template Parameter: " + templateParm.templateType));
                    return;
                }
            }
            return;
        }
    }

    public void report() {
    }

    private boolean isTemplateParent(String templateType, TemplateItem ... items) {
        for (TemplateItem item : items) {
            if (!templateType.equals(item.templateExtension)) continue;
            return true;
        }
        return false;
    }

    private static TemplateSignature parseSignatureAttribute(Signature signatureAttribute) {
        Matcher m = TEMPLATED_SIGNATURE.matcher(signatureAttribute.getSignature());
        if (m.matches()) {
            TemplateSignature ts = new TemplateSignature();
            ts.signature = m.group(2);
            m = TEMPLATE.matcher(m.group(1));
            ArrayList<TemplateItem> templates = new ArrayList<TemplateItem>(4);
            while (m.find()) {
                templates.add(new TemplateItem(m.group(1), m.group(2)));
            }
            ts.templateParameters = templates.toArray(new TemplateItem[templates.size()]);
            return ts;
        }
        return null;
    }

    static class TemplateItem {
        String templateType;
        String templateExtension;

        public TemplateItem(String type, String extension) {
            this.templateType = type;
            this.templateExtension = extension.startsWith("L") ? "" : extension.substring(1);
        }

        public String toString() {
            return ToString.build(this);
        }
    }

    static class TemplateSignature {
        TemplateItem[] templateParameters;
        String signature;

        TemplateSignature() {
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

