/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class UnitTestAssertionOddities
extends BytecodeScanningDetector {
    private static final String BOOLEAN_TYPE_SIGNATURE = "Ljava/lang/Boolean;";
    private static final String LJAVA_LANG_DOUBLE = "Ljava/lang/Double;";
    private static final String TESTCASE_CLASS = "junit.framework.TestCase";
    private static final String TEST_CLASS = "org.junit.Test";
    private static final String TEST_ANNOTATION_SIGNATURE = "Lorg/junit/Test;";
    private static final String OLD_ASSERT_CLASS = "junit/framework/Assert";
    private static final String NEW_ASSERT_CLASS = "org/junit/Assert";
    private static final String TESTNG_CLASS = "org.testng.annotations.Test";
    private static final String TESTNG_ANNOTATION_SIGNATURE = "Lorg/testng/annotations/Test;";
    private static final String NG_ASSERT_CLASS = "org/testng/Assert";
    private static final String NG_JUNIT_ASSERT_CLASS = "org/testng/AssertJUnit";
    private BugReporter bugReporter;
    private JavaClass testCaseClass;
    private JavaClass testAnnotationClass;
    private JavaClass testNGAnnotationClass;
    private OpcodeStack stack;
    private boolean isTestCaseDerived;
    private boolean isAnnotationCapable;
    private String clsName;
    private boolean sawAssert;
    private State state;
    private boolean checkIsNegated;
    private TestFrameworkType frameworkType;
    private boolean hasAnnotation;
    private Set<FieldDescriptor> fieldsWithAnnotations;

    public UnitTestAssertionOddities(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        try {
            this.testCaseClass = Repository.lookupClass((String)TESTCASE_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            this.testCaseClass = null;
        }
        try {
            this.testAnnotationClass = Repository.lookupClass((String)TEST_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            this.testAnnotationClass = null;
        }
        try {
            this.testNGAnnotationClass = Repository.lookupClass((String)TESTNG_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            this.testNGAnnotationClass = null;
        }
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            this.clsName = cls.getClassName().replace('.', '/');
            this.isTestCaseDerived = this.testCaseClass != null && cls.instanceOf(this.testCaseClass);
            boolean bl = this.isAnnotationCapable = cls.getMajor() >= 5 && (this.testAnnotationClass != null || this.testNGAnnotationClass != null);
            if (this.isTestCaseDerived || this.isAnnotationCapable) {
                this.stack = new OpcodeStack();
                this.fieldsWithAnnotations = new HashSet<FieldDescriptor>();
                super.visitClassContext(classContext);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.stack = null;
            this.fieldsWithAnnotations = null;
        }
    }

    @SuppressFBWarnings(value={"FCBL_FIELD_COULD_BE_LOCAL"}, justification="False positives occur when state is maintained across callbacks")
    public void visitCode(Code obj) {
        AnnotationEntry[] annotations;
        Method m = this.getMethod();
        this.frameworkType = this.isTestCaseDerived && m.getName().startsWith("test") ? TestFrameworkType.JUNIT : TestFrameworkType.UNKNOWN;
        this.hasAnnotation = false;
        if (this.frameworkType == TestFrameworkType.UNKNOWN && this.isAnnotationCapable && (annotations = m.getAnnotationEntries()) != null) {
            for (AnnotationEntry annotation : annotations) {
                String annotationType = annotation.getAnnotationType();
                if (!annotation.isRuntimeVisible()) continue;
                if (TEST_ANNOTATION_SIGNATURE.equals(annotationType)) {
                    this.frameworkType = TestFrameworkType.JUNIT;
                    this.hasAnnotation = true;
                    break;
                }
                if (!TESTNG_ANNOTATION_SIGNATURE.equals(annotationType)) continue;
                this.frameworkType = TestFrameworkType.TESTNG;
                this.hasAnnotation = true;
                break;
            }
        }
        if (this.frameworkType != TestFrameworkType.UNKNOWN) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.state = State.SAW_NOTHING;
            this.sawAssert = false;
            super.visitCode(obj);
            if (!this.sawAssert && !this.hasExpects()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, this.frameworkType == TestFrameworkType.JUNIT ? BugType.UTAO_JUNIT_ASSERTION_ODDITIES_NO_ASSERT.name() : BugType.UTAO_TESTNG_ASSERTION_ODDITIES_NO_ASSERT.name(), 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this));
            }
        }
    }

    public void visitField(Field obj) {
        if (obj.getAnnotationEntries().length > 0) {
            this.fieldsWithAnnotations.add(this.getFieldDescriptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"}, justification="Constrained by FindBugs API")
    public void sawOpcode(int seen) {
        block75: {
            block76: {
                block74: {
                    block72: {
                        block73: {
                            block66: {
                                block71: {
                                    block70: {
                                        block69: {
                                            block67: {
                                                block68: {
                                                    block65: {
                                                        block61: {
                                                            block64: {
                                                                block63: {
                                                                    block62: {
                                                                        userValue = null;
                                                                        try {
                                                                            this.stack.precomputation((DismantleBytecode)this);
                                                                            if (seen != 184) ** GOTO lbl215
                                                                            clsName = this.getClassConstantOperand();
                                                                            if (!"junit/framework/Assert".equals(clsName) && !"org/junit/Assert".equals(clsName) && !"org/testng/AssertJUnit".equals(clsName)) ** GOTO lbl96
                                                                            this.sawAssert = true;
                                                                            if (this.hasAnnotation && this.frameworkType == TestFrameworkType.JUNIT && "junit/framework/Assert".equals(clsName)) {
                                                                                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_JUNIT_ASSERTION_ODDITIES_USING_DEPRECATED.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                                                            }
                                                                            if (!"assertEquals".equals(methodName = this.getNameConstantOperand())) ** GOTO lbl70
                                                                            signature = this.getSigConstantOperand();
                                                                            argTypes = Type.getArgumentTypes((String)signature);
                                                                            if (argTypes.length != 2 && argTypes.length != 3 || this.stack.getStackDepth() < 2) break block61;
                                                                            item0 = this.stack.getStackItem(0);
                                                                            expectedItem = this.stack.getStackItem(1);
                                                                            cons1 = expectedItem.getConstant();
                                                                            if (cons1 == null || !"Ljava/lang/Boolean;".equals(expectedItem.getSignature()) || !"Ljava/lang/Boolean;".equals(item0.getSignature())) break block62;
                                                                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_JUNIT_ASSERTION_ODDITIES_BOOLEAN_ASSERT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                                                        }
                                                                        catch (Throwable var11_35) {
                                                                            TernaryPatcher.pre(this.stack, seen);
                                                                            this.stack.sawOpcode((DismantleBytecode)this, seen);
                                                                            TernaryPatcher.post(this.stack, seen);
                                                                            if (userValue != null && this.stack.getStackDepth() > 0) {
                                                                                item = this.stack.getStackItem(0);
                                                                                item.setUserValue(userValue);
                                                                            }
                                                                            throw var11_35;
                                                                        }
                                                                        TernaryPatcher.pre(this.stack, seen);
                                                                        this.stack.sawOpcode((DismantleBytecode)this, seen);
                                                                        TernaryPatcher.post(this.stack, seen);
                                                                        if (userValue != null && this.stack.getStackDepth() > 0) {
                                                                            item = this.stack.getStackItem(0);
                                                                            item.setUserValue((Object)userValue);
                                                                        }
                                                                        return;
                                                                    }
                                                                    if (cons1 != null || item0.getConstant() == null || argTypes.length != 2 && this.isFloatingPtPrimitive(item0.getSignature())) break block63;
                                                                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_JUNIT_ASSERTION_ODDITIES_ACTUAL_CONSTANT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                                                    TernaryPatcher.pre(this.stack, seen);
                                                                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                                                                    TernaryPatcher.post(this.stack, seen);
                                                                    if (userValue != null && this.stack.getStackDepth() > 0) {
                                                                        item = this.stack.getStackItem(0);
                                                                        item.setUserValue((Object)userValue);
                                                                    }
                                                                    return;
                                                                }
                                                                if (!expectedItem.isNull()) break block64;
                                                                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_JUNIT_ASSERTION_ODDITIES_USE_ASSERT_NULL.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                                                TernaryPatcher.pre(this.stack, seen);
                                                                this.stack.sawOpcode((DismantleBytecode)this, seen);
                                                                TernaryPatcher.post(this.stack, seen);
                                                                if (userValue != null && this.stack.getStackDepth() > 0) {
                                                                    item = this.stack.getStackItem(0);
                                                                    item.setUserValue((Object)userValue);
                                                                }
                                                                return;
                                                            }
                                                            if (!argTypes[argTypes.length - 1].equals((Object)Type.DOUBLE) || !argTypes[argTypes.length - 2].equals((Object)Type.DOUBLE) || argTypes.length >= 3 && argTypes[argTypes.length - 3].equals((Object)Type.DOUBLE)) break block61;
                                                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_JUNIT_ASSERTION_ODDITIES_INEXACT_DOUBLE.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                                            TernaryPatcher.pre(this.stack, seen);
                                                            this.stack.sawOpcode((DismantleBytecode)this, seen);
                                                            TernaryPatcher.post(this.stack, seen);
                                                            if (userValue != null && this.stack.getStackDepth() > 0) {
                                                                item = this.stack.getStackItem(0);
                                                                item.setUserValue((Object)userValue);
                                                            }
                                                            return;
                                                        }
                                                        ** GOTO lbl218
lbl70:
                                                        // 1 sources

                                                        if (!"assertNotEquals".equals(methodName)) ** GOTO lbl85
                                                        signature = this.getSigConstantOperand();
                                                        argTypes = Type.getArgumentTypes((String)signature);
                                                        if (argTypes.length != 2 && argTypes.length != 3 || this.stack.getStackDepth() < 2 || !(expectedItem = this.stack.getStackItem(1)).isNull()) break block65;
                                                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_JUNIT_ASSERTION_ODDITIES_USE_ASSERT_NOT_NULL.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                                        TernaryPatcher.pre(this.stack, seen);
                                                        this.stack.sawOpcode((DismantleBytecode)this, seen);
                                                        TernaryPatcher.post(this.stack, seen);
                                                        if (userValue != null && this.stack.getStackDepth() > 0) {
                                                            item = this.stack.getStackItem(0);
                                                            item.setUserValue((Object)userValue);
                                                        }
                                                        return;
                                                    }
                                                    ** GOTO lbl218
lbl85:
                                                    // 1 sources

                                                    if ("assertNotNull".equals(methodName)) {
                                                        if (this.stack.getStackDepth() > 0 && "valueOf".equals(this.stack.getStackItem(0).getUserValue())) {
                                                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_JUNIT_ASSERTION_ODDITIES_IMPOSSIBLE_NULL.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                                        }
                                                    } else if (!this.checkIsNegated && "assertTrue".equals(methodName) || this.checkIsNegated && "assertFalse".equals(methodName)) {
                                                        if (this.state == State.SAW_ICONST_0 || this.state == State.SAW_EQUALS) {
                                                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_JUNIT_ASSERTION_ODDITIES_USE_ASSERT_EQUALS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                                        }
                                                    } else if ((!this.checkIsNegated && "assertFalse".equals(methodName) || this.checkIsNegated && "assertTrue".equals(methodName)) && (this.state == State.SAW_ICONST_0 || this.state == State.SAW_EQUALS)) {
                                                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_JUNIT_ASSERTION_ODDITIES_USE_ASSERT_NOT_EQUALS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                                    }
                                                    ** GOTO lbl218
lbl96:
                                                    // 1 sources

                                                    if (!"org/testng/Assert".equals(clsName)) ** GOTO lbl210
                                                    this.sawAssert = true;
                                                    methodName = this.getNameConstantOperand();
                                                    if (!"assertEquals".equals(methodName)) ** GOTO lbl167
                                                    signature = this.getSigConstantOperand();
                                                    argTypes = Type.getArgumentTypes((String)signature);
                                                    if (argTypes.length != 2 && argTypes.length != 3) break block66;
                                                    if (argTypes.length == 2 && this.stack.getStackDepth() >= 2) {
                                                        expectedItem = this.stack.getStackItem(0);
                                                        actualItem = this.stack.getStackItem(1);
                                                        break block67;
                                                    }
                                                    if (argTypes.length != 3 || this.stack.getStackDepth() < 3) break block68;
                                                    expectedItem = this.stack.getStackItem(1);
                                                    actualItem = this.stack.getStackItem(2);
                                                    break block67;
                                                }
                                                TernaryPatcher.pre(this.stack, seen);
                                                this.stack.sawOpcode((DismantleBytecode)this, seen);
                                                TernaryPatcher.post(this.stack, seen);
                                                if (userValue != null && this.stack.getStackDepth() > 0) {
                                                    item = this.stack.getStackItem(0);
                                                    item.setUserValue((Object)userValue);
                                                }
                                                return;
                                            }
                                            cons1 = expectedItem.getConstant();
                                            if (cons1 == null || !argTypes[0].equals((Object)Type.BOOLEAN) || !argTypes[1].equals((Object)Type.BOOLEAN)) break block69;
                                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_TESTNG_ASSERTION_ODDITIES_BOOLEAN_ASSERT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                            TernaryPatcher.pre(this.stack, seen);
                                            this.stack.sawOpcode((DismantleBytecode)this, seen);
                                            TernaryPatcher.post(this.stack, seen);
                                            if (userValue != null && this.stack.getStackDepth() > 0) {
                                                item = this.stack.getStackItem(0);
                                                item.setUserValue((Object)userValue);
                                            }
                                            return;
                                        }
                                        if (actualItem.getConstant() == null || expectedItem.getConstant() != null || argTypes.length != 2 && this.isFloatingPtPrimitive(actualItem.getSignature())) break block70;
                                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_TESTNG_ASSERTION_ODDITIES_ACTUAL_CONSTANT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                        TernaryPatcher.pre(this.stack, seen);
                                        this.stack.sawOpcode((DismantleBytecode)this, seen);
                                        TernaryPatcher.post(this.stack, seen);
                                        if (userValue != null && this.stack.getStackDepth() > 0) {
                                            item = this.stack.getStackItem(0);
                                            item.setUserValue((Object)userValue);
                                        }
                                        return;
                                    }
                                    if (!expectedItem.isNull()) break block71;
                                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_TESTNG_ASSERTION_ODDITIES_USE_ASSERT_NULL.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                    TernaryPatcher.pre(this.stack, seen);
                                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                                    TernaryPatcher.post(this.stack, seen);
                                    if (userValue != null && this.stack.getStackDepth() > 0) {
                                        item = this.stack.getStackItem(0);
                                        item.setUserValue((Object)userValue);
                                    }
                                    return;
                                }
                                if (!argTypes[0].equals((Object)Type.OBJECT) || !argTypes[1].equals((Object)Type.OBJECT) || !"Ljava/lang/Double;".equals(actualItem.getSignature()) || !"Ljava/lang/Double;".equals(expectedItem.getSignature())) break block66;
                                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_TESTNG_ASSERTION_ODDITIES_INEXACT_DOUBLE.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                TernaryPatcher.pre(this.stack, seen);
                                this.stack.sawOpcode((DismantleBytecode)this, seen);
                                TernaryPatcher.post(this.stack, seen);
                                if (userValue != null && this.stack.getStackDepth() > 0) {
                                    item = this.stack.getStackItem(0);
                                    item.setUserValue((Object)userValue);
                                }
                                return;
                            }
                            ** GOTO lbl218
lbl167:
                            // 1 sources

                            if (!"assertNotEquals".equals(methodName)) ** GOTO lbl199
                            signature = this.getSigConstantOperand();
                            argTypes = Type.getArgumentTypes((String)signature);
                            if (argTypes.length == 2 && this.stack.getStackDepth() >= 2) {
                                expectedItem = this.stack.getStackItem(0);
                                break block72;
                            }
                            if (argTypes.length != 3 || this.stack.getStackDepth() < 3) break block73;
                            expectedItem = this.stack.getStackItem(1);
                            break block72;
                        }
                        TernaryPatcher.pre(this.stack, seen);
                        this.stack.sawOpcode((DismantleBytecode)this, seen);
                        TernaryPatcher.post(this.stack, seen);
                        if (userValue != null && this.stack.getStackDepth() > 0) {
                            item = this.stack.getStackItem(0);
                            item.setUserValue((Object)userValue);
                        }
                        return;
                    }
                    fld = expectedItem.getXField();
                    if (fld != null && this.fieldsWithAnnotations.contains(fld.getFieldDescriptor()) || !expectedItem.isNull()) break block74;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_TESTNG_ASSERTION_ODDITIES_USE_ASSERT_NOT_NULL.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    TernaryPatcher.pre(this.stack, seen);
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    TernaryPatcher.post(this.stack, seen);
                    if (userValue != null && this.stack.getStackDepth() > 0) {
                        item = this.stack.getStackItem(0);
                        item.setUserValue((Object)userValue);
                    }
                    return;
                }
                break block76;
lbl199:
                // 1 sources

                if ("assertNotNull".equals(methodName)) {
                    if (this.stack.getStackDepth() > 0 && "valueOf".equals(this.stack.getStackItem(0).getUserValue())) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_TESTNG_ASSERTION_ODDITIES_IMPOSSIBLE_NULL.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                } else if (!this.checkIsNegated && "assertTrue".equals(methodName) || this.checkIsNegated && "assertFalse".equals(methodName)) {
                    if (this.state == State.SAW_ICONST_0 || this.state == State.SAW_EQUALS) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_TESTNG_ASSERTION_ODDITIES_USE_ASSERT_EQUALS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                } else if ((!this.checkIsNegated && "assertFalse".equals(methodName) || this.checkIsNegated && "assertTrue".equals(methodName)) && (this.state == State.SAW_ICONST_0 || this.state == State.SAW_EQUALS)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UTAO_TESTNG_ASSERTION_ODDITIES_USE_ASSERT_NOT_EQUALS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                break block76;
lbl210:
                // 1 sources

                methodName = this.getNameConstantOperand();
                sig = this.getSigConstantOperand();
                if (clsName.startsWith("java/lang/") && "valueOf".equals(methodName) && sig.indexOf(")Ljava/lang/") >= 0) {
                    userValue = "valueOf";
                }
                break block76;
lbl215:
                // 1 sources

                if (seen == 191 && this.stack.getStackDepth() > 0 && "Ljava/lang/AssertionError;".equals(throwClass = (item = this.stack.getStackItem(0)).getSignature())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, this.frameworkType == TestFrameworkType.JUNIT ? BugType.UTAO_JUNIT_ASSERTION_ODDITIES_ASSERT_USED.name() : BugType.UTAO_TESTNG_ASSERTION_ODDITIES_ASSERT_USED.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    this.sawAssert = true;
                }
            }
            switch (1.$SwitchMap$com$mebigfatguy$fbcontrib$detect$UnitTestAssertionOddities$State[this.state.ordinal()]) {
                case 1: 
                case 2: {
                    this.checkIsNegated = false;
                    if (seen == 160) {
                        this.state = State.SAW_IF_ICMPNE;
                        break;
                    }
                    if (seen == 154) {
                        this.state = State.SAW_IF_NE;
                        this.checkIsNegated = true;
                        break;
                    }
                    if (seen == 159) {
                        this.state = State.SAW_IF_ICMPEQ;
                        this.checkIsNegated = true;
                        break;
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (seen == 4) {
                        this.state = State.SAW_ICONST_1;
                        break;
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                case 6: {
                    if (seen == 167) {
                        this.state = State.SAW_GOTO;
                        break;
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                case 7: {
                    if (seen == 3) {
                        this.state = State.SAW_ICONST_0;
                        break;
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                default: {
                    this.state = State.SAW_NOTHING;
                }
            }
            if (seen != 182 && seen != 184 && seen != 183) break block75;
            lcName = this.getNameConstantOperand().toLowerCase();
            if (seen == 182) {
                sig = this.getSigConstantOperand();
                if ("equals".equals(lcName) && "(Ljava/lang/Object;)Z".equals(sig)) {
                    this.state = State.SAW_EQUALS;
                }
            }
            if (!this.clsName.equals(this.getClassConstantOperand()) && !lcName.contains("assert") && !lcName.contains("verify")) break block75;
            this.sawAssert = true;
        }
        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
        if (userValue != null && this.stack.getStackDepth() > 0) {
            item = this.stack.getStackItem(0);
            item.setUserValue((Object)userValue);
        }
    }

    private boolean isFloatingPtPrimitive(String signature) {
        return "D".equals(signature) || "F".equals(signature);
    }

    private boolean hasExpects() {
        AnnotationEntry[] annotations = this.getMethod().getAnnotationEntries();
        if (annotations != null) {
            for (AnnotationEntry annotation : annotations) {
                ElementValuePair[] evPairs;
                String type = annotation.getAnnotationType();
                if (!TEST_ANNOTATION_SIGNATURE.equals(type) && !TESTNG_ANNOTATION_SIGNATURE.equals(type) || (evPairs = annotation.getElementValuePairs()) == null) continue;
                for (ElementValuePair evPair : evPairs) {
                    String evName = evPair.getNameString();
                    if (!"expected".equals(evName) && !"expectedExceptions".equals(evName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static enum TestFrameworkType {
        UNKNOWN,
        JUNIT,
        TESTNG;

    }

    private static enum State {
        SAW_NOTHING,
        SAW_IF_ICMPNE,
        SAW_IF_NE,
        SAW_IF_ICMPEQ,
        SAW_ICONST_1,
        SAW_GOTO,
        SAW_ICONST_0,
        SAW_EQUALS;

    }
}

