/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class UnnecessaryStoreBeforeReturn
extends BytecodeScanningDetector {
    private static final BitSet branchInstructions = new BitSet();
    private static final BitSet binaryOps = new BitSet();
    private final BugReporter bugReporter;
    private Set<Integer> branchTargets;
    private Set<Integer> catchTargets;
    private OpcodeStack stack;
    private State state;
    private int storeReg;

    public UnnecessaryStoreBeforeReturn(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.branchTargets = new HashSet<Integer>();
            this.catchTargets = new HashSet<Integer>();
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.branchTargets = null;
            this.catchTargets = null;
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        String sig = m.getSignature();
        Type t = Type.getReturnType((String)sig);
        if (!t.equals((Object)Type.VOID)) {
            this.state = State.SEEN_NOTHING;
            this.branchTargets.clear();
            CodeException[] ces = obj.getExceptionTable();
            this.catchTargets.clear();
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            for (CodeException ce : ces) {
                if (ce.getCatchType() == 0) continue;
                this.catchTargets.add(ce.getHandlerPC());
            }
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        int lhsReg = -1;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (this.state) {
                case SEEN_NOTHING: {
                    Integer reg;
                    if (this.catchTargets.contains(this.getPC()) || !this.lookForStore(seen) || this.stack.getStackDepth() < 1 || (reg = (Integer)(item = this.stack.getStackItem(0)).getUserValue()) != null && reg == this.storeReg) break;
                    this.state = State.SEEN_STORE;
                    break;
                }
                case SEEN_STORE: {
                    if (this.branchTargets.contains(this.getPC())) {
                        this.state = State.SEEN_NOTHING;
                        break;
                    }
                    this.state = this.lookForLoad(seen) ? State.SEEN_LOAD : State.SEEN_NOTHING;
                    break;
                }
                case SEEN_LOAD: {
                    if (seen >= 172 && seen <= 176) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.USBR_UNNECESSARY_STORE_BEFORE_RETURN.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                    this.state = State.SEEN_NOTHING;
                }
            }
            if (branchInstructions.get(seen)) {
                this.branchTargets.add(this.getBranchTarget());
            }
            lhsReg = this.processBinOp(seen);
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (lhsReg > -1 && this.stack.getStackDepth() >= 1) {
                item = this.stack.getStackItem(0);
                item.setUserValue((Object)lhsReg);
            }
        }
    }

    private boolean lookForStore(int seen) {
        if (seen >= 54 && seen <= 58) {
            this.storeReg = this.getRegisterOperand();
        } else if (seen >= 59 && seen <= 62) {
            this.storeReg = seen - 59;
        } else if (seen >= 63 && seen <= 66) {
            this.storeReg = seen - 63;
        } else if (seen >= 67 && seen <= 70) {
            this.storeReg = seen - 67;
        } else if (seen >= 71 && seen <= 74) {
            this.storeReg = seen - 71;
        } else if (seen >= 75 && seen <= 78) {
            this.storeReg = seen - 75;
        } else {
            return false;
        }
        return true;
    }

    private boolean lookForLoad(int seen) {
        int loadReg;
        if (seen >= 21 && seen <= 25) {
            loadReg = this.getRegisterOperand();
        } else if (seen >= 26 && seen <= 29) {
            loadReg = seen - 26;
        } else if (seen >= 30 && seen <= 33) {
            loadReg = seen - 30;
        } else if (seen >= 34 && seen <= 37) {
            loadReg = seen - 34;
        } else if (seen >= 38 && seen <= 41) {
            loadReg = seen - 38;
        } else if (seen >= 42 && seen <= 45) {
            loadReg = seen - 42;
        } else {
            return false;
        }
        return this.storeReg == loadReg;
    }

    private int processBinOp(int seen) {
        if (binaryOps.get(seen) && this.stack.getStackDepth() >= 2) {
            OpcodeStack.Item item = this.stack.getStackItem(1);
            return item.getRegisterNumber();
        }
        return -1;
    }

    static {
        branchInstructions.set(167);
        branchInstructions.set(200);
        branchInstructions.set(153);
        branchInstructions.set(154);
        branchInstructions.set(155);
        branchInstructions.set(156);
        branchInstructions.set(157);
        branchInstructions.set(158);
        branchInstructions.set(159);
        branchInstructions.set(160);
        branchInstructions.set(161);
        branchInstructions.set(162);
        branchInstructions.set(163);
        branchInstructions.set(164);
        branchInstructions.set(165);
        branchInstructions.set(166);
        branchInstructions.set(198);
        branchInstructions.set(199);
        binaryOps.set(96);
        binaryOps.set(97);
        binaryOps.set(98);
        binaryOps.set(99);
        binaryOps.set(100);
        binaryOps.set(101);
        binaryOps.set(102);
        binaryOps.set(103);
        binaryOps.set(104);
        binaryOps.set(105);
        binaryOps.set(106);
        binaryOps.set(107);
        binaryOps.set(108);
        binaryOps.set(109);
        binaryOps.set(110);
        binaryOps.set(111);
        binaryOps.set(112);
        binaryOps.set(113);
        binaryOps.set(114);
        binaryOps.set(115);
        binaryOps.set(128);
        binaryOps.set(129);
        binaryOps.set(126);
        binaryOps.set(127);
        binaryOps.set(130);
        binaryOps.set(131);
        binaryOps.set(120);
        binaryOps.set(121);
        binaryOps.set(122);
        binaryOps.set(123);
        binaryOps.set(124);
        binaryOps.set(125);
    }

    static enum State {
        SEEN_NOTHING,
        SEEN_STORE,
        SEEN_LOAD;

    }
}

