/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.FQMethod;
import com.mebigfatguy.fbcontrib.utils.ToString;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class UseCharacterParameterizedMethod
extends BytecodeScanningDetector {
    private static final Map<FQMethod, Object> characterMethods;
    private final BugReporter bugReporter;
    private OpcodeStack stack;

    public UseCharacterParameterizedMethod(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext context) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(context);
        }
        finally {
            this.stack = null;
        }
    }

    private boolean prescreen(Method obj) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(obj);
        return bytecodeSet != null && (bytecodeSet.get(18) || bytecodeSet.get(19));
    }

    public void visitCode(Code obj) {
        if (this.prescreen(this.getMethod())) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            OpcodeStack.Item itm;
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 182 || seen == 185) {
                FQMethod key = new FQMethod(this.getClassConstantOperand(), this.getNameConstantOperand(), this.getSigConstantOperand());
                Object posObject = characterMethods.get(key);
                if (posObject instanceof Integer) {
                    if (this.checkSingleParamMethod((Integer)posObject) && !this.isInlineAppend(key)) {
                        this.reportBug();
                    }
                } else if (posObject instanceof IntPair && this.checkDoubleParamMethod((IntPair)posObject)) {
                    this.reportBug();
                }
            } else if (seen == 89) {
                String duppedSig;
                if (this.stack.getStackDepth() > 0 && ("Ljava/lang/StringBuilder;".equals(duppedSig = (itm = this.stack.getStackItem(0)).getSignature()) || "Ljava/lang/StringBuffer;".equals(duppedSig))) {
                    itm.setUserValue((Object)UCPMUserValue.INLINE);
                }
            } else if ((seen == 58 || seen >= 75 && seen <= 78 || seen == 181 || seen == 179) && this.stack.getStackDepth() > 0) {
                itm = this.stack.getStackItem(0);
                itm.setUserValue(null);
            }
        }
        finally {
            UCPMUserValue uv = this.callHasInline(seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (uv == UCPMUserValue.INLINE && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                itm.setUserValue((Object)uv);
            }
        }
    }

    private void reportBug() {
        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UCPM_USE_CHARACTER_PARAMETERIZED_METHOD.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
    }

    private boolean checkDoubleParamMethod(IntPair posObject) {
        return this.checkSingleParamMethod(posObject.firstStringParam) && this.checkSingleParamMethod(posObject.secondStringParam);
    }

    private boolean checkSingleParamMethod(int paramPos) {
        OpcodeStack.Item itm;
        CharSequence con;
        return this.stack.getStackDepth() > paramPos && (con = (CharSequence)(itm = this.stack.getStackItem(paramPos)).getConstant()) != null && con.length() == 1;
    }

    private boolean isInlineAppend(FQMethod fqm) {
        if (!"java/lang/StringBuilder".equals(fqm.getClassName()) && !"java/lang/StringBuffer".equals(fqm.getClassName())) {
            return false;
        }
        if (this.stack.getStackDepth() > 1) {
            OpcodeStack.Item itm = this.stack.getStackItem(1);
            return itm.getUserValue() == UCPMUserValue.INLINE;
        }
        return true;
    }

    private UCPMUserValue callHasInline(int seen) {
        if (seen != 182) {
            return null;
        }
        String sig = this.getSigConstantOperand();
        String returnSig = Type.getReturnType((String)sig).getSignature();
        if ("Ljava/lang/StringBuilder;".equals(returnSig) || "Ljava/lang/StringBuffer;".equals(returnSig)) {
            int parmCount = Type.getArgumentTypes((String)sig).length;
            if (this.stack.getStackDepth() > parmCount) {
                OpcodeStack.Item itm = this.stack.getStackItem(parmCount);
                return (UCPMUserValue)((Object)itm.getUserValue());
            }
        }
        return null;
    }

    static {
        HashMap<FQMethod, Object> methodsMap = new HashMap<FQMethod, Object>();
        methodsMap.put(new FQMethod("java/lang/String", "indexOf", "(Ljava/lang/String;)I"), Values.ZERO);
        methodsMap.put(new FQMethod("java/lang/String", "indexOf", "(Ljava/lang/String;I)I"), Values.ONE);
        methodsMap.put(new FQMethod("java/lang/String", "lastIndexOf", "(Ljava/lang/String;)I"), Values.ZERO);
        methodsMap.put(new FQMethod("java/lang/String", "lastIndexOf", "(Ljava/lang/String;I)I"), Values.ONE);
        methodsMap.put(new FQMethod("java/io/PrintStream", "print", "(Ljava/lang/String;)V"), Values.ZERO);
        methodsMap.put(new FQMethod("java/io/PrintStream", "println", "(Ljava/lang/String;)V"), Values.ZERO);
        methodsMap.put(new FQMethod("java/io/StringWriter", "write", "(Ljava/lang/String;)V"), Values.ZERO);
        methodsMap.put(new FQMethod("java/lang/StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;"), Values.ZERO);
        methodsMap.put(new FQMethod("java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;"), Values.ZERO);
        methodsMap.put(new FQMethod("java/lang/String", "replace", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;"), new IntPair(0, 1));
        characterMethods = Collections.unmodifiableMap(methodsMap);
    }

    private static class IntPair {
        final int firstStringParam;
        final int secondStringParam;

        IntPair(int firstStringParam, int secondStringParam) {
            this.firstStringParam = firstStringParam;
            this.secondStringParam = secondStringParam;
        }

        public String toString() {
            return ToString.build(this);
        }
    }

    static enum UCPMUserValue {
        INLINE;

    }
}

