/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

@OpcodeStack.CustomUserValue
public class UseEnumCollections
extends BytecodeScanningDetector {
    private static final Set<String> nonEnumCollections = UnmodifiableSet.create("Ljava/util/HashSet;", "Ljava/util/HashMap;", "Ljava/util/TreeMap;", "Ljava/util/ConcurrentHashMap;", "Ljava/util/IdentityHashMap;", "Ljava/util/WeakHashMap;");
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Set<String> checkedFields;
    private Map<Integer, Boolean> enumRegs;
    private Map<String, Boolean> enumFields;
    private boolean methodReported;

    public UseEnumCollections(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            if (cls.getMajor() >= 49) {
                this.stack = new OpcodeStack();
                this.checkedFields = new HashSet<String>();
                this.enumRegs = new HashMap<Integer, Boolean>();
                this.enumFields = new HashMap<String, Boolean>();
                super.visitClassContext(classContext);
            }
        }
        finally {
            this.stack = null;
            this.checkedFields = null;
            this.enumRegs = null;
            this.enumFields = null;
        }
    }

    public void visitMethod(Method obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.methodReported = false;
        this.enumRegs.clear();
        super.visitMethod(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        Boolean sawEnumCollectionCreation = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            if (this.methodReported) {
                return;
            }
            if (seen == 184) {
                String clsName = this.getClassConstantOperand();
                String signature = this.getSigConstantOperand();
                if ("java/util/EnumSet".equals(clsName) && signature.endsWith(")Ljava/util/EnumSet;")) {
                    sawEnumCollectionCreation = Boolean.TRUE;
                }
            } else if (seen == 183) {
                String clsName = this.getClassConstantOperand();
                String methodName = this.getNameConstantOperand();
                if ("java/util/EnumMap".equals(clsName) && "<init>".equals(methodName)) {
                    sawEnumCollectionCreation = Boolean.TRUE;
                } else if (clsName.startsWith("java/util/") && (clsName.endsWith("Map") || clsName.endsWith("Set"))) {
                    sawEnumCollectionCreation = Boolean.FALSE;
                }
            } else if (seen == 58 || seen >= 75 && seen <= 78) {
                if (this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    Integer reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    if (itm.getUserValue() != null) {
                        this.enumRegs.put(reg, (Boolean)itm.getUserValue());
                    } else {
                        this.enumRegs.remove(reg);
                    }
                }
            } else if (seen == 25 || seen >= 42 && seen <= 45) {
                Integer reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                sawEnumCollectionCreation = this.enumRegs.get(reg);
            } else if (seen == 181) {
                if (this.stack.getStackDepth() > 0) {
                    String fieldName = this.getNameConstantOperand();
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    if (itm.getUserValue() != null) {
                        this.enumFields.put(fieldName, (Boolean)itm.getUserValue());
                    } else {
                        this.enumFields.remove(fieldName);
                    }
                }
            } else if (seen == 180) {
                String fieldName = this.getNameConstantOperand();
                sawEnumCollectionCreation = this.enumFields.get(fieldName);
            } else if (seen == 185) {
                boolean bug = false;
                String clsName = this.getClassConstantOperand();
                String methodName = this.getNameConstantOperand();
                String signature = this.getSigConstantOperand();
                if ("java/util/Map".equals(clsName) && "put".equals(methodName) && "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;".equals(signature)) {
                    bug = this.isEnum(1) && !this.isEnumCollection(2) && !this.alreadyReported(2);
                } else if ("java/util/Set".equals(clsName) && "add".equals(methodName) && "(Ljava/lang/Object;)Z".equals(signature)) {
                    boolean bl = bug = this.isEnum(0) && !this.isEnumCollection(1) && !this.alreadyReported(1);
                }
                if (bug) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UEC_USE_ENUM_COLLECTIONS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    this.methodReported = true;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (sawEnumCollectionCreation != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                itm.setUserValue((Object)sawEnumCollectionCreation);
            }
        }
    }

    private boolean isEnum(int stackPos) throws ClassNotFoundException {
        if (this.stack.getStackDepth() > stackPos) {
            OpcodeStack.Item item = this.stack.getStackItem(stackPos);
            if (item.getSignature().charAt(0) != 'L') {
                return false;
            }
            JavaClass cls = item.getJavaClass();
            if (cls == null || !cls.isEnum()) {
                return false;
            }
            if (cls.getInterfaces().length == 0) {
                return true;
            }
        }
        return false;
    }

    private boolean isEnumCollection(int stackPos) {
        if (this.stack.getStackDepth() <= stackPos) {
            return false;
        }
        OpcodeStack.Item item = this.stack.getStackItem(stackPos);
        Boolean userValue = (Boolean)item.getUserValue();
        if (userValue != null) {
            return userValue;
        }
        String realClass = item.getSignature();
        if ("Ljava/util/EnumSet;".equals(realClass) || "Ljava/util/EnumMap;".equals(realClass)) {
            return true;
        }
        return !nonEnumCollections.contains(realClass);
    }

    private boolean alreadyReported(int stackPos) {
        if (this.stack.getStackDepth() <= stackPos) {
            return false;
        }
        OpcodeStack.Item item = this.stack.getStackItem(stackPos);
        XField field = item.getXField();
        if (field == null) {
            return false;
        }
        String fieldName = field.getName();
        boolean checked = this.checkedFields.contains(fieldName);
        this.checkedFields.add(fieldName);
        return checked;
    }
}

