/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.Type;

public class UseVarArgs
extends PreorderVisitor
implements Detector {
    private final BugReporter bugReporter;
    private JavaClass javaClass;

    public UseVarArgs(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.javaClass = classContext.getJavaClass();
            if (this.javaClass.getMajor() >= 49) {
                this.javaClass.accept((Visitor)this);
            }
        }
        finally {
            this.javaClass = null;
        }
    }

    public void visitMethod(Method obj) {
        try {
            if (obj.isSynthetic()) {
                return;
            }
            Type[] types = obj.getArgumentTypes();
            if (types.length == 0 || types.length > 2) {
                return;
            }
            if ((obj.getAccessFlags() & 0x80) != 0) {
                return;
            }
            String lastParmSig = types[types.length - 1].getSignature();
            if (!lastParmSig.startsWith("[") || lastParmSig.startsWith("[[")) {
                return;
            }
            if ("[B".equals(lastParmSig) || "[C".equals(lastParmSig)) {
                return;
            }
            if (UseVarArgs.hasSimilarParms(types)) {
                return;
            }
            if (obj.isStatic() && "main".equals(obj.getName()) && "([Ljava/lang/String;)V".equals(obj.getSignature())) {
                return;
            }
            if (!obj.isPrivate() && !obj.isStatic() && this.isInherited(obj)) {
                return;
            }
            super.visitMethod(obj);
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UVA_USE_VAR_ARGS.name(), 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this));
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public void report() {
    }

    private static boolean hasSimilarParms(Type ... argTypes) {
        for (int i = 0; i < argTypes.length - 1; ++i) {
            if (!argTypes[i].getSignature().startsWith("[")) continue;
            return true;
        }
        String baseType = argTypes[argTypes.length - 1].getSignature();
        while (baseType.startsWith("[")) {
            baseType = baseType.substring(1);
        }
        for (int i = 0; i < argTypes.length - 1; ++i) {
            if (!argTypes[i].getSignature().equals(baseType)) continue;
            return true;
        }
        return false;
    }

    private boolean isInherited(Method m) throws ClassNotFoundException {
        JavaClass[] sups;
        JavaClass[] infs;
        for (JavaClass inf : infs = this.javaClass.getAllInterfaces()) {
            if (!UseVarArgs.hasMethod(inf, m)) continue;
            return true;
        }
        for (JavaClass sup : sups = this.javaClass.getSuperClasses()) {
            if (!UseVarArgs.hasMethod(sup, m)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMethod(JavaClass c, Method candidateMethod) {
        String name = candidateMethod.getName();
        String sig = candidateMethod.getSignature();
        for (Method method : c.getMethods()) {
            if (method.isStatic() || !method.getName().equals(name) || !method.getSignature().equals(sig)) continue;
            return true;
        }
        return false;
    }
}

