/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class WeakExceptionMessaging
extends BytecodeScanningDetector {
    private static JavaClass exceptionClass;
    private static final Set<String> ignorableExceptionTypes;
    private final BugReporter bugReporter;
    private OpcodeStack stack;

    public WeakExceptionMessaging(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            if (exceptionClass != null) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
            }
        }
        finally {
            this.stack = null;
        }
    }

    public boolean prescreen(Method method) {
        if ("<clinit>".equals(method.getName())) {
            return false;
        }
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(191);
    }

    public void visitCode(Code obj) {
        Method method = this.getMethod();
        if (!method.isSynthetic() && this.prescreen(method)) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        boolean allConstantStrings = false;
        boolean sawConstant = false;
        try {
            JavaClass exCls;
            String clsName;
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 191) {
                JavaClass exClass;
                OpcodeStack.Item item;
                if (!(this.stack.getStackDepth() <= 0 || (item = this.stack.getStackItem(0)).getUserValue() == null || (exClass = item.getJavaClass()) != null && ignorableExceptionTypes.contains(exClass.getClassName()))) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.WEM_WEAK_EXCEPTION_MESSAGING.name(), 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            } else if (seen == 18 || seen == 19) {
                if (this.getConstantRefOperand() instanceof ConstantString) {
                    sawConstant = true;
                }
            } else if (seen == 183 && "<init>".equals(this.getNameConstantOperand()) && (clsName = this.getClassConstantOperand()).indexOf("Exception") >= 0 && (exCls = Repository.lookupClass((String)clsName)).instanceOf(exceptionClass)) {
                String sig = this.getSigConstantOperand();
                Type[] argTypes = Type.getArgumentTypes((String)sig);
                int stringParms = 0;
                for (int t = 0; t < argTypes.length; ++t) {
                    OpcodeStack.Item item;
                    if (!"Ljava/lang/String;".equals(argTypes[t].getSignature())) continue;
                    ++stringParms;
                    int stackOffset = argTypes.length - t - 1;
                    if (this.stack.getStackDepth() <= stackOffset || (item = this.stack.getStackItem(stackOffset)).getUserValue() != null) continue;
                    return;
                }
                if ("java/lang/Exception".equals(clsName) && "(Ljava/lang/Throwable;)V".equals(this.getSigConstantOperand())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.WEM_OBSCURING_EXCEPTION.name(), 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                allConstantStrings = stringParms > 0;
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if ((sawConstant || allConstantStrings) && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)Boolean.TRUE);
            }
        }
    }

    static {
        ignorableExceptionTypes = UnmodifiableSet.create("java.lang.UnsupportedOperationException");
        try {
            exceptionClass = Repository.lookupClass((String)"java/lang/Exception");
        }
        catch (ClassNotFoundException cnfe) {
            exceptionClass = null;
        }
    }
}

