/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.utils;

import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;

public class XClassUtils {
    public XClass getXClass(ClassDescriptor classDesc) throws AssertionError {
        try {
            return (XClass)Global.getAnalysisCache().getClassAnalysis(XClass.class, classDesc);
        }
        catch (CheckedAnalysisException e) {
            AssertionError ae = new AssertionError((Object)("Can't find ClassInfo for " + classDesc));
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
    }

    public XClass getXClass(String slashedClassName) {
        return this.getXClass(DescriptorFactory.createClassDescriptor((String)slashedClassName));
    }

    public XMethod getXMethod(XClass xClass, String methodName, String methodSig) {
        ClassDescriptor descriptor;
        if (xClass == null) {
            return null;
        }
        XMethod xMethod = xClass.findMethod(methodName, methodSig, false);
        if (xMethod == null && (descriptor = xClass.getSuperclassDescriptor()) != null) {
            XClass superClass = this.getXClass(descriptor);
            xMethod = this.getXMethod(superClass, methodName, methodSig);
        }
        return xMethod;
    }

    public XMethod getXMethod(String slashedClassName, String methodName, String methodSig) {
        XClass xClass = this.getXClass(slashedClassName);
        return this.getXMethod(xClass, methodName, methodSig);
    }
}

