/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.alm.octane.infra;

import com.hpe.alm.octane.infra.GherkinSerializer;
import com.hpe.alm.octane.infra.ScenarioElement;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FeatureElement
implements GherkinSerializer {
    private String name = "";
    private String tag = "";
    private String path = "";
    private String fileContent = "";
    private Long started;
    private List<ScenarioElement> scenarios = new ArrayList<ScenarioElement>();

    public List<ScenarioElement> getScenarios() {
        return this.scenarios;
    }

    public void addScenario(ScenarioElement scenario) {
        this.scenarios.add(scenario);
    }

    public String getPath() {
        return this.path;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setFileContent(String _fileContent) {
        this.fileContent = _fileContent;
    }

    public void setStarted(Long started) {
        this.started = started;
    }

    @Override
    public Element toXMLElement(Document doc) {
        Element feature = doc.createElement("feature");
        feature.setAttribute("name", this.name);
        feature.setAttribute("path", this.sanitizePath(this.path));
        feature.setAttribute("tag", this.tag);
        if (this.started != null) {
            feature.setAttribute("started", this.started.toString());
        }
        Element fileElement = doc.createElement("file");
        fileElement.appendChild(doc.createCDATASection(this.fileContent));
        feature.appendChild(fileElement);
        Element scenariosElement = doc.createElement("scenarios");
        for (ScenarioElement scenario : this.scenarios) {
            scenariosElement.appendChild(scenario.toXMLElement(doc));
        }
        feature.appendChild(scenariosElement);
        return feature;
    }
}

