/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.alm.octane.infra;

import com.hpe.alm.octane.infra.ErrorHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

class ResultFileOutputStream
extends OutputStream {
    private FileOutputStream fileOutputStream;

    public ResultFileOutputStream(URL url) throws FileNotFoundException {
        File file = new File(url.getFile());
        ResultFileOutputStream.ensureParentDirExists(file);
        this.fileOutputStream = new FileOutputStream(file);
    }

    @Override
    public void write(int b) throws IOException {
        this.fileOutputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.fileOutputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.fileOutputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.fileOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.fileOutputStream.close();
    }

    private static void ensureParentDirExists(File file) {
        if (file.getParentFile() != null && !file.getParentFile().isDirectory()) {
            boolean success;
            boolean bl = success = file.getParentFile().mkdirs() || file.getParentFile().isDirectory();
            if (!success) {
                ErrorHandler.error("Failed to create directory " + file.getParentFile().getPath());
            }
        }
    }
}

