/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.alm.octane.infra;

import com.hpe.alm.octane.infra.GherkinSerializer;
import com.hpe.alm.octane.infra.StepElement;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ScenarioElement
implements GherkinSerializer {
    private String name;
    private List<StepElement> steps = new ArrayList<StepElement>();
    private Integer outlineIndex = 0;

    public ScenarioElement(String name, int outlineIndex) {
        this.name = name;
        this.outlineIndex = outlineIndex;
    }

    public void setOutlineIndex(int outlineIndex) {
        this.outlineIndex = outlineIndex;
    }

    public List<StepElement> getSteps() {
        return this.steps;
    }

    public void addStep(StepElement step) {
        this.steps.add(step);
    }

    public int getOutlineIndex() {
        return this.outlineIndex;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Element toXMLElement(Document doc) {
        Element scenario = doc.createElement("scenario");
        scenario.setAttribute("name", this.name);
        if (this.outlineIndex > 0) {
            scenario.setAttribute("outlineIndex", this.outlineIndex.toString());
        }
        Element steps = doc.createElement("steps");
        for (StepElement step : this.steps) {
            steps.appendChild(step.toXMLElement(doc));
        }
        scenario.appendChild(steps);
        return scenario;
    }
}

