/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.alm.octane.infra;

import com.hpe.alm.octane.infra.GherkinSerializer;
import cucumber.api.Result;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StepElement
implements GherkinSerializer {
    private String name;
    private String status = Result.Type.SKIPPED.lowerCaseName();
    private Long duration = 0L;
    private String errorMessage = "";

    public StepElement(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setStatus(String status) {
        this.status = status.toLowerCase();
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Element toXMLElement(Document doc) {
        Element step = doc.createElement("step");
        step.setAttribute("name", this.name);
        step.setAttribute("status", this.status);
        String duration = this.duration != null ? this.duration.toString() : "0";
        step.setAttribute("duration", duration);
        if (this.errorMessage != null && !this.errorMessage.isEmpty()) {
            Element errorElement = doc.createElement("error_message");
            errorElement.appendChild(doc.createCDATASection(this.errorMessage));
            step.appendChild(errorElement);
        }
        return step;
    }
}

