/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aisdk.MicrometerUtil;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class BytecodeUtil {
    private static BytecodeUtilDelegate delegate;

    public static void setDelegate(final BytecodeUtilDelegate delegate) {
        if (BytecodeUtil.delegate == null) {
            BytecodeUtil.delegate = delegate;
            MicrometerUtil.setDelegate(new MicrometerUtil.MicrometerUtilDelegate(){

                @Override
                public void trackMetric(String name, double value, Integer count, Double min, Double max, Map<String, String> properties) {
                    delegate.trackMetric(name, value, count, min, max, null, properties);
                }
            });
        }
    }

    public static void trackEvent(String name, Map<String, String> properties, Map<String, Double> metrics) {
        if (delegate != null) {
            delegate.trackEvent(name, properties, metrics);
        }
    }

    public static void trackMetric(String name, double value, Integer count, Double min, Double max, Double stdDev, Map<String, String> properties) {
        if (delegate != null) {
            delegate.trackMetric(name, value, count, min, max, stdDev, properties);
        }
    }

    public static void trackDependency(String name, String id, String resultCode, Long totalMillis, boolean success, String commandName, String type, String target, Map<String, String> properties, Map<String, Double> metrics) {
        if (delegate != null) {
            delegate.trackDependency(name, id, resultCode, totalMillis, success, commandName, type, target, properties, metrics);
        }
    }

    public static void trackPageView(String name, URI uri, long totalMillis, Map<String, String> properties, Map<String, Double> metrics) {
        if (delegate != null) {
            delegate.trackPageView(name, uri, totalMillis, properties, metrics);
        }
    }

    public static void trackTrace(String message, int severityLevel, Map<String, String> properties) {
        if (delegate != null) {
            delegate.trackTrace(message, severityLevel, properties);
        }
    }

    public static void trackRequest(String id, String name, URL url, Date timestamp, long duration, String responseCode, boolean success) {
        if (delegate != null) {
            delegate.trackRequest(id, name, url, timestamp, duration, responseCode, success);
        }
    }

    public static void trackException(Exception exception, Map<String, String> properties, Map<String, Double> metrics) {
        if (delegate != null) {
            delegate.trackException(exception, properties, metrics);
        }
    }

    public static void logErrorOnce(Throwable t) {
        if (delegate != null) {
            delegate.logErrorOnce(t);
        }
    }

    public static long getTotalMilliseconds(long days, int hours, int minutes, int seconds, int milliseconds) {
        return TimeUnit.DAYS.toMillis(days) + TimeUnit.HOURS.toMillis(hours) + TimeUnit.MINUTES.toMillis(minutes) + TimeUnit.SECONDS.toMillis(seconds) + (long)milliseconds;
    }

    public static interface BytecodeUtilDelegate {
        public void trackEvent(String var1, Map<String, String> var2, Map<String, Double> var3);

        public void trackMetric(String var1, double var2, Integer var4, Double var5, Double var6, Double var7, Map<String, String> var8);

        public void trackDependency(String var1, String var2, String var3, Long var4, boolean var5, String var6, String var7, String var8, Map<String, String> var9, Map<String, Double> var10);

        public void trackPageView(String var1, URI var2, long var3, Map<String, String> var5, Map<String, Double> var6);

        public void trackTrace(String var1, int var2, Map<String, String> var3);

        public void trackRequest(String var1, String var2, URL var3, Date var4, long var5, String var7, boolean var8);

        public void trackException(Exception var1, Map<String, String> var2, Map<String, Double> var3);

        public void logErrorOnce(Throwable var1);
    }
}

