/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap.configuration;

import com.microsoft.applicationinsights.agent.bootstrap.configuration.ConfigurationBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Configuration {
    public String connectionString;
    public Role role = new Role();
    public Map<String, String> customDimensions = new HashMap<String, String>();
    public Sampling sampling = new Sampling();
    public List<JmxMetric> jmxMetrics = new ArrayList<JmxMetric>();
    public Map<String, Map<String, Object>> instrumentation = new HashMap<String, Map<String, Object>>();
    public Heartbeat heartbeat = new Heartbeat();
    public Proxy proxy = new Proxy();
    public SelfDiagnostics selfDiagnostics = new SelfDiagnostics();
    public PreviewConfiguration preview = new PreviewConfiguration();
    public Map<String, Object> instrumentationSettings;
    public transient Path configPath;
    public transient long lastModifiedTime;

    public static class ProcessorAction {
        public String key;
        public ProcessorActionType action;
        public String value;
        public String fromAttribute;

        public void validate() {
            if (this.key == null || this.key.isEmpty()) {
                throw new ConfigurationBuilder.ConfigurationException("User provided config has invalid action with empty key!!!");
            }
            if (this.action == null) {
                throw new ConfigurationBuilder.ConfigurationException("User provided config has invalid action with empty action!!!");
            }
            if ((this.action == ProcessorActionType.insert || this.action == ProcessorActionType.update) && this.value == null && this.fromAttribute == null) {
                throw new ConfigurationBuilder.ConfigurationException("User provided config has invalid action with empty value or empty fromAttribute!!!");
            }
        }
    }

    public static class ProcessorAttribute {
        public String key;
        public String value;
    }

    public static class ProcessorIncludeExclude {
        public ProcessorMatchType matchType;
        public List<String> spanNames;
        public List<String> logNames;
        public List<ProcessorAttribute> attributes;

        public void validate(ProcessorType processorType) {
            if (this.matchType == null) {
                throw new ConfigurationBuilder.ConfigurationException("User provided config has invalid include/exclude value with no matchType!!!");
            }
            if (this.attributes != null) {
                for (ProcessorAttribute attribute : this.attributes) {
                    if (attribute.key == null || attribute.key.isEmpty()) {
                        throw new ConfigurationBuilder.ConfigurationException("User provided config has invalid include/exclude value with attribute which has empty key!!!");
                    }
                    if (this.matchType != ProcessorMatchType.regexp || attribute.value == null) continue;
                    ProcessorConfig.isValidRegex(attribute.value);
                }
            }
            switch (processorType) {
                case attribute: {
                    this.validAttributeProcessorIncludeExclude();
                    break;
                }
                case log: {
                    this.validateLogProcessorIncludeExclude();
                    break;
                }
                case span: {
                    this.validateSpanProcessorIncludeExclude();
                }
            }
        }

        private void validAttributeProcessorIncludeExclude() {
            if (this.spanNames == null && this.attributes == null) {
                throw new ConfigurationBuilder.ConfigurationException("User provided config has invalid include/exclude value with no spanNames or no attributes!!!");
            }
            if (this.spanNames != null && this.matchType == ProcessorMatchType.regexp) {
                for (String spanName : this.spanNames) {
                    ProcessorConfig.isValidRegex(spanName);
                }
            }
        }

        private void validateLogProcessorIncludeExclude() {
            if (this.logNames == null && this.attributes == null) {
                throw new ConfigurationBuilder.ConfigurationException("User provided config has invalid include/exclude value with no logNames or no attributes!!!");
            }
            if (this.logNames != null && this.matchType == ProcessorMatchType.regexp) {
                for (String logName : this.logNames) {
                    ProcessorConfig.isValidRegex(logName);
                }
            }
        }

        private void validateSpanProcessorIncludeExclude() {
            if (this.spanNames == null && this.attributes == null) {
                throw new ConfigurationBuilder.ConfigurationException("User provided config has invalid include/exclude value with no spanNames or no attributes!!!");
            }
            if (this.spanNames != null && this.matchType == ProcessorMatchType.regexp) {
                for (String spanName : this.spanNames) {
                    ProcessorConfig.isValidRegex(spanName);
                }
            }
        }
    }

    public static class ToAttributeConfig {
        public List<String> rules;

        public void validate() {
            if (this.rules == null || this.rules.isEmpty()) {
                throw new ConfigurationBuilder.ConfigurationException("User provided config has invalid toAttribute value with no rules!!!");
            }
            for (String rule : this.rules) {
                ProcessorConfig.isValidRegex(rule);
            }
        }
    }

    public static class NameConfig {
        public List<String> fromAttributes;
        public ToAttributeConfig toAttributes;
        public String separator;

        public void validate() {
            if (this.fromAttributes == null && this.toAttributes == null) {
                throw new ConfigurationBuilder.ConfigurationException("User provided config has invalid name object with no fromAttributes or no toAttributes!!!");
            }
            if (this.toAttributes != null) {
                this.toAttributes.validate();
            }
        }
    }

    public static class ProcessorConfig {
        public ProcessorType type;
        public String processorName;
        public ProcessorIncludeExclude include;
        public ProcessorIncludeExclude exclude;
        public List<ProcessorAction> actions;
        public NameConfig name;

        private static void isValidRegex(String value) {
            try {
                Pattern.compile(value);
            }
            catch (PatternSyntaxException exception) {
                throw new ConfigurationBuilder.ConfigurationException("User provided processor config do not have valid regex:" + value);
            }
        }

        public void validate() {
            if (this.type == null) {
                throw new ConfigurationBuilder.ConfigurationException("User provided config has a processor with no type!!!");
            }
            if (this.include != null) {
                this.include.validate(this.type);
            }
            if (this.exclude != null) {
                this.exclude.validate(this.type);
            }
            this.validateAttributeProcessorConfig();
            this.validateLogOrSpanProcessorConfig();
        }

        public void validateAttributeProcessorConfig() {
            if (this.type == ProcessorType.attribute) {
                if (this.actions == null || this.actions.isEmpty()) {
                    throw new ConfigurationBuilder.ConfigurationException("User provided config has invalid attribute processor configuration with empty actions!!!");
                }
                for (ProcessorAction action : this.actions) {
                    action.validate();
                }
            }
        }

        public void validateLogOrSpanProcessorConfig() {
            if (this.type == ProcessorType.log || this.type == ProcessorType.span) {
                if (this.name == null) {
                    throw new ConfigurationBuilder.ConfigurationException("User provided config has invalid span/log processor configuration with empty name object!!!");
                }
                this.name.validate();
            }
        }
    }

    public static class DestinationFile {
        public String path = "applicationinsights.log";
        public int maxSizeMb = 5;
        public int maxHistory = 1;
    }

    public static class SelfDiagnostics {
        public String level = "info";
        public String destination = "file+console";
        public DestinationFile file = new DestinationFile();
    }

    public static class PreviewConfiguration {
        public boolean developerMode;
        public List<ProcessorConfig> processors = new ArrayList<ProcessorConfig>();
        public boolean openTelemetryApiSupport;
    }

    public static class Proxy {
        public String host;
        public int port = 80;
    }

    public static class Heartbeat {
        public long intervalSeconds = TimeUnit.MINUTES.toSeconds(15L);
    }

    public static class JmxMetric {
        public String name;
        public String objectName;
        public String attribute;
    }

    public static class Sampling {
        public double percentage = 100.0;
    }

    public static class Role {
        public String name;
        public String instance;
    }

    public static enum ProcessorType {
        attribute,
        log,
        span;

    }

    public static enum ProcessorActionType {
        insert,
        update,
        delete,
        hash;

    }

    public static enum ProcessorMatchType {
        strict,
        regexp;

    }
}

