/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap.configuration;

import com.microsoft.applicationinsights.agent.bootstrap.configuration.Configuration;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.DiagnosticsHelper;
import com.microsoft.applicationinsights.agent.shadow.com.squareup.moshi.JsonAdapter;
import com.microsoft.applicationinsights.agent.shadow.com.squareup.moshi.JsonReader;
import com.microsoft.applicationinsights.agent.shadow.com.squareup.moshi.Moshi;
import com.microsoft.applicationinsights.agent.shadow.com.squareup.moshi.Types;
import com.microsoft.applicationinsights.agent.shadow.okio.Buffer;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConfigurationBuilder {
    private static final String APPLICATIONINSIGHTS_CONFIGURATION_FILE = "APPLICATIONINSIGHTS_CONFIGURATION_FILE";
    private static final String APPLICATIONINSIGHTS_ROLE_NAME = "APPLICATIONINSIGHTS_ROLE_NAME";
    private static final String APPLICATIONINSIGHTS_ROLE_INSTANCE = "APPLICATIONINSIGHTS_ROLE_INSTANCE";
    private static final String APPLICATIONINSIGHTS_JMX_METRICS = "APPLICATIONINSIGHTS_JMX_METRICS";
    private static final String APPLICATIONINSIGHTS_SAMPLING_PERCENTAGE = "APPLICATIONINSIGHTS_SAMPLING_PERCENTAGE";
    private static final String APPLICATIONINSIGHTS_INSTRUMENTATION_LOGGING_LEVEL = "APPLICATIONINSIGHTS_INSTRUMENTATION_LOGGING_LEVEL";
    private static final String WEBSITE_SITE_NAME = "WEBSITE_SITE_NAME";
    private static final String WEBSITE_INSTANCE_ID = "WEBSITE_INSTANCE_ID";
    private static final List<ConfigurationMessage> configurationMessages = new CopyOnWriteArrayList<ConfigurationMessage>();

    public static Configuration create(Path agentJarPath) throws IOException {
        Configuration config = ConfigurationBuilder.loadConfigurationFile(agentJarPath);
        ConfigurationBuilder.overlayEnvVars(config);
        return config;
    }

    private static void loadLogCaptureEnvVar(Configuration config) {
        String loggingEnvVar;
        Map<String, Object> logging = config.instrumentation.get("logging");
        if (logging == null) {
            logging = new HashMap<String, Object>();
            config.instrumentation.put("logging", logging);
        }
        if ((loggingEnvVar = ConfigurationBuilder.overlayWithEnvVar(APPLICATIONINSIGHTS_INSTRUMENTATION_LOGGING_LEVEL, (String)null)) != null) {
            logging.put("level", loggingEnvVar);
        }
    }

    private static void loadJmxMetrics(Configuration config) throws IOException {
        String jmxMetricsEnvVarJson = ConfigurationBuilder.overlayWithEnvVar(APPLICATIONINSIGHTS_JMX_METRICS, (String)null);
        if (jmxMetricsEnvVarJson != null && !jmxMetricsEnvVarJson.isEmpty()) {
            Moshi moshi = new Moshi.Builder().build();
            ParameterizedType listOfJmxMetrics = Types.newParameterizedType(List.class, new Type[]{Configuration.JmxMetric.class});
            JsonReader reader = JsonReader.of(new Buffer().writeUtf8(jmxMetricsEnvVarJson));
            reader.setLenient(true);
            JsonAdapter jsonAdapter = moshi.adapter(listOfJmxMetrics);
            config.jmxMetrics = (List)jsonAdapter.fromJson(reader);
        }
        if (!ConfigurationBuilder.jmxMetricExisted(config.jmxMetrics, "java.lang:type=Threading", "ThreadCount")) {
            Configuration.JmxMetric threadCountJmxMetric = new Configuration.JmxMetric();
            threadCountJmxMetric.name = "Current Thread Count";
            threadCountJmxMetric.objectName = "java.lang:type=Threading";
            threadCountJmxMetric.attribute = "ThreadCount";
            config.jmxMetrics.add(threadCountJmxMetric);
        }
        if (!ConfigurationBuilder.jmxMetricExisted(config.jmxMetrics, "java.lang:type=ClassLoading", "LoadedClassCount")) {
            Configuration.JmxMetric classCountJmxMetric = new Configuration.JmxMetric();
            classCountJmxMetric.name = "Loaded Class Count";
            classCountJmxMetric.objectName = "java.lang:type=ClassLoading";
            classCountJmxMetric.attribute = "LoadedClassCount";
            config.jmxMetrics.add(classCountJmxMetric);
        }
    }

    private static boolean jmxMetricExisted(List<Configuration.JmxMetric> jmxMetrics, String objectName, String attribute) {
        for (Configuration.JmxMetric metric : jmxMetrics) {
            if (!metric.objectName.equals(objectName) || !metric.attribute.equals(attribute)) continue;
            return true;
        }
        return false;
    }

    private static Configuration loadConfigurationFile(Path agentJarPath) throws IOException {
        if (DiagnosticsHelper.isAnyCodelessAttach()) {
            return new Configuration();
        }
        String configPathStr = ConfigurationBuilder.getEnvVarOrProperty(APPLICATIONINSIGHTS_CONFIGURATION_FILE, "applicationinsights.configuration.file");
        if (configPathStr != null) {
            Path configPath = agentJarPath.resolveSibling(configPathStr);
            if (Files.exists(configPath, new LinkOption[0])) {
                return ConfigurationBuilder.loadJsonConfigFile(configPath);
            }
            throw new IllegalStateException("could not find requested configuration file: " + configPathStr);
        }
        Path configPath = agentJarPath.resolveSibling("applicationinsights.json");
        if (Files.exists(configPath, new LinkOption[0])) {
            return ConfigurationBuilder.loadJsonConfigFile(configPath);
        }
        if (Files.exists(agentJarPath.resolveSibling("ApplicationInsights.json"), new LinkOption[0])) {
            throw new IllegalStateException("found ApplicationInsights.json, but it should be lowercase: applicationinsights.json");
        }
        return new Configuration();
    }

    public static void logConfigurationMessages() {
        Logger logger = LoggerFactory.getLogger(ConfigurationBuilder.class);
        for (ConfigurationMessage configurationMessage : configurationMessages) {
            configurationMessage.log(logger);
        }
    }

    private static String getEnvVar(String name) {
        return ConfigurationBuilder.trimAndEmptyToNull(System.getenv(name));
    }

    private static String getEnvVarOrProperty(String envVarName, String propertyName) {
        String value = ConfigurationBuilder.trimAndEmptyToNull(System.getenv(envVarName));
        return value != null ? value : ConfigurationBuilder.trimAndEmptyToNull(System.getProperty(propertyName));
    }

    static void overlayEnvVars(Configuration config) throws IOException {
        config.role.name = ConfigurationBuilder.overlayWithEnvVars(APPLICATIONINSIGHTS_ROLE_NAME, WEBSITE_SITE_NAME, config.role.name);
        config.role.instance = ConfigurationBuilder.overlayWithEnvVars(APPLICATIONINSIGHTS_ROLE_INSTANCE, WEBSITE_INSTANCE_ID, config.role.instance);
        config.sampling.percentage = ConfigurationBuilder.overlayWithEnvVar(APPLICATIONINSIGHTS_SAMPLING_PERCENTAGE, config.sampling.percentage);
        ConfigurationBuilder.loadLogCaptureEnvVar(config);
        ConfigurationBuilder.loadJmxMetrics(config);
    }

    static String overlayWithEnvVars(String name1, String name2, String defaultValue) {
        String value = ConfigurationBuilder.getEnv(name1);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        value = ConfigurationBuilder.getEnv(name2);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return defaultValue;
    }

    static String overlayWithEnvVar(String name, String defaultValue) {
        String value = ConfigurationBuilder.getEnv(name);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return defaultValue;
    }

    static Double overlayWithEnvVar(String name, Double defaultValue) {
        String value = ConfigurationBuilder.getEnv(name);
        if (value != null && !value.isEmpty()) {
            return Double.parseDouble(value);
        }
        return defaultValue;
    }

    private static String getEnv(String name) {
        String value = System.getenv(name);
        if (name.equals(WEBSITE_SITE_NAME) && "java".equals(System.getenv("FUNCTIONS_WORKER_RUNTIME"))) {
            value = value.toLowerCase(Locale.ENGLISH);
        }
        return value;
    }

    static Map<String, String> overlayWithEnvVars(String name, Map<String, String> defaultValue) {
        String value = System.getenv(name);
        if (value != null && !value.isEmpty()) {
            Map objectMap;
            Moshi moshi = new Moshi.Builder().build();
            JsonAdapter<Map> adapter = moshi.adapter(Map.class);
            HashMap<String, String> stringMap = new HashMap<String, String>();
            try {
                objectMap = adapter.fromJson(value);
            }
            catch (Exception e) {
                configurationMessages.add(new ConfigurationMessage("could not parse environment variable {} as json: {}", name, value));
                return defaultValue;
            }
            for (Map.Entry entry : objectMap.entrySet()) {
                Object val = entry.getValue();
                if (!(val instanceof String)) {
                    configurationMessages.add(new ConfigurationMessage("currently only string values are supported in json map from {}: {}", name, value));
                    return defaultValue;
                }
                stringMap.put((String)entry.getKey(), (String)val);
            }
            return stringMap;
        }
        return defaultValue;
    }

    static String trimAndEmptyToNull(String str) {
        if (str == null) {
            return null;
        }
        String trimmed = str.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    public static Configuration loadJsonConfigFile(Path configPath) throws IOException {
        if (!Files.exists(configPath, new LinkOption[0])) {
            throw new IllegalStateException("config file does not exist: " + configPath);
        }
        BasicFileAttributes attributes = Files.readAttributes(configPath, BasicFileAttributes.class, new LinkOption[0]);
        long lastModifiedTime = attributes.lastModifiedTime().toMillis();
        Throwable throwable = null;
        try (InputStream in = Files.newInputStream(configPath, new OpenOption[0]);){
            Moshi moshi = new Moshi.Builder().build();
            JsonAdapter<Configuration> jsonAdapter = moshi.adapter(Configuration.class);
            Buffer buffer = new Buffer();
            buffer.readFrom(in);
            try {
                Configuration configuration = jsonAdapter.fromJson(buffer);
                if (configuration.instrumentationSettings != null) {
                    throw new IllegalStateException("It looks like you are using an old applicationinsights.json file which still has \"instrumentationSettings\", please see the docs for the new format: https://docs.microsoft.com/en-us/azure/azure-monitor/app/java-standalone-config");
                }
                configuration.configPath = configPath;
                configuration.lastModifiedTime = lastModifiedTime;
                Configuration configuration2 = configuration;
                return configuration2;
            }
            catch (Exception e) {
                try {
                    throw new ConfigurationException("Error parsing configuration file: " + configPath.toAbsolutePath().toString(), e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    public static class ConfigurationMessage {
        private final String message;
        private final Object[] args;

        public ConfigurationMessage(String message, Object ... args) {
            this.message = message;
            this.args = args;
        }

        private void log(Logger logger) {
            logger.warn(this.message, this.args);
        }
    }

    public static class ConfigurationException
    extends RuntimeException {
        public ConfigurationException(String message) {
            super(message);
        }

        ConfigurationException(String message, Exception e) {
            super(message, e);
        }
    }
}

