/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap.diagnostics;

import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.ApplicationMetadataFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class DiagnosticsHelper {
    public static final String IPA_LOG_FILE_ENABLED_ENV_VAR = "APPLICATIONINSIGHTS_EXTENSION_LOG_FILE_ENABLED";
    public static final String INTERNAL_LOG_OUTPUT_DIR_ENV_VAR = "APPLICATIONINSIGHTS_DIAGNOSTICS_OUTPUT_DIRECTORY";
    public static final String IPA_ETW_PROVIDER_ENABLED_ENV_VAR = "APPLICATIONINSIGHTS_EXTENSION_ETW_PROVIDER_ENABLED";
    static volatile boolean appServiceCodeless;
    private static volatile boolean aksCodeless;
    private static volatile boolean functionsCodeless;
    private static final boolean isWindows;
    public static final String DIAGNOSTICS_LOGGER_NAME = "applicationinsights.extension.diagnostics";
    private static final ApplicationMetadataFactory METADATA_FACTORY;
    public static final String MDC_PROP_OPERATION = "microsoft.ai.operationName";

    private DiagnosticsHelper() {
    }

    public static void setAgentJarFile(Path agentPath) {
        if (Files.exists(agentPath.resolveSibling("appsvc.codeless"), new LinkOption[0])) {
            appServiceCodeless = true;
        } else if (Files.exists(agentPath.resolveSibling("aks.codeless"), new LinkOption[0])) {
            aksCodeless = true;
        } else if (Files.exists(agentPath.resolveSibling("functions.codeless"), new LinkOption[0])) {
            functionsCodeless = true;
        }
    }

    public static boolean isAppServiceCodeless() {
        return appServiceCodeless;
    }

    public static boolean isAksCodeless() {
        return aksCodeless;
    }

    public static boolean isFunctionsCodeless() {
        return functionsCodeless;
    }

    public static boolean isAnyCodelessAttach() {
        return appServiceCodeless || aksCodeless || functionsCodeless;
    }

    public static ApplicationMetadataFactory getMetadataFactory() {
        return METADATA_FACTORY;
    }

    public static String getCodelessResourceType() {
        if (appServiceCodeless) {
            return "appsvc";
        }
        if (aksCodeless) {
            return "aks";
        }
        if (functionsCodeless) {
            return "functions";
        }
        return null;
    }

    public static boolean isOsWindows() {
        return isWindows;
    }

    static {
        METADATA_FACTORY = new ApplicationMetadataFactory();
        String osName = System.getProperty("os.name");
        isWindows = osName != null && osName.startsWith("Windows");
    }
}

