/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.shadow.com.squareup.moshi;

import com.microsoft.applicationinsights.agent.shadow.com.squareup.moshi.JsonReader;
import com.microsoft.applicationinsights.agent.shadow.com.squareup.moshi.JsonWriter;
import com.microsoft.applicationinsights.agent.shadow.com.squareup.moshi.LinkedHashTreeMap;
import com.microsoft.applicationinsights.agent.shadow.okio.Buffer;
import com.microsoft.applicationinsights.agent.shadow.okio.BufferedSink;
import com.microsoft.applicationinsights.agent.shadow.okio.ForwardingSink;
import com.microsoft.applicationinsights.agent.shadow.okio.Okio;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class JsonValueWriter
extends JsonWriter {
    Object[] stack = new Object[32];
    @Nullable
    private String deferredName;

    JsonValueWriter() {
        this.pushScope(6);
    }

    public Object root() {
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.scopes[size - 1] != 7) {
            throw new IllegalStateException("Incomplete document");
        }
        return this.stack[0];
    }

    @Override
    public JsonWriter beginArray() throws IOException {
        if (this.promoteValueToName) {
            throw new IllegalStateException("Array cannot be used as a map key in JSON at path " + this.getPath());
        }
        if (this.stackSize == this.flattenStackSize && this.scopes[this.stackSize - 1] == 1) {
            this.flattenStackSize ^= 0xFFFFFFFF;
            return this;
        }
        this.checkStack();
        ArrayList list = new ArrayList();
        this.add(list);
        this.stack[this.stackSize] = list;
        this.pathIndices[this.stackSize] = 0;
        this.pushScope(1);
        return this;
    }

    @Override
    public JsonWriter endArray() throws IOException {
        if (this.peekScope() != 1) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.stackSize == ~this.flattenStackSize) {
            this.flattenStackSize ^= 0xFFFFFFFF;
            return this;
        }
        --this.stackSize;
        this.stack[this.stackSize] = null;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return this;
    }

    @Override
    public JsonWriter beginObject() throws IOException {
        if (this.promoteValueToName) {
            throw new IllegalStateException("Object cannot be used as a map key in JSON at path " + this.getPath());
        }
        if (this.stackSize == this.flattenStackSize && this.scopes[this.stackSize - 1] == 3) {
            this.flattenStackSize ^= 0xFFFFFFFF;
            return this;
        }
        this.checkStack();
        LinkedHashTreeMap map = new LinkedHashTreeMap();
        this.add(map);
        this.stack[this.stackSize] = map;
        this.pushScope(3);
        return this;
    }

    @Override
    public JsonWriter endObject() throws IOException {
        if (this.peekScope() != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException("Dangling name: " + this.deferredName);
        }
        if (this.stackSize == ~this.flattenStackSize) {
            this.flattenStackSize ^= 0xFFFFFFFF;
            return this;
        }
        this.promoteValueToName = false;
        --this.stackSize;
        this.stack[this.stackSize] = null;
        this.pathNames[this.stackSize] = null;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return this;
    }

    @Override
    public JsonWriter name(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        if (this.peekScope() != 3 || this.deferredName != null) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.deferredName = name;
        this.pathNames[this.stackSize - 1] = name;
        this.promoteValueToName = false;
        return this;
    }

    @Override
    public JsonWriter value(@Nullable String value) throws IOException {
        if (this.promoteValueToName) {
            return this.name(value);
        }
        this.add(value);
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return this;
    }

    @Override
    public JsonWriter nullValue() throws IOException {
        if (this.promoteValueToName) {
            throw new IllegalStateException("null cannot be used as a map key in JSON at path " + this.getPath());
        }
        this.add(null);
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return this;
    }

    @Override
    public JsonWriter value(boolean value) throws IOException {
        if (this.promoteValueToName) {
            throw new IllegalStateException("Boolean cannot be used as a map key in JSON at path " + this.getPath());
        }
        this.add(value);
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return this;
    }

    @Override
    public JsonWriter value(@Nullable Boolean value) throws IOException {
        if (this.promoteValueToName) {
            throw new IllegalStateException("Boolean cannot be used as a map key in JSON at path " + this.getPath());
        }
        this.add(value);
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return this;
    }

    @Override
    public JsonWriter value(double value) throws IOException {
        if (!this.lenient && (Double.isNaN(value) || value == Double.NEGATIVE_INFINITY || value == Double.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        if (this.promoteValueToName) {
            return this.name(Double.toString(value));
        }
        this.add(value);
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return this;
    }

    @Override
    public JsonWriter value(long value) throws IOException {
        if (this.promoteValueToName) {
            return this.name(Long.toString(value));
        }
        this.add(value);
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return this;
    }

    @Override
    public JsonWriter value(@Nullable Number value) throws IOException {
        BigDecimal bigDecimalValue;
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return this.value(value.longValue());
        }
        if (value instanceof Float || value instanceof Double) {
            return this.value(value.doubleValue());
        }
        if (value == null) {
            return this.nullValue();
        }
        BigDecimal bigDecimal = bigDecimalValue = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
        if (this.promoteValueToName) {
            return this.name(bigDecimalValue.toString());
        }
        this.add(bigDecimalValue);
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return this;
    }

    @Override
    public BufferedSink valueSink() {
        if (this.promoteValueToName) {
            throw new IllegalStateException("BufferedSink cannot be used as a map key in JSON at path " + this.getPath());
        }
        if (this.peekScope() == 9) {
            throw new IllegalStateException("Sink from valueSink() was not closed");
        }
        this.pushScope(9);
        final Buffer buffer = new Buffer();
        return Okio.buffer(new ForwardingSink(buffer){

            @Override
            public void close() throws IOException {
                if (JsonValueWriter.this.peekScope() != 9 || JsonValueWriter.this.stack[JsonValueWriter.this.stackSize] != null) {
                    throw new AssertionError();
                }
                --JsonValueWriter.this.stackSize;
                Object value = JsonReader.of(buffer).readJsonValue();
                boolean serializeNulls = JsonValueWriter.this.serializeNulls;
                JsonValueWriter.this.serializeNulls = true;
                try {
                    JsonValueWriter.this.add(value);
                }
                finally {
                    JsonValueWriter.this.serializeNulls = serializeNulls;
                }
                int n = JsonValueWriter.this.stackSize - 1;
                JsonValueWriter.this.pathIndices[n] = JsonValueWriter.this.pathIndices[n] + 1;
            }
        });
    }

    @Override
    public void close() throws IOException {
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.scopes[size - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.stackSize = 0;
    }

    @Override
    public void flush() throws IOException {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
    }

    private JsonValueWriter add(@Nullable Object newTop) {
        int scope = this.peekScope();
        if (this.stackSize == 1) {
            if (scope != 6) {
                throw new IllegalStateException("JSON must have only one top-level value.");
            }
            this.scopes[this.stackSize - 1] = 7;
            this.stack[this.stackSize - 1] = newTop;
        } else if (scope == 3 && this.deferredName != null) {
            Map map;
            Object replaced;
            if ((newTop != null || this.serializeNulls) && (replaced = (map = (Map)this.stack[this.stackSize - 1]).put(this.deferredName, newTop)) != null) {
                throw new IllegalArgumentException("Map key '" + this.deferredName + "' has multiple values at path " + this.getPath() + ": " + replaced + " and " + newTop);
            }
            this.deferredName = null;
        } else if (scope == 1) {
            List list = (List)this.stack[this.stackSize - 1];
            list.add(newTop);
        } else {
            if (scope == 9) {
                throw new IllegalStateException("Sink from valueSink() was not closed");
            }
            throw new IllegalStateException("Nesting problem.");
        }
        return this;
    }
}

