/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent;

import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Profiler {
    public static void start(PrintWriter out) {
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new ThreadDump(out), 50L, 50L, TimeUnit.MILLISECONDS);
    }

    private static class ThreadDump
    implements Runnable {
        private final PrintWriter out;

        private ThreadDump(PrintWriter out) {
            this.out = out;
        }

        @Override
        public void run() {
            this.out.println("========================================");
            RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
            this.out.println(runtimeBean.getUptime());
            this.out.println();
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            ThreadInfo[] threadInfos = threadBean.getThreadInfo(threadBean.getAllThreadIds(), threadBean.isObjectMonitorUsageSupported(), false);
            long currentThreadId = Thread.currentThread().getId();
            for (ThreadInfo threadInfo : threadInfos) {
                if (threadInfo.getThreadId() == currentThreadId) continue;
                this.write(threadInfo);
            }
            this.out.flush();
        }

        private void write(ThreadInfo threadInfo) {
            if (this.capture(threadInfo)) {
                // empty if block
            }
            this.out.println(threadInfo.getThreadName() + " #" + threadInfo.getThreadId());
            this.out.println("   java.lang.Thread.State: " + (Object)((Object)threadInfo.getThreadState()));
            for (StackTraceElement ste : threadInfo.getStackTrace()) {
                this.out.println("        " + ste);
            }
            this.out.println();
        }

        private boolean capture(ThreadInfo threadInfo) {
            if (threadInfo.getThreadName().equals("main")) {
                return true;
            }
            return threadInfo.getThreadState() == Thread.State.RUNNABLE && threadInfo.getStackTrace().length > 0;
        }
    }
}

