/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;

public class AgentInitializer {
    private static final String SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.showDateTime";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.dateTimeFormat";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT = "'[opentelemetry.auto.trace 'yyyy-MM-dd HH:mm:ss:SSS Z']'";
    private static final String SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.defaultLogLevel";
    private static final Logger log;
    public static ClassLoader AGENT_CLASSLOADER;

    public static void start(Instrumentation inst, URL bootstrapURL, boolean catchAndLogException) throws Exception {
        if (catchAndLogException) {
            try {
                AgentInitializer.start(inst, bootstrapURL);
            }
            catch (Throwable t) {
                log.error("Error starting the agent", t);
            }
        } else {
            AgentInitializer.start(inst, bootstrapURL);
        }
    }

    private static void start(Instrumentation inst, URL bootstrapURL) throws Exception {
        AgentInitializer.startAgent(inst, bootstrapURL);
        boolean appUsingCustomLogManager = AgentInitializer.isAppUsingCustomLogManager();
        if (AgentInitializer.isJavaBefore9WithJFR() && appUsingCustomLogManager) {
            log.debug("Custom logger detected. Delaying Agent Tracer initialization.");
            AgentInitializer.registerLogManagerCallback(new InstallAgentTracerCallback());
        } else {
            AgentInitializer.installAgentTracer();
        }
    }

    private static void registerLogManagerCallback(ClassLoadCallBack callback) throws Exception {
        Class<?> agentInstallerClass = AGENT_CLASSLOADER.loadClass("io.opentelemetry.javaagent.tooling.AgentInstaller");
        Method registerCallbackMethod = agentInstallerClass.getMethod("registerClassLoadCallback", String.class, Runnable.class);
        registerCallbackMethod.invoke(null, "java.util.logging.LogManager", callback);
    }

    private static synchronized void startAgent(Instrumentation inst, URL bootstrapURL) throws Exception {
        if (AGENT_CLASSLOADER == null) {
            ClassLoader agentClassLoader = AgentInitializer.createAgentClassLoader("inst", bootstrapURL);
            Class<?> agentInstallerClass = agentClassLoader.loadClass("io.opentelemetry.javaagent.tooling.AgentInstaller");
            Method agentInstallerMethod = agentInstallerClass.getMethod("installBytebuddyAgent", Instrumentation.class);
            agentInstallerMethod.invoke(null, inst);
            AGENT_CLASSLOADER = agentClassLoader;
        }
    }

    private static synchronized void installAgentTracer() throws Exception {
        if (AGENT_CLASSLOADER == null) {
            throw new IllegalStateException("Agent should have been started already");
        }
        Class<?> tracerInstallerClass = AGENT_CLASSLOADER.loadClass("io.opentelemetry.javaagent.tooling.TracerInstaller");
        Method tracerInstallerMethod = tracerInstallerClass.getMethod("installAgentTracer", new Class[0]);
        tracerInstallerMethod.invoke(null, new Object[0]);
        Method logVersionInfoMethod = tracerInstallerClass.getMethod("logVersionInfo", new Class[0]);
        logVersionInfoMethod.invoke(null, new Object[0]);
    }

    private static void configureLogger() {
        AgentInitializer.setSystemPropertyDefault(SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY, "true");
        AgentInitializer.setSystemPropertyDefault(SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY, SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT);
        if (AgentInitializer.isDebugMode()) {
            AgentInitializer.setSystemPropertyDefault(SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY, "DEBUG");
        }
    }

    private static void setSystemPropertyDefault(String property, String value) {
        if (System.getProperty(property) == null) {
            System.setProperty(property, value);
        }
    }

    private static ClassLoader createAgentClassLoader(String innerJarFilename, URL bootstrapURL) throws Exception {
        ClassLoader agentParent = AgentInitializer.isJavaBefore9() ? null : AgentInitializer.getPlatformClassLoader();
        Class<?> loaderClass = ClassLoader.getSystemClassLoader().loadClass("io.opentelemetry.javaagent.bootstrap.AgentClassLoader");
        Constructor<?> constructor = loaderClass.getDeclaredConstructor(URL.class, String.class, ClassLoader.class);
        return (ClassLoader)constructor.newInstance(bootstrapURL, innerJarFilename, agentParent);
    }

    private static ClassLoader getPlatformClassLoader() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
        return (ClassLoader)method.invoke(null, new Object[0]);
    }

    private static boolean isDebugMode() {
        String tracerDebugLevelSysprop = "otel.trace.debug";
        String tracerDebugLevelProp = System.getProperty(tracerDebugLevelSysprop);
        if (tracerDebugLevelProp != null) {
            return Boolean.parseBoolean(tracerDebugLevelProp);
        }
        String tracerDebugLevelEnv = System.getenv(tracerDebugLevelSysprop.replace('.', '_').toUpperCase());
        if (tracerDebugLevelEnv != null) {
            return Boolean.parseBoolean(tracerDebugLevelEnv);
        }
        return false;
    }

    private static boolean isAppUsingCustomLogManager() {
        String tracerCustomLogManSysprop = "otel.app.customlogmanager";
        String customLogManagerProp = System.getProperty(tracerCustomLogManSysprop);
        String customLogManagerEnv = System.getenv(tracerCustomLogManSysprop.replace('.', '_').toUpperCase());
        if (customLogManagerProp != null || customLogManagerEnv != null) {
            log.debug("Prop - customlogmanager: " + customLogManagerProp);
            log.debug("Env - customlogmanager: " + customLogManagerEnv);
            return Boolean.parseBoolean(customLogManagerProp) || Boolean.parseBoolean(customLogManagerEnv);
        }
        String jbossHome = System.getenv("JBOSS_HOME");
        if (jbossHome != null) {
            log.debug("Env - jboss: " + jbossHome);
            return true;
        }
        String logManagerProp = System.getProperty("java.util.logging.manager");
        if (logManagerProp != null) {
            boolean onSysClasspath = ClassLoader.getSystemResource(logManagerProp.replaceAll("\\.", "/") + ".class") != null;
            log.debug("Prop - logging.manager: " + logManagerProp);
            log.debug("logging.manager on system classpath: " + onSysClasspath);
            return !onSysClasspath;
        }
        return false;
    }

    private static boolean isJavaBefore9() {
        return System.getProperty("java.version").startsWith("1.");
    }

    private static boolean isJavaBefore9WithJFR() {
        if (!AgentInitializer.isJavaBefore9()) {
            return false;
        }
        String jfrClassResourceName = "jdk.jfr.Recording".replace('.', '/') + ".class";
        return Thread.currentThread().getContextClassLoader().getResource(jfrClassResourceName) != null;
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("io.opentelemetry.javaagent.bootstrap.ConfigureLogging");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                Method method = clazz.getMethod("configure", new Class[0]);
                method.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            AgentInitializer.configureLogger();
        }
        log = LoggerFactory.getLogger(AgentInitializer.class);
        AGENT_CLASSLOADER = null;
    }

    protected static class InstallAgentTracerCallback
    extends ClassLoadCallBack {
        protected InstallAgentTracerCallback() {
        }

        @Override
        public String getName() {
            return "agent-tracer";
        }

        @Override
        public void execute() {
            try {
                AgentInitializer.installAgentTracer();
            }
            catch (Throwable t) {
                log.error("Error installing the agent tracer", t);
            }
        }
    }

    protected static abstract class ClassLoadCallBack
    implements Runnable {
        protected ClassLoadCallBack() {
        }

        @Override
        public void run() {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        this.execute();
                    }
                    catch (Exception e) {
                        log.error("Failed to run class loader callback {}", (Object)this.getName(), (Object)e);
                    }
                }
            });
            thread.setName("agent-startup-" + this.getName());
            thread.setDaemon(true);
            thread.start();
        }

        public abstract String getName();

        public abstract void execute();
    }
}

