/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api;

import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;

public class SafeServiceLoader {
    private static final Logger log = LoggerFactory.getLogger(SafeServiceLoader.class);

    public static <T> Iterable<T> load(Class<T> serviceClass, ClassLoader classLoader) {
        ArrayList<T> result = new ArrayList<T>();
        ServiceLoader<T> services = ServiceLoader.load(serviceClass, classLoader);
        Iterator<T> iter = services.iterator();
        while (iter.hasNext()) {
            try {
                result.add(iter.next());
            }
            catch (UnsupportedClassVersionError e) {
                log.debug("Unable to load instrumentation class: {}", (Object)e.getMessage());
            }
        }
        return result;
    }
}

