/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.concurrent;

import io.opentelemetry.javaagent.instrumentation.api.ContextStore;
import io.opentelemetry.javaagent.shaded.io.grpc.Context;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.concurrent.atomic.AtomicReference;

public class State {
    private static final Logger log = LoggerFactory.getLogger(State.class);
    public static final ContextStore.Factory<State> FACTORY = State::new;
    private final AtomicReference<Context> parentContextRef = new AtomicReference<Object>(null);

    private State() {
    }

    public void setParentContext(Context parentContext) {
        boolean result = this.parentContextRef.compareAndSet(null, parentContext);
        if (!result && this.parentContextRef.get() != parentContext && log.isDebugEnabled()) {
            log.debug("Failed to set parent context because another parent context is already set {}: new: {}, old: {}", this, parentContext, this.parentContextRef.get());
        }
    }

    public void clearParentContext() {
        this.parentContextRef.set(null);
    }

    public Context getAndResetParentContext() {
        return this.parentContextRef.getAndSet(null);
    }
}

