/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.jdbc;

import io.opentelemetry.javaagent.instrumentation.api.jdbc.DBInfo;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum JDBCConnectionUrlParser {
    GENERIC_URL_LIKE(new String[0]){

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            try {
                String path;
                URI uri = new URI(jdbcUrl);
                JDBCConnectionUrlParser.populateStandardProperties(builder, JDBCConnectionUrlParser.splitQuery(uri.getQuery(), "&"));
                String user = uri.getUserInfo();
                if (user != null) {
                    builder.user(user);
                }
                if ((path = uri.getPath()).startsWith("/")) {
                    path = path.substring(1);
                }
                if (!path.isEmpty()) {
                    builder.db(path);
                }
                if (uri.getHost() != null) {
                    builder.host(uri.getHost());
                }
                if (uri.getPort() > 0) {
                    builder.port(uri.getPort());
                }
                return builder.system(uri.getScheme());
            }
            catch (Exception e) {
                return builder;
            }
        }
    }
    ,
    JTDS_URL_LIKE(new String[0]){

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            int portLoc;
            int databaseLoc;
            String urlServerName;
            String serverName = "";
            Object port = null;
            int hostIndex = jdbcUrl.indexOf("jtds:sqlserver://");
            if (hostIndex < 0) {
                return builder;
            }
            String[] split = jdbcUrl.split(";", 2);
            if (split.length > 1) {
                Map props = JDBCConnectionUrlParser.splitQuery(split[1], ";");
                JDBCConnectionUrlParser.populateStandardProperties(builder, props);
                if (props.containsKey("instance")) {
                    builder.name((String)props.get("instance"));
                }
            }
            if (!(urlServerName = split[0].substring(hostIndex + 17)).isEmpty()) {
                serverName = urlServerName;
            }
            if ((databaseLoc = serverName.indexOf("/")) > 1) {
                builder.db(serverName.substring(databaseLoc + 1));
                serverName = serverName.substring(0, databaseLoc);
            }
            if ((portLoc = serverName.indexOf(":")) > 1) {
                builder.port(Integer.parseInt(serverName.substring(portLoc + 1)));
                serverName = serverName.substring(0, portLoc);
            }
            if (!serverName.isEmpty()) {
                builder.host(serverName);
            }
            return builder;
        }
    }
    ,
    MODIFIED_URL_LIKE(new String[0]){

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            int portLoc;
            int instanceLoc;
            String urlServerName;
            String[] split;
            String serverName = "";
            Integer port = null;
            String name = null;
            int hostIndex = jdbcUrl.indexOf("://");
            if (hostIndex <= 0) {
                return builder;
            }
            String type = jdbcUrl.substring(0, hostIndex);
            if (type.equals("db2") || type.equals("as400")) {
                if (jdbcUrl.contains("=")) {
                    int paramLoc = jdbcUrl.lastIndexOf(":");
                    split = new String[]{jdbcUrl.substring(0, paramLoc), jdbcUrl.substring(paramLoc + 1)};
                } else {
                    split = new String[]{jdbcUrl};
                }
            } else {
                split = jdbcUrl.split(";", 2);
            }
            if (split.length > 1) {
                Map props = JDBCConnectionUrlParser.splitQuery(split[1], ";");
                JDBCConnectionUrlParser.populateStandardProperties(builder, props);
                if (props.containsKey("servername")) {
                    serverName = (String)props.get("servername");
                }
            }
            if (!(urlServerName = split[0].substring(hostIndex + 3)).isEmpty()) {
                serverName = urlServerName;
            }
            if ((instanceLoc = serverName.indexOf("/")) > 1) {
                name = serverName.substring(instanceLoc + 1);
                serverName = serverName.substring(0, instanceLoc);
            }
            if ((portLoc = serverName.indexOf(":")) > 1) {
                port = Integer.parseInt(serverName.substring(portLoc + 1));
                serverName = serverName.substring(0, portLoc);
            }
            if ((instanceLoc = serverName.indexOf("\\")) > 1) {
                name = serverName.substring(instanceLoc + 1);
                serverName = serverName.substring(0, instanceLoc);
            }
            if (name != null) {
                builder.name(name);
            }
            if (!serverName.isEmpty()) {
                builder.host(serverName);
            }
            if (port != null) {
                builder.port(port);
            }
            return builder;
        }
    }
    ,
    POSTGRES(new String[]{"postgresql"}){
        private static final String DEFAULT_HOST = "localhost";
        private static final int DEFAULT_PORT = 5432;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            DBInfo dbInfo = builder.build();
            if (dbInfo.getHost() == null) {
                builder.host(DEFAULT_HOST);
            }
            if (dbInfo.getPort() == null) {
                builder.port(5432);
            }
            return GENERIC_URL_LIKE.doParse(jdbcUrl, builder);
        }
    }
    ,
    MYSQL(new String[]{"mysql", "mariadb"}){
        private static final String DEFAULT_HOST = "localhost";
        private static final int DEFAULT_PORT = 3306;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            int hostEndLoc;
            DBInfo dbInfo = builder.build();
            if (dbInfo.getHost() == null) {
                builder.host(DEFAULT_HOST);
            }
            if (dbInfo.getPort() == null) {
                builder.port(3306);
            }
            int protoLoc = jdbcUrl.indexOf("://");
            int typeEndLoc = jdbcUrl.indexOf(58);
            if (typeEndLoc < protoLoc) {
                return MARIA_SUBPROTO.doParse(jdbcUrl.substring(protoLoc + 3), builder).subtype(jdbcUrl.substring(typeEndLoc + 1, protoLoc));
            }
            if (protoLoc > 0) {
                return GENERIC_URL_LIKE.doParse(jdbcUrl, builder);
            }
            int portLoc = jdbcUrl.indexOf(":", typeEndLoc + 1);
            int dbLoc = jdbcUrl.indexOf("/", typeEndLoc);
            int paramLoc = jdbcUrl.indexOf("?", dbLoc);
            if (paramLoc > 0) {
                JDBCConnectionUrlParser.populateStandardProperties(builder, JDBCConnectionUrlParser.splitQuery(jdbcUrl.substring(paramLoc + 1), "&"));
                builder.db(jdbcUrl.substring(dbLoc + 1, paramLoc));
            } else {
                builder.db(jdbcUrl.substring(dbLoc + 1));
            }
            if (portLoc > 0) {
                hostEndLoc = portLoc;
                try {
                    builder.port(Integer.parseInt(jdbcUrl.substring(portLoc + 1, dbLoc)));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                hostEndLoc = dbLoc;
            }
            builder.host(jdbcUrl.substring(typeEndLoc + 1, hostEndLoc));
            return builder;
        }
    }
    ,
    MARIA_SUBPROTO(new String[0]){

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            int hostEndLoc;
            int clusterSepLoc = jdbcUrl.indexOf(",");
            int ipv6End = jdbcUrl.startsWith("[") ? jdbcUrl.indexOf("]") : -1;
            int portLoc = jdbcUrl.indexOf(":", Math.max(0, ipv6End));
            int dbLoc = jdbcUrl.indexOf("/", Math.max(portLoc = clusterSepLoc < portLoc ? -1 : portLoc, clusterSepLoc));
            int paramLoc = jdbcUrl.indexOf("?", dbLoc);
            if (paramLoc > 0) {
                JDBCConnectionUrlParser.populateStandardProperties(builder, JDBCConnectionUrlParser.splitQuery(jdbcUrl.substring(paramLoc + 1), "&"));
                builder.db(jdbcUrl.substring(dbLoc + 1, paramLoc));
            } else {
                builder.db(jdbcUrl.substring(dbLoc + 1));
            }
            if (jdbcUrl.startsWith("address=")) {
                return MARIA_ADDRESS.doParse(jdbcUrl, builder);
            }
            if (portLoc > 0) {
                hostEndLoc = portLoc;
                int portEndLoc = clusterSepLoc > 0 ? clusterSepLoc : dbLoc;
                try {
                    builder.port(Integer.parseInt(jdbcUrl.substring(portLoc + 1, portEndLoc)));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                int n = hostEndLoc = clusterSepLoc > 0 ? clusterSepLoc : dbLoc;
            }
            if (ipv6End > 0) {
                builder.host(jdbcUrl.substring(1, ipv6End));
            } else {
                builder.host(jdbcUrl.substring(0, hostEndLoc));
            }
            return builder;
        }
    }
    ,
    MARIA_ADDRESS(new String[0]){
        private final Pattern HOST_REGEX = Pattern.compile("\\(\\s*host\\s*=\\s*([^ )]+)\\s*\\)");
        private final Pattern PORT_REGEX = Pattern.compile("\\(\\s*port\\s*=\\s*([\\d]+)\\s*\\)");
        private final Pattern USER_REGEX = Pattern.compile("\\(\\s*user\\s*=\\s*([^ )]+)\\s*\\)");

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            Matcher userMatcher;
            Matcher portMatcher;
            Matcher hostMatcher;
            int addressEnd = jdbcUrl.indexOf(",address=");
            if (addressEnd > 0) {
                jdbcUrl = jdbcUrl.substring(0, addressEnd);
            }
            if ((hostMatcher = this.HOST_REGEX.matcher(jdbcUrl)).find()) {
                builder.host(hostMatcher.group(1));
            }
            if ((portMatcher = this.PORT_REGEX.matcher(jdbcUrl)).find()) {
                builder.port(Integer.parseInt(portMatcher.group(1)));
            }
            if ((userMatcher = this.USER_REGEX.matcher(jdbcUrl)).find()) {
                builder.user(userMatcher.group(1));
            }
            return builder;
        }
    }
    ,
    SAP(new String[]{"sap"}){
        private static final String DEFAULT_HOST = "localhost";

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            DBInfo dbInfo = builder.build();
            if (dbInfo.getHost() == null) {
                builder.host(DEFAULT_HOST);
            }
            return GENERIC_URL_LIKE.doParse(jdbcUrl, builder);
        }
    }
    ,
    MSSQLSERVER(new String[]{"jtds", "microsoft", "sqlserver"}){
        private static final String DEFAULT_HOST = "localhost";
        private static final int DEFAULT_PORT = 1433;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            int typeEndLoc;
            int protoLoc;
            DBInfo dbInfo = builder.build();
            if (dbInfo.getHost() == null) {
                builder.host(DEFAULT_HOST);
            }
            if (dbInfo.getPort() == null) {
                builder.port(1433);
            }
            if ((protoLoc = jdbcUrl.indexOf("://")) > (typeEndLoc = jdbcUrl.indexOf(58))) {
                String subtype = jdbcUrl.substring(typeEndLoc + 1, protoLoc);
                builder.subtype(subtype);
            }
            if (jdbcUrl.startsWith("jtds:")) {
                return JTDS_URL_LIKE.doParse(jdbcUrl, builder);
            }
            return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder);
        }
    }
    ,
    DB2(new String[]{"db2", "as400"}){
        private static final int DEFAULT_PORT = 50000;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            DBInfo dbInfo = builder.build();
            if (dbInfo.getPort() == null) {
                builder.port(50000);
            }
            return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder);
        }
    }
    ,
    ORACLE(new String[]{"oracle"}){
        private static final int DEFAULT_PORT = 1521;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            int typeEndIndex = jdbcUrl.indexOf(":", "oracle:".length());
            String subtype = jdbcUrl.substring("oracle:".length(), typeEndIndex);
            jdbcUrl = jdbcUrl.substring(typeEndIndex + 1);
            builder.subtype(subtype);
            DBInfo dbInfo = builder.build();
            if (dbInfo.getPort() == null) {
                builder.port(1521);
            }
            if (jdbcUrl.contains("@")) {
                return ORACLE_AT.doParse(jdbcUrl, builder);
            }
            return ORACLE_CONNECT_INFO.doParse(jdbcUrl, builder);
        }
    }
    ,
    ORACLE_CONNECT_INFO(new String[0]){

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            String instance;
            Integer port;
            String host;
            int hostEnd = jdbcUrl.indexOf(":");
            int instanceLoc = jdbcUrl.indexOf("/");
            if (hostEnd > 0) {
                host = jdbcUrl.substring(0, hostEnd);
                int afterHostEnd = jdbcUrl.indexOf(":", hostEnd + 1);
                if (afterHostEnd > 0) {
                    port = Integer.parseInt(jdbcUrl.substring(hostEnd + 1, afterHostEnd));
                    instance = jdbcUrl.substring(afterHostEnd + 1);
                } else if (instanceLoc > 0) {
                    instance = jdbcUrl.substring(instanceLoc + 1);
                    port = Integer.parseInt(jdbcUrl.substring(hostEnd + 1, instanceLoc));
                } else {
                    String portOrInstance = jdbcUrl.substring(hostEnd + 1);
                    Integer parsedPort = null;
                    try {
                        parsedPort = Integer.parseInt(portOrInstance);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (parsedPort == null) {
                        port = null;
                        instance = portOrInstance;
                    } else {
                        port = parsedPort;
                        instance = null;
                    }
                }
            } else if (instanceLoc > 0) {
                host = jdbcUrl.substring(0, instanceLoc);
                port = null;
                instance = jdbcUrl.substring(instanceLoc + 1);
            } else {
                if (jdbcUrl.isEmpty()) {
                    return builder;
                }
                host = null;
                port = null;
                instance = jdbcUrl;
            }
            if (host != null) {
                builder.host(host);
            }
            if (port != null) {
                builder.port(port);
            }
            return builder.name(instance);
        }
    }
    ,
    ORACLE_AT(new String[0]){

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            if (jdbcUrl.contains("@(description")) {
                return ORACLE_AT_DESCRIPTION.doParse(jdbcUrl, builder);
            }
            String[] atSplit = jdbcUrl.split("@", 2);
            int userInfoLoc = atSplit[0].indexOf("/");
            String user = userInfoLoc > 0 ? atSplit[0].substring(0, userInfoLoc) : null;
            String connectInfo = atSplit[1];
            int hostStart = connectInfo.startsWith("//") ? "//".length() : (connectInfo.startsWith("ldap://") ? "ldap://".length() : 0);
            if (user != null) {
                builder.user(user);
            }
            return ORACLE_CONNECT_INFO.doParse(connectInfo.substring(hostStart), builder);
        }
    }
    ,
    ORACLE_AT_DESCRIPTION(new String[0]){
        private final Pattern HOST_REGEX = Pattern.compile("\\(\\s*host\\s*=\\s*([^ )]+)\\s*\\)");
        private final Pattern PORT_REGEX = Pattern.compile("\\(\\s*port\\s*=\\s*([\\d]+)\\s*\\)");
        private final Pattern INSTANCE_REGEX = Pattern.compile("\\(\\s*service_name\\s*=\\s*([^ )]+)\\s*\\)");

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            Matcher instanceMatcher;
            Matcher portMatcher;
            Matcher hostMatcher;
            String[] atSplit = jdbcUrl.split("@", 2);
            int userInfoLoc = atSplit[0].indexOf("/");
            if (userInfoLoc > 0) {
                builder.user(atSplit[0].substring(0, userInfoLoc));
            }
            if ((hostMatcher = this.HOST_REGEX.matcher(atSplit[1])).find()) {
                builder.host(hostMatcher.group(1));
            }
            if ((portMatcher = this.PORT_REGEX.matcher(atSplit[1])).find()) {
                builder.port(Integer.parseInt(portMatcher.group(1)));
            }
            if ((instanceMatcher = this.INSTANCE_REGEX.matcher(atSplit[1])).find()) {
                builder.name(instanceMatcher.group(1));
            }
            return builder;
        }
    }
    ,
    H2(new String[]{"h2"}){
        private static final int DEFAULT_PORT = 8082;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            String instance;
            String h2Url = jdbcUrl.substring("h2:".length());
            if (h2Url.startsWith("mem:")) {
                builder.subtype("mem").host(null).port(null);
                int propLoc = h2Url.indexOf(";");
                instance = propLoc >= 0 ? h2Url.substring("mem:".length(), propLoc) : h2Url.substring("mem:".length());
            } else if (h2Url.startsWith("file:")) {
                builder.subtype("file").host(null).port(null);
                int propLoc = h2Url.indexOf(";");
                instance = propLoc >= 0 ? h2Url.substring("file:".length(), propLoc) : h2Url.substring("file:".length());
            } else if (h2Url.startsWith("zip:")) {
                builder.subtype("zip").host(null).port(null);
                int propLoc = h2Url.indexOf(";");
                instance = propLoc >= 0 ? h2Url.substring("zip:".length(), propLoc) : h2Url.substring("zip:".length());
            } else {
                if (h2Url.startsWith("tcp:")) {
                    DBInfo dbInfo = builder.build();
                    if (dbInfo.getPort() == null) {
                        builder.port(8082);
                    }
                    return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder).system("h2").subtype("tcp");
                }
                if (h2Url.startsWith("ssl:")) {
                    DBInfo dbInfo = builder.build();
                    if (dbInfo.getPort() == null) {
                        builder.port(8082);
                    }
                    return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder).system("h2").subtype("ssl");
                }
                builder.subtype("file").host(null).port(null);
                int propLoc = h2Url.indexOf(";");
                instance = propLoc >= 0 ? h2Url.substring(0, propLoc) : h2Url;
            }
            if (!instance.isEmpty()) {
                builder.name(instance);
            }
            return builder;
        }
    }
    ,
    HSQL(new String[]{"hsqldb"}){
        private static final String DEFAULT_USER = "SA";
        private static final int DEFAULT_PORT = 9001;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            String hsqlUrl;
            int proIndex;
            String instance = null;
            DBInfo dbInfo = builder.build();
            if (dbInfo.getUser() == null) {
                builder.user(DEFAULT_USER);
            }
            if ((proIndex = (hsqlUrl = jdbcUrl.substring("hsqldb:".length())).indexOf(";")) >= 0) {
                hsqlUrl = hsqlUrl.substring(0, proIndex);
            } else {
                int varIndex = hsqlUrl.indexOf("?");
                if (varIndex >= 0) {
                    hsqlUrl = hsqlUrl.substring(0, varIndex);
                }
            }
            if (hsqlUrl.startsWith("mem:")) {
                builder.subtype("mem").host(null).port(null);
                instance = hsqlUrl.substring("mem:".length());
            } else if (hsqlUrl.startsWith("file:")) {
                builder.subtype("file").host(null).port(null);
                instance = hsqlUrl.substring("file:".length());
            } else if (hsqlUrl.startsWith("res:")) {
                builder.subtype("res").host(null).port(null);
                instance = hsqlUrl.substring("res:".length());
            } else {
                if (hsqlUrl.startsWith("hsql:")) {
                    if (dbInfo.getPort() == null) {
                        builder.port(9001);
                    }
                    return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder).system("hsqldb").subtype("hsql");
                }
                if (hsqlUrl.startsWith("hsqls:")) {
                    if (dbInfo.getPort() == null) {
                        builder.port(9001);
                    }
                    return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder).system("hsqldb").subtype("hsqls");
                }
                if (hsqlUrl.startsWith("http:")) {
                    if (dbInfo.getPort() == null) {
                        builder.port(80);
                    }
                    return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder).system("hsqldb").subtype("http");
                }
                if (hsqlUrl.startsWith("https:")) {
                    if (dbInfo.getPort() == null) {
                        builder.port(443);
                    }
                    return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder).system("hsqldb").subtype("https");
                }
                builder.subtype("mem").host(null).port(null);
                instance = hsqlUrl;
            }
            return builder.name(instance);
        }
    }
    ,
    DERBY(new String[]{"derby"}){
        private static final String DEFAULT_USER = "APP";
        private static final int DEFAULT_PORT = 1527;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            String details;
            String derbyUrl;
            String[] split;
            String instance = null;
            String host = null;
            DBInfo dbInfo = builder.build();
            if (dbInfo.getUser() == null) {
                builder.user(DEFAULT_USER);
            }
            if ((split = (derbyUrl = jdbcUrl.substring("derby:".length())).split(";", 2)).length > 1) {
                JDBCConnectionUrlParser.populateStandardProperties(builder, JDBCConnectionUrlParser.splitQuery(split[1], ";"));
            }
            if ((details = split[0]).startsWith("memory:")) {
                builder.subtype("memory").host(null).port(null);
                String urlInstance = details.substring("memory:".length());
                if (!urlInstance.isEmpty()) {
                    instance = urlInstance;
                }
            } else if (details.startsWith("directory:")) {
                builder.subtype("directory").host(null).port(null);
                String urlInstance = details.substring("directory:".length());
                if (!urlInstance.isEmpty()) {
                    instance = urlInstance;
                }
            } else if (details.startsWith("classpath:")) {
                builder.subtype("classpath").host(null).port(null);
                String urlInstance = details.substring("classpath:".length());
                if (!urlInstance.isEmpty()) {
                    instance = urlInstance;
                }
            } else if (details.startsWith("jar:")) {
                builder.subtype("jar").host(null).port(null);
                String urlInstance = details.substring("jar:".length());
                if (!urlInstance.isEmpty()) {
                    instance = urlInstance;
                }
            } else if (details.startsWith("//")) {
                int portLoc;
                String url;
                int instanceLoc;
                builder.subtype("network");
                if (dbInfo.getPort() == null) {
                    builder.port(1527);
                }
                if ((instanceLoc = (url = details.substring("//".length())).indexOf("/")) >= 0) {
                    instance = url.substring(instanceLoc + 1);
                    int protoLoc = instance.indexOf(":");
                    if (protoLoc >= 0) {
                        instance = instance.substring(protoLoc + 1);
                    }
                    url = url.substring(0, instanceLoc);
                }
                if ((portLoc = url.indexOf(":")) > 0) {
                    host = url.substring(0, portLoc);
                    builder.port(Integer.parseInt(url.substring(portLoc + 1)));
                } else {
                    host = url;
                }
            } else {
                builder.subtype("directory").host(null).port(null);
                String urlInstance = details;
                if (!urlInstance.isEmpty()) {
                    instance = urlInstance;
                }
            }
            if (host != null) {
                builder.host(host);
            }
            return builder.name(instance);
        }
    };

    private static final Logger log;
    private static final Map<String, JDBCConnectionUrlParser> typeParsers;
    private final String[] typeKeys;

    private JDBCConnectionUrlParser(String ... typeKeys) {
        this.typeKeys = typeKeys;
    }

    abstract DBInfo.Builder doParse(String var1, DBInfo.Builder var2);

    public static DBInfo parse(String connectionUrl, Properties props) {
        if (connectionUrl == null) {
            return DBInfo.DEFAULT;
        }
        if (!(connectionUrl = connectionUrl.toLowerCase()).startsWith("jdbc:")) {
            return DBInfo.DEFAULT;
        }
        String jdbcUrl = connectionUrl.substring("jdbc:".length());
        int typeLoc = jdbcUrl.indexOf(58);
        if (typeLoc < 1) {
            return DBInfo.DEFAULT;
        }
        String type = jdbcUrl.substring(0, typeLoc);
        String system = JDBCConnectionUrlParser.toDbSystem(type);
        DBInfo.Builder parsedProps = DBInfo.DEFAULT.toBuilder().system(system);
        JDBCConnectionUrlParser.populateStandardProperties(parsedProps, props);
        try {
            if (typeParsers.containsKey(type)) {
                return JDBCConnectionUrlParser.withUrl(typeParsers.get(type).doParse(jdbcUrl, parsedProps), type);
            }
            return JDBCConnectionUrlParser.withUrl(GENERIC_URL_LIKE.doParse(jdbcUrl, parsedProps), type);
        }
        catch (Exception e) {
            log.debug("Error parsing URL", e);
            return parsedProps.build();
        }
    }

    private static DBInfo withUrl(DBInfo.Builder builder, String type) {
        String host;
        DBInfo info = builder.build();
        StringBuilder url = new StringBuilder();
        url.append(type);
        url.append(':');
        String subtype = info.getSubtype();
        if (subtype != null) {
            url.append(subtype);
            url.append(':');
        }
        if ((host = info.getHost()) != null) {
            url.append("//");
            url.append(host);
            Integer port = info.getPort();
            if (port != null) {
                url.append(':');
                url.append(port);
            }
        }
        return builder.shortUrl(url.toString()).build();
    }

    private static Map<String, String> splitQuery(String query, String separator) {
        String[] pairs;
        if (query == null || query.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        for (String pair : pairs = query.split(separator)) {
            try {
                String key;
                int idx = pair.indexOf("=");
                String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                if (query_pairs.containsKey(key)) continue;
                String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
                query_pairs.put(key, value);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return query_pairs;
    }

    private static void populateStandardProperties(DBInfo.Builder builder, Map<? extends Object, ? extends Object> props) {
        if (props != null && !props.isEmpty()) {
            String portNumber;
            if (props.containsKey("user")) {
                builder.user((String)props.get("user"));
            }
            if (props.containsKey("databasename")) {
                builder.db((String)props.get("databasename"));
            }
            if (props.containsKey("databaseName")) {
                builder.db((String)props.get("databaseName"));
            }
            if (props.containsKey("servername")) {
                builder.host((String)props.get("servername"));
            }
            if (props.containsKey("serverName")) {
                builder.host((String)props.get("serverName"));
            }
            if (props.containsKey("portnumber")) {
                portNumber = (String)props.get("portnumber");
                try {
                    builder.port(Integer.parseInt(portNumber));
                }
                catch (NumberFormatException e) {
                    log.debug("Error parsing portnumber property: " + portNumber, e);
                }
            }
            if (props.containsKey("portNumber")) {
                portNumber = (String)props.get("portNumber");
                try {
                    builder.port(Integer.parseInt(portNumber));
                }
                catch (NumberFormatException e) {
                    log.debug("Error parsing portNumber property: " + portNumber, e);
                }
            }
        }
    }

    private static String toDbSystem(String type) {
        switch (type) {
            case "as400": 
            case "db2": {
                return "db2";
            }
            case "derby": {
                return "derby";
            }
            case "h2": {
                return "h2";
            }
            case "hsqldb": {
                return "hsqldb";
            }
            case "mariadb": {
                return "mariadb";
            }
            case "mysql": {
                return "mysql";
            }
            case "oracle": {
                return "oracle";
            }
            case "postgresql": {
                return "postgresql";
            }
            case "jtds": 
            case "microsoft": 
            case "sqlserver": {
                return "mssql";
            }
        }
        return "other_sql";
    }

    static {
        log = LoggerFactory.getLogger(JDBCConnectionUrlParser.class);
        typeParsers = new HashMap<String, JDBCConnectionUrlParser>();
        for (JDBCConnectionUrlParser parser : JDBCConnectionUrlParser.values()) {
            for (String key : parser.typeKeys) {
                typeParsers.put(key, parser);
            }
        }
    }
}

