/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aiappid;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aiappid.AiAppId;
import io.opentelemetry.javaagent.shaded.io.grpc.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.internal.TemporaryBuffers;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.internal.Utils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.SpanContext;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.SpanId;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.TraceId;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.TraceState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.TracingContextUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;

public class AiHttpTraceContext
implements TextMapPropagator {
    private static final PatchLogger logger = PatchLogger.getLogger(AiHttpTraceContext.class.getName());
    private static final boolean AI_BACK_COMPAT = true;
    private static final TraceState TRACE_STATE_DEFAULT = TraceState.builder().build();
    static final String TRACE_PARENT = "traceparent";
    static final String TRACE_STATE = "tracestate";
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("traceparent", "tracestate"));
    private static final String VERSION = "00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = TraceId.getHexLength();
    private static final int SPAN_ID_HEX_SIZE = SpanId.getHexLength();
    private static final int TRACE_OPTION_HEX_SIZE = TraceFlags.getHexLength();
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 3 + TRACE_ID_HEX_SIZE + 1;
    private static final int TRACE_OPTION_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
    private static final int TRACEPARENT_HEADER_SIZE = TRACE_OPTION_OFFSET + TRACE_OPTION_HEX_SIZE;
    private static final int TRACESTATE_MAX_SIZE = 512;
    private static final int TRACESTATE_MAX_MEMBERS = 32;
    private static final char TRACESTATE_KEY_VALUE_DELIMITER = '=';
    private static final char TRACESTATE_ENTRY_DELIMITER = ',';
    private static final Pattern TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN = Pattern.compile("[ \t]*,[ \t]*");
    private static final Set<String> VALID_VERSIONS;
    private static final String VERSION_00 = "00";
    private static final AiHttpTraceContext INSTANCE;

    private AiHttpTraceContext() {
    }

    public static AiHttpTraceContext getInstance() {
        return INSTANCE;
    }

    @Override
    public List<String> fields() {
        return FIELDS;
    }

    @Override
    public <C> void inject(Context context, C carrier, TextMapPropagator.Setter<C> setter) {
        List<TraceState.Entry> entries;
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(setter, "setter");
        SpanContext spanContext = TracingContextUtils.getSpan(context).getContext();
        if (!spanContext.isValid()) {
            return;
        }
        char[] chars = TemporaryBuffers.chars(TRACEPARENT_HEADER_SIZE);
        chars[0] = "00".charAt(0);
        chars[1] = "00".charAt(1);
        chars[2] = 45;
        String traceId = spanContext.getTraceIdAsHexString();
        for (int i = 0; i < traceId.length(); ++i) {
            chars[3 + i] = traceId.charAt(i);
        }
        chars[AiHttpTraceContext.SPAN_ID_OFFSET - 1] = 45;
        String spanId = spanContext.getSpanIdAsHexString();
        for (int i = 0; i < spanId.length(); ++i) {
            chars[AiHttpTraceContext.SPAN_ID_OFFSET + i] = spanId.charAt(i);
        }
        chars[AiHttpTraceContext.TRACE_OPTION_OFFSET - 1] = 45;
        spanContext.copyTraceFlagsHexTo(chars, TRACE_OPTION_OFFSET);
        setter.set(carrier, TRACE_PARENT, new String(chars, 0, TRACEPARENT_HEADER_SIZE));
        String appId = AiAppId.getAppId();
        StringBuilder requestId = new StringBuilder(TRACE_ID_HEX_SIZE + SPAN_ID_HEX_SIZE + 3);
        requestId.append('|');
        requestId.append(spanContext.getTraceIdAsHexString());
        requestId.append('.');
        requestId.append(spanContext.getSpanIdAsHexString());
        requestId.append('.');
        setter.set(carrier, "Request-Id", requestId.toString());
        if (!appId.isEmpty()) {
            setter.set(carrier, "Request-Context", "appId=" + appId);
        }
        if ((entries = spanContext.getTraceState().getEntries()).isEmpty() && appId.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(512);
        if (!appId.isEmpty()) {
            stringBuilder.append("az").append('=').append(appId);
        }
        for (TraceState.Entry entry : entries) {
            String key;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(',');
            }
            if ("az".equals(key = entry.getKey())) continue;
            stringBuilder.append(key).append('=').append(entry.getValue());
        }
        setter.set(carrier, TRACE_STATE, stringBuilder.toString());
    }

    @Override
    public <C> Context extract(Context context, C carrier, TextMapPropagator.Getter<C> getter) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(carrier, "carrier");
        Objects.requireNonNull(getter, "getter");
        SpanContext spanContext = AiHttpTraceContext.extractImpl(carrier, getter);
        if (!spanContext.isValid()) {
            return context;
        }
        return TracingContextUtils.withSpan(DefaultSpan.create(spanContext), context);
    }

    private static <C> SpanContext extractImpl(C carrier, TextMapPropagator.Getter<C> getter) {
        String traceParent = getter.get(carrier, TRACE_PARENT);
        if (traceParent == null) {
            String aiRequestId = getter.get(carrier, "Request-Id");
            if (aiRequestId != null && !aiRequestId.isEmpty()) {
                String traceIdHex;
                String legacyOperationId = AiHttpTraceContext.aiExtractRootId(aiRequestId);
                TraceState.Builder traceState = TraceState.builder().set("ai-legacy-parent-id", aiRequestId);
                ThreadLocalRandom random = ThreadLocalRandom.current();
                try {
                    traceIdHex = legacyOperationId;
                }
                catch (IllegalArgumentException e) {
                    logger.info("Request-Id root part is not compatible with trace-id.");
                    traceIdHex = TraceId.fromLongs(random.nextLong(), random.nextLong());
                    traceState.set("ai-legacy-operation-id", legacyOperationId);
                }
                String spanIdHex = SpanId.fromLong(random.nextLong());
                byte traceFlags = TraceFlags.getDefault();
                return SpanContext.createFromRemoteParent(traceIdHex, spanIdHex, traceFlags, traceState.build());
            }
            return SpanContext.getInvalid();
        }
        SpanContext contextFromParentHeader = AiHttpTraceContext.extractContextFromTraceParent(traceParent);
        if (!contextFromParentHeader.isValid()) {
            return contextFromParentHeader;
        }
        String traceStateHeader = getter.get(carrier, TRACE_STATE);
        if (traceStateHeader == null || traceStateHeader.isEmpty()) {
            return contextFromParentHeader;
        }
        try {
            TraceState traceState = AiHttpTraceContext.extractTraceState(traceStateHeader);
            return SpanContext.createFromRemoteParent(contextFromParentHeader.getTraceIdAsHexString(), contextFromParentHeader.getSpanIdAsHexString(), contextFromParentHeader.getTraceFlags(), traceState);
        }
        catch (IllegalArgumentException e) {
            logger.fine("Unparseable tracestate header. Returning span context without state.");
            return contextFromParentHeader;
        }
    }

    private static SpanContext extractContextFromTraceParent(String traceparent) {
        boolean isValid;
        boolean bl = isValid = (traceparent.length() == TRACEPARENT_HEADER_SIZE || traceparent.length() > TRACEPARENT_HEADER_SIZE && traceparent.charAt(TRACEPARENT_HEADER_SIZE) == '-') && traceparent.charAt(2) == '-' && traceparent.charAt(SPAN_ID_OFFSET - 1) == '-' && traceparent.charAt(TRACE_OPTION_OFFSET - 1) == '-';
        if (!isValid) {
            logger.fine("Unparseable traceparent header. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        try {
            String version = traceparent.substring(0, 2);
            if (!VALID_VERSIONS.contains(version)) {
                return SpanContext.getInvalid();
            }
            if (version.equals("00") && traceparent.length() > TRACEPARENT_HEADER_SIZE) {
                return SpanContext.getInvalid();
            }
            String traceId = traceparent.substring(3, 3 + TraceId.getHexLength());
            String spanId = traceparent.substring(SPAN_ID_OFFSET, SPAN_ID_OFFSET + SpanId.getHexLength());
            if (TraceId.isValid(traceId) && SpanId.isValid(spanId)) {
                byte isSampled = TraceFlags.byteFromHex(traceparent, TRACE_OPTION_OFFSET);
                return SpanContext.createFromRemoteParent(traceId, spanId, isSampled, TRACE_STATE_DEFAULT);
            }
            return SpanContext.getInvalid();
        }
        catch (IllegalArgumentException e) {
            logger.fine("Unparseable traceparent header. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
    }

    private static TraceState extractTraceState(String traceStateHeader) {
        TraceState.Builder traceStateBuilder = TraceState.builder();
        String[] listMembers = TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN.split(traceStateHeader);
        Utils.checkArgument(listMembers.length <= 32, "TraceState has too many elements.");
        for (int i = listMembers.length - 1; i >= 0; --i) {
            String listMember = listMembers[i];
            int index = listMember.indexOf(61);
            Utils.checkArgument(index != -1, "Invalid TraceState list-member format.");
            traceStateBuilder.set(listMember.substring(0, index), listMember.substring(index + 1));
        }
        return traceStateBuilder.build();
    }

    private static String aiExtractRootId(String parentId) {
        int rootEnd = parentId.indexOf(46);
        if (rootEnd < 0) {
            rootEnd = parentId.length();
        }
        int rootStart = parentId.charAt(0) == '|' ? 1 : 0;
        return parentId.substring(rootStart, rootEnd);
    }

    static {
        INSTANCE = new AiHttpTraceContext();
        VALID_VERSIONS = new HashSet<String>();
        for (int i = 0; i < 255; ++i) {
            String version = Long.toHexString(i);
            if (version.length() < 2) {
                version = '0' + version;
            }
            VALID_VERSIONS.add(version);
        }
    }
}

