/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.context;

import io.opentelemetry.javaagent.shaded.io.grpc.Context;
import java.util.List;

public final class ContextPropagationDebug {
    private static final Context.Key<List<StackTraceElement[]>> THREAD_PROPAGATION_LOCATIONS = Context.key("thread-propagation-locations");
    private static final boolean THREAD_PROPAGATION_DEBUGGER = Boolean.getBoolean("otel.threadPropagationDebugger");

    public static boolean isThreadPropagationDebuggerEnabled() {
        return THREAD_PROPAGATION_DEBUGGER;
    }

    public static List<StackTraceElement[]> getLocations(Context context) {
        return THREAD_PROPAGATION_LOCATIONS.get(context);
    }

    public static Context withLocations(List<StackTraceElement[]> locations, Context context) {
        return context.withValue(THREAD_PROPAGATION_LOCATIONS, locations);
    }

    private ContextPropagationDebug() {
    }
}

