/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.tracer;

import io.opentelemetry.javaagent.shaded.instrumentation.api.InstrumentationVersion;
import io.opentelemetry.javaagent.shaded.io.grpc.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.EndSpanOptions;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.StatusCanonicalCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Tracer;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;

public abstract class BaseTracer {
    public static final Context.Key<Span> CONTEXT_SERVER_SPAN_KEY = Context.key("opentelemetry-trace-server-span-key");
    public static final Context.Key<Span> CONTEXT_CLIENT_SPAN_KEY = Context.key("opentelemetry-trace-auto-client-span-key");
    protected final Tracer tracer;

    public BaseTracer() {
        this.tracer = OpenTelemetry.getTracer(this.getInstrumentationName(), this.getVersion());
    }

    public BaseTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public Span startSpan(Class<?> clazz) {
        String spanName = this.spanNameForClass(clazz);
        return this.startSpan(spanName, Span.Kind.INTERNAL);
    }

    public Span startSpan(Method method) {
        String spanName = this.spanNameForMethod(method);
        return this.startSpan(spanName, Span.Kind.INTERNAL);
    }

    public Span startSpan(String spanName, Span.Kind kind) {
        return this.tracer.spanBuilder(spanName).setSpanKind(kind).startSpan();
    }

    public Scope startScope(Span span) {
        return this.tracer.withSpan(span);
    }

    public Span getCurrentSpan() {
        return this.tracer.getCurrentSpan();
    }

    protected abstract String getInstrumentationName();

    protected String getVersion() {
        return InstrumentationVersion.VERSION;
    }

    public String spanNameForMethod(Method method) {
        return this.spanNameForClass(method.getDeclaringClass()) + "." + method.getName();
    }

    protected String spanNameForMethod(Class<?> clazz, Method method) {
        return this.spanNameForMethod(clazz, null == method ? null : method.getName());
    }

    protected String spanNameForMethod(Class<?> cl, String methodName) {
        return this.spanNameForClass(cl) + "." + methodName;
    }

    public String spanNameForClass(Class<?> clazz) {
        String pkgName;
        if (!clazz.isAnonymousClass()) {
            return clazz.getSimpleName();
        }
        String className = clazz.getName();
        if (clazz.getPackage() != null && !(pkgName = clazz.getPackage().getName()).isEmpty()) {
            className = clazz.getName().replace(pkgName, "").substring(1);
        }
        return className;
    }

    public void end(Span span) {
        this.end(span, -1L);
    }

    public void end(Span span, long endTimeNanos) {
        if (endTimeNanos > 0L) {
            span.end(EndSpanOptions.builder().setEndTimestamp(endTimeNanos).build());
        } else {
            span.end();
        }
    }

    public void endExceptionally(Span span, Throwable throwable) {
        this.endExceptionally(span, throwable, -1L);
    }

    public void endExceptionally(Span span, Throwable throwable, long endTimeNanos) {
        span.setStatus(StatusCanonicalCode.ERROR);
        this.onError(span, this.unwrapThrowable(throwable));
        this.end(span, endTimeNanos);
    }

    protected void onError(Span span, Throwable throwable) {
        this.addThrowable(span, throwable);
    }

    protected Throwable unwrapThrowable(Throwable throwable) {
        return throwable instanceof ExecutionException ? throwable.getCause() : throwable;
    }

    public void addThrowable(Span span, Throwable throwable) {
        span.recordException(throwable);
    }

    public static Span getCurrentServerSpan() {
        return BaseTracer.getCurrentServerSpan(Context.current());
    }

    public static Span getCurrentServerSpan(Context context) {
        return CONTEXT_SERVER_SPAN_KEY.get(context);
    }
}

