/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.tracer;

import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.utils.NetPeerUtils;
import io.opentelemetry.javaagent.shaded.io.grpc.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.StatusCanonicalCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.TracingContextUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.attributes.SemanticAttributes;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;

public abstract class DatabaseClientTracer<CONNECTION, QUERY>
extends BaseTracer {
    private static final String DB_QUERY = "DB Query";
    protected final Tracer tracer = OpenTelemetry.getTracer(this.getInstrumentationName(), this.getVersion());

    public Span startSpan(CONNECTION connection, QUERY query) {
        String normalizedQuery = this.normalizeQuery(query);
        Span span = this.tracer.spanBuilder(this.spanName(normalizedQuery, connection)).setSpanKind(Span.Kind.CLIENT).setAttribute(SemanticAttributes.DB_SYSTEM, this.dbSystem(connection)).startSpan();
        if (connection != null) {
            this.onConnection(span, connection);
            this.setNetSemanticConvention(span, connection);
        }
        this.onStatement(span, normalizedQuery);
        return span;
    }

    @Override
    public Scope startScope(Span span) {
        Context clientSpanContext = Context.current().withValue(CONTEXT_CLIENT_SPAN_KEY, span);
        Context newContext = TracingContextUtils.withSpan(span, clientSpanContext);
        return ContextUtils.withScopedContext(newContext);
    }

    @Override
    public Span getCurrentSpan() {
        return this.tracer.getCurrentSpan();
    }

    public Span getClientSpan() {
        Context context = Context.current();
        return (Span)CONTEXT_CLIENT_SPAN_KEY.get(context);
    }

    @Override
    public void end(Span span) {
        span.end();
    }

    @Override
    public void endExceptionally(Span span, Throwable throwable) {
        this.onError(span, throwable);
        this.end(span);
    }

    protected Span onConnection(Span span, CONNECTION connection) {
        span.setAttribute(SemanticAttributes.DB_USER, this.dbUser(connection));
        span.setAttribute(SemanticAttributes.DB_NAME, this.dbName(connection));
        span.setAttribute(SemanticAttributes.DB_CONNECTION_STRING, this.dbConnectionString(connection));
        return span;
    }

    @Override
    protected void onError(Span span, Throwable throwable) {
        if (throwable != null) {
            span.setStatus(StatusCanonicalCode.ERROR);
            this.addThrowable(span, throwable instanceof ExecutionException ? throwable.getCause() : throwable);
        }
    }

    protected void setNetSemanticConvention(Span span, CONNECTION connection) {
        NetPeerUtils.setNetPeer(span, this.peerAddress(connection));
    }

    protected void onStatement(Span span, String statement) {
        span.setAttribute(SemanticAttributes.DB_STATEMENT, statement);
    }

    protected abstract String normalizeQuery(QUERY var1);

    protected abstract String dbSystem(CONNECTION var1);

    protected String dbUser(CONNECTION connection) {
        return null;
    }

    protected String dbName(CONNECTION connection) {
        return null;
    }

    protected String dbConnectionString(CONNECTION connection) {
        return null;
    }

    protected abstract InetSocketAddress peerAddress(CONNECTION var1);

    private String spanName(String query, CONNECTION connection) {
        if (query != null) {
            return query;
        }
        String result = null;
        if (connection != null) {
            result = this.dbName(connection);
        }
        return result == null ? DB_QUERY : result;
    }
}

